#include "mbed.h"
#include "Pixy.h"

Pixy pixyL(Pixy::SPI, p11, p12, p13);
Pixy pixyR(Pixy::SPI, p5, p6, p7);
Serial pc(USBTX, USBRX);


int main() {
    pc.baud(115200);
    pixyL.setSerialOutput(&pc);
    pixyR.setSerialOutput(&pc);
    pc.printf("Hello World!\n\r");
    while (1) {
        static int i = 0;
        int j;
        uint16_t blocks;
  
        blocks = pixyL.getBlocks();
  
        if (blocks) {
            i++;
    
                //pc.printf("Detected %d:\n\r", blocks);
                //pc.printf("\n\r");
                for (j = 0; j < blocks; j++) {
                 //   pc.printf("  block %d: \n\r", j);
                    pixyL.blocks[j].print(pc);
                }
            
        }
        
        blocks = pixyR.getBlocks();
  
        if (blocks) {
            i++;
    
                //pc.printf("Detected %d:\n\r", blocks);
                //pc.printf("\n\r");
                for (j = 0; j < blocks; j++) {
                 //   pc.printf("  block %d: \n\r", j);
                    pixyR.blocks[j].print(pc);
                }
            
        }
        pc.printf("\n\r");
    }  
}