#include "mbed.h"
#include "ADJDs311.h"

/**
 * An example program using the ADJD-S311 color sensor to obtain the reflexive
 * color of objects.
 */
 
ADJDs311 colorSensor(p28, p27, p23);
Serial pc(USBTX, USBRX);

int main() {
RGBC color;
RGBC cap;
RGBC inte;
RGBC offset;
    
    
    colorSensor.ledMode(true);  // turn on the on board led
    pc.printf("Calibartion started.\n\rPress any key to continue...\n\r");
    
    while(!pc.readable());     // waiting for the setup of calibration (the brightest condition to be measued)
   
    colorSensor.calibrate();   // calibrate the sensor to get the optimised gain

   while(pc.readable())         // discard extra char input
    {
        pc.getc();
    }
   
    pc.printf("Getting offset\n\rPress any key to continue...\n\r");
     while(!pc.readable());     // waiting for the set up of calibration (the brightest condition to be measued)
    
    offset = colorSensor.setOffset();   // get and set the color offset to compensate on board LED color
    
    while(pc.readable())        // discard extra char input
    {
        pc.getc();
    }
    
    cap = colorSensor.getColorCap();    // get the gain of the capacitors
    inte = colorSensor.getColorInt();   // get the gain of integration time slot
    pc.printf("\n\n\n\rCalibartion completed.\n\r");
    pc.printf("\nCaps:\t\tr: %4d,\tg: %4d,\tb: %4d,\tc: %4d\n\r", cap.red, cap.green, cap.blue, cap.clear);
    pc.printf("Ints:\t\tr: %4d,\tg: %4d,\tb: %4d,\tc: %4d\n\r", inte.red, inte.green, inte.blue, inte.clear);
   pc.printf("Offsets:\tr: %4d,\tg: %4d,\tb: %4d,\tc: %4d\n\r", offset.red, offset.green, offset.blue, offset.clear);
    pc.printf("\nPress any key to continue\n\r");
    while(!pc.readable());  // waiting calibration and offset info confirmation
    while(pc.readable())    // discard extra char input
    {
        pc.getc();      
    }
    colorSensor.ledMode(true);  // node that wetOffset will turn off the on board LED automatically. Need to turn it on again
    while(1) {
        color = colorSensor.read();     // get the rgb and clear data from sensor
        pc.printf("red: %4d,\tgreen: %4d,\tblue: %4d,\tclear: %4d\r", color.red, color.green, color.blue, color.clear);
        wait(0.15);
    }    
}