#ifndef MOTOR_H
#define MOTOR_H
class Motor
{
public:
    Motor(DigitalOut ma,DigitalOut mb,PwmOut ms)
        : motorA(ma),motorB(mb),motorS(ms),motorSpeed(0),direction(0) {}
    Motor(PinName pa,PinName pb,PinName ps)
        : motorA(DigitalOut(pa)),motorB(DigitalOut(pb)),motorS(PwmOut(ps)),motorSpeed(0),direction(0) {}
    
    void setSpeed(float speed);
    void setDefaultDirection(int dir) {
        direction = dir;
    }
    
    void operator = (float f){
        setSpeed(f);
    }
    
    operator float(){
        return motorSpeed;
    }

private:
    DigitalOut motorA,motorB;
    PwmOut motorS;
    float motorSpeed;
    int direction;

};



#endif