#include "mbed.h"
#include "emic2.h"
#include "uLCD_4DGL.h"
#include<string>

using namespace std;
//serial RX,TX pins to emic
uLCD_4DGL uLCD(p28,p27,p5); // serial tx, serial rx, reset pin;
#define length_sprite 20
#define width_sprite 75
#define width_sprite2 47
#define length_sprite2 18

#define Q 0x808000 //OLIVE
#define I 0x008000 //GREEN
#define S 0xC0C0C0 //SILVER
#define R 0xF1C40F //YELLOW
#define O 0xF39C12 //ORANGE
#define X 0xFFFFFF //WHITE
#define B 0x0000FF //BLUE
#define G 0xAAB7B8 //GREY
#define D 0x797D7F //DARK GREY
#define L 0x00FF00 //LIME
#define P 0xFF00FF //K
#define _ 0x000000 //BLACK
#define r 0xFF0000 //RED


class TMP36{
public:
TMP36(PinName pin);
 TMP36();
float read();
private:
//class sets up the AnalogIn pin
AnalogIn _pin;
};
TMP36::TMP36(PinName pin) : _pin(pin) {} //This is an initializer list
float TMP36::read()
{
//convert sensor reading to temperature in degrees C
return ((_pin.read()*3.3)-0.500)*100.0;
//read() function returns a normalized value of the voltage from 0 to 1 as a float }
//instantiate new class to set p15 to analog input //to read and convert TMP36 sensor's voltage output
}
TMP36 myTMP36(p20); // analog in pin for temp sensor


// make 3 different sprites
// decrease the sprite dimensions to increasing processing speed
// for the glove sprite appearing in the beginning
int Glove[length_sprite*width_sprite] = {
    _,_,_,_,R,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,R,_,S,S,S,S,S,S,_,O,_,_,_,_,_,r,r,r,r,r,_,D,D,D,D,D,D,_,I,I,_,_,_,_,_,_,_,I,I,_,R,R,R,R,R,R,_,_,_,_,_,_,
    _,_,_,_,_,R,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,R,_,_,S,_,_,_,_,_,_,O,_,_,_,_,_,r,_,_,_,_,_,D,_,_,_,_,D,_,I,_,I,_,_,_,_,_,I,_,I,_,R,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,R,_,_,_,_,_,R,R,_,_,_,_,_,_,R,_,_,_,S,_,_,_,_,_,_,O,_,_,_,_,_,r,_,_,_,_,_,D,_,_,_,_,D,_,I,_,_,I,_,_,_,I,_,_,I,_,R,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,R,_,_,_,R,_,_,R,_,_,_,_,R,_,_,_,_,S,S,S,S,_,_,_,O,_,_,_,_,_,r,_,_,_,_,_,D,_,_,_,_,D,_,I,_,_,_,I,_,I,_,_,_,I,_,R,R,R,R,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,R,_,R,_,_,_,_,R,_,_,R,_,_,_,_,_,S,_,_,_,_,_,_,O,_,_,_,_,_,r,_,_,_,_,_,D,_,_,_,_,D,_,I,_,_,_,_,I,_,_,_,_,I,_,R,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,R,_,_,_,_,_,_,R,R,_,_,_,_,_,_,S,_,_,_,_,_,_,O,_,_,_,_,_,r,_,_,_,_,_,D,_,_,_,_,D,_,I,_,_,_,_,_,_,_,_,_,I,_,R,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,S,S,S,S,S,S,_,O,O,O,O,O,_,r,r,r,r,r,_,D,D,D,D,D,D,_,I,_,_,_,_,_,_,_,_,_,I,_,R,R,R,R,R,R,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,G,G,G,G,G,G,G,G,_,_,B,B,B,B,B,B,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,_,_,_,_,_,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,G,_,_,_,_,_,_,B,B,B,B,B,B,B,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
};


int Fourty_One_Eighty[width_sprite2*length_sprite2]= {
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,G,G,G,G,G,G,G,G,_,_,_,B,B,B,B,B,B,B,B,B,_,
    _,_,_,_,_,_,_,_,_,_,_,L,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,L,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,L,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,L,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,L,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,L,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,L,L,L,L,L,L,L,L,_,_,_,_,O,O,O,_,_,_,_,_,G,G,G,G,G,G,G,G,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,G,G,G,G,G,G,G,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,_,_,_,_,_,_,_,G,_,_,_,B,_,_,_,_,_,_,_,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,L,_,_,_,_,O,O,O,_,_,_,_,_,G,G,G,G,G,G,G,G,G,_,_,_,B,B,B,B,B,B,B,B,B,_,
    _,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,

};
 
 
Serial xbee1(p9,p10);
DigitalOut rst1(p11);

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
//emic2 myTTS(p13, p14);
AnalogIn a1(p15);
AnalogIn a2(p16);
AnalogIn a3(p17);
AnalogIn a4(p18);
AnalogIn a5(p19);
Serial pc(USBTX, USBRX);
float i1;
float i2;
float i3;
float i4;
float i5;
float ref1;
float ref2;
float ref3;
float ref4;
float ref5;
float avg1;
float avg2;
float avg3;
float avg4;
float avg5;
float diff1, diff2, diff3, diff4, diff5;
int counter;
float sum;
int main() {
    float tempC, tempF;
    int i = 0;
    uLCD.BLIT(30,30,width_sprite, length_sprite, Glove);
    wait(1);
    uLCD.cls();

    uLCD.BLIT(30,30, width_sprite2, length_sprite2, Fourty_One_Eighty);

    wait(1.0);


    for (unsigned int j = 0; j <= 128; j+=7){
        // DRAW ----  animation of walls
    uLCD.line(j,127,j+7,0,RED); // horizontal  animation
    uLCD.line(j+1, 127, j+8, 0, RED);

    uLCD.line(127 - j, 0, 127 - (j+7), 127, BLUE);
    uLCD.line(127-j-1,0,127 - (j+8), 127, BLUE);

    // Erase
    wait(.1);
    uLCD.line(j,127,j+7,0,BLACK);
    uLCD.line(j+1, 127, j+8, 0, BLACK);
    uLCD.line(127 - j, 0, 127 - (j+7), 127, BLACK);  // vertical  animation
    uLCD.line(127-j-1,0,127 - (j+8), 127, BLACK);
    }

    uLCD.cls();

    
    
    ref1 = 0;
    ref2 = 0;
    ref3 = 0;
    ref4 = 0;
    ref5 = 0;
    counter = 0;
    rst1 = 0;
    wait_ms(1); 
    rst1 = 1;
    wait_ms(1);
    char o;
    while(1) {
        wait(0.5);
        i1 = a1;
        i2 = a2;
        i3 = a3;
        i4 = a4;
        i5 = a5;
        ref1 += i1;
        ref2 += i2;
        ref3 += i3;
        ref4 += i4;
        ref5 += i5;
        avg1 = ref1 / counter;
        avg2 = ref2 / counter;
        avg3 = ref3 / counter;
        avg4 = ref4 / counter;
        avg5 = ref5 / counter;
        o = 'I';
        myled1 = 0;
        myled2 = 0;
        myled3 = 0;
        myled4 = 0;
        diff1 = i1 - avg1;
        diff2 = i2 - avg2;
        diff3 = i3 - avg3;
        diff4 = i4 - avg4;
        diff5 = i5 - avg5;
        if (diff1 > 0.01) {
            o = 'A';
            ref1 -= i1;
            myled1 = 1;
        } else if (diff2 > 0.01)
        {
            o = 'B';
            ref2 -= i2;
            myled2 = 1;
        } else if (diff3 > 0.01)
        {
            o = 'C';
            ref3 -= i3;
            myled3 = 1;
        } else if (diff4 > 0.01)
        {
            o = 'D';
            ref4 -= i4;
            myled4 = 1;
        } else if (diff5 > 0.01)
        {
            o = 'E';
            ref5 -= i5;
            myled1 = 1;
            myled2 = 1;
        } else {
            counter++;
        }
        xbee1.putc(o);
        
        pc.printf("%4.2f,  %4.2f\r\n", avg4, diff4);
        uLCD.filled_circle(63,63,63, 0x0000ff);

        uLCD.baudrate(3000000);
        //uLCD.set_font_size(3,3);
        /*
        uLCD.text_char('B', 9, 8, BLACK);
        uLCD.text_char('I',10, 8, BLACK);
        uLCD.text_char('G',11, 8, BLACK);
        uLCD.text_italic(ON); */
        if (i == 0){
        uLCD.locate(40,40);
        uLCD.text_italic(ON);
        uLCD.text_string("Welcome to 4180", 0, 5, FONT_7X8, WHITE);
        uLCD.text_italic(ON);
        wait(0.2);
        uLCD.cls();
        uLCD.text_string("Final", 0, 9, FONT_7X8, WHITE);
        uLCD.text_string("Project", 0, 11, FONT_7X8, WHITE);

        i++; uLCD.cls();
        uLCD.filled_circle(63,63,63, 0x0000ff);
        wait(0.2);
        }
    
        tempC = myTMP36.read(); //convert to degrees F
        tempF = (9.0*tempC)/5.0 + 32.0; //print current temp
    
        uLCD.locate(0,0);
        uLCD.printf("%5.2f C %5.2f F \n\r", tempC, tempF);
    
    
        uLCD.filled_rectangle(40, 127, 50, 127 - 2*tempC , 0xFF0000); // MAX- Celcius 64 for celcius bar
        uLCD.filled_rectangle(60, 127, 70, 127 - tempF, 0xFFFF00); // MAX- farenheit yellow for farenheit bar
        wait(0.2);
       // uLCD.cls();
       uLCD.filled_rectangle(0,0,127, 7, 0x000000);
       uLCD.filled_circle(63,63,63, 0x0000ff);
       uLCD.filled_rectangle(40, 127, 50, 127 - 2*tempC , 0x000000); // ERASE
       uLCD.filled_rectangle(60, 127, 70, 127 - tempF, 0x000000); // MAX- farenheit yellow for farenheit bar
    }
}
