/* LIBRARIES */
#include "mbed.h" 
#include "C12832.h"
#include "string.h"
/*--------------------*/

/*OUTPUT AND INPUT CONFIGURATION*/
Serial xbee1(p9, p10); //pin declaration for the xbee module on the board 
Serial cinterion(p13,p14);  //pin declaration for the cinterion module on the board
DigitalOut myled(LED1); //pin declaration for the blinking LED on the board
DigitalOut myled2 (LED2);
DigitalOut myled3 (LED3);
DigitalOut myled4 (LED4);
C12832 lcd(p5, p7, p6, p8, p11); //pin declaration for the LCD screen on the board
/*--------------------------*/

/*FUNCTION PROTOTYPE*/
float decryption (float sens2, char sens);
/*----------------------*/

/*VARIABLES DEFINITION*/
char X; //definition of a character
char temp,volt,current,lumi;     //definition of four variables matching the 4 differents type of data that the board receive
float temp2, current2,volt2, lumi2; // which are temperature, voltage, current, and luminosity
char NumTel[] = "07404054906"; //Mobile number to which the values will be sent
char inchar,inchar1,inchar2,inchar3,inchar4,inchar5; // variables used for the SMS 
/*-----------------------------------------*/


/*------------*/
/*MAIN PROGRAM*/
/*------------*/


void FlushGSM(void) { char char1 = 0; while (cinterion.readable()) { char1 = cinterion.getc(); } return; }  //function that clean out the reception buffer of the SIM card


//----CALLBACK FUNCTIONS----//
//This one will interrupt the program when the cinterion will be receiving a SMS// 
void callback2() 
 {  
  inchar = cinterion.getc(); // I am copying several value to be sure that this is the right command
  inchar1 = cinterion.getc();
  inchar2 = cinterion.getc();
  inchar3 = cinterion.getc();
  inchar4 = cinterion.getc();
  inchar5 = cinterion.getc();
  if ((inchar == 0x0D)&&(inchar1 == 0x0A)&&(inchar2 == '+')&&(inchar3 == 'C')&&(inchar4 == 'M')&& (inchar5 == 'T')) // if the incoming command is "+CMTI", a new SMS has been received
      {
        myled4=1;
        cinterion.printf("AT+CMGD=1"); //AT command to delete the last SMS, to never be out of space
        cinterion.putc(0x0D);          //"enter"
        wait(1);
        FlushGSM();                    //clear the reception buffer
        wait(0.5);
        cinterion.printf("AT+CMGF=1");   //Text mode activated for the SMS
        cinterion.putc(0x0D);           //"enter"
        wait(1);
        myled2=1;
        cinterion.printf("AT+CMGS=%s", NumTel);  //AT command to send a SMS to the mobile number set 
        cinterion.putc(0x0D);                    //"enter"
        wait(1) ;
        cinterion.printf("Temperature: %.2f, Current: %.2f,Voltage: %.2f, Luminosity: %.2f" , temp2, current2, volt2, lumi2); //the results are send by SMS
        cinterion.putc(0x1A);              //ASCII code for Ctrl+Z
        wait(5);                           //there are a lot of delays, to be sure that the command are sent
        myled2=0;
        FlushGSM();                       //clear the reception buffer
        myled4=0;
      
      }
 }



//This one will interrupt the program when the xbee will be receiving data// 
 void callback()    
    {   
        X =  xbee1.getc(); //the values received are put into the X variable
        if (X == 0xEE) //if X equals the start bit
            {   myled = 1; 
                temp = xbee1.getc();   //the next value that the xbee receive is the temperature, then the current, the voltage and finally the luminosity
                current = xbee1.getc();
                volt = xbee1.getc();
                lumi = xbee1.getc();
               
                temp2 = decryption(temp2, temp);  //decryption of the values received
                current2 = decryption(current2, current);
                volt2 = decryption (volt2, volt) ;
                lumi2 = decryption(lumi2, lumi);
            }
            
        if (X == 0xFF) //if X equals the final bit
            { 
            myled = 0; //LED is off when the string stops
            lcd.cls();
            lcd.locate(0,0);
            lcd.printf("Temperature: %.2f, Current: %.2f,Voltage: %.2f, Luminosity: %.2f" , temp2, current2, volt2, lumi2); //the board monitor the results on the LCD Screen
            xbee1.printf("Temperature : %f , Current : %f , Voltage : %f , Luminosity : %f " , temp2, current2, volt2, lumi2); //the board sends the results to the PC thanks to the xbee
            }
    } 
    
 
    
 float decryption(float sens2, char sens) // decryption function
       {
         sens >>=2; //shift bit to the right
         sens2 = (float)sens/50 ;  //division
         return sens2;
       }  
       
  
    
 //----MAIN FUNCTION----//   
 int main() 
    {
        cinterion.printf("AT+CNMI=1,1,0,0,1"); //configure the cinterion board to be warned when a new SMS is received
        cinterion.putc(0x0D);                  // ASCII code for the "enter" key
        FlushGSM();                            // clear the reception buffer
       
    while (1) //Neverending loop
          { 
          xbee1.attach(&callback); //call of the xbee callback function 
          cinterion.attach(&callback2);   //call of the cinterion callback function            
          wait(1);
          }
     }




