/*LAB_LED*/
#include "mbed.h"

#define LED_1   PA_5
#define LED_2   D12

DigitalOut led_1(LED_1);
DigitalOut led_2(LED_2);
Ticker timer_1;

int timer_1_counter;

void init_IO(void)
{
    led_1 = 0;
    led_2 = 0;
    
    timer_1_counter = 0;
}

void timer_1_interrupt()
{
    timer_1_counter += 1;
}

void init_TIMER(void)
{
    timer_1.attach_us(&timer_1_interrupt, 1000.0);//1ms interrupt period (1 KHz)
}

int main()
{
    init_IO();
    init_TIMER();
    
    while(1) 
    {
        if(timer_1_counter == 1000)
        {
            // reset timer_1_counter to zero
            timer_1_counter = 0;
            
            // led_1 flashes
            led_1 = 1;
            wait(0.2);
            led_1 = 0;
        }
    }
}