/**
@file main.h
@brief Header file containing functions prototypes, defines and golbal variables.
@brief Revision 1.0
@author John Chakweza
@date May 2015
*/

#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"
#include "N5110.h"
#include "BMP180.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

/**  
@namespace myled
@brief GPIO output for status LED
*/



///NOKIA SCREEN
///  VCC,SCE,RST,D/C,MOSI,SCLK,LED
N5110 lcd(p7,p8,p9,p10,p11,p13,p26);

char timeBuffer[14]; /// buffer used to store time string

void Sleep();///Put to sleep

void turnOff();///Turn off


void startscreen()///Display start screen

{
    lcd.printString("Welcome",15,1);  ///Print on screen
    lcd.printString("To",20,2);
    lcd.printString("My",6,3);
    lcd.printString("T & P logger",0,5);
}

///TEMPERATURE & PRESSURE SENSOR
BMP180 bmp180(p28,p27);   /// SDA, SCL

char buffer[14];///Character length

///BUZZER
PwmOut buzzer (p21);

///LEDS

DigitalOut greenled(p24);
DigitalOut redled(p23);

///POTENTIOMETER FOR BACKLIGHT CONTROL
AnalogIn pot(p18);
PwmOut backlight(p26);

///INTERRUPT
InterruptIn button(p17); ///Sleep button
int buttonFlag = 0;///Button Flag
///Interrupt Service Routine
void buttonPressed()
{
    buttonFlag = 1; ///set flag
}


int main()
{
    ///set_time(1430942878); /// initialise time to 1st January 1970
    button.rise(&buttonPressed); ///event generated on rising edge

    int result();
    PHY_PowerDown(); /// Power down Ethernet interface


/// Normal mbed power level for this setup is around 690mW
///assuming 5V used on Vin pin
/// If you don't need networking...
/// Power down Ethernet interface - saves around 175mW
/// Also need to unplug network cable - just a cable sucks power


    lcd.init();  /// initialise display
    wait(2); /// 2 second delay
    lcd.clear();/// Clears display
    startscreen();
    wait(5); ///5 second delay
    lcd.clear();


    /// initiliase barometer
    bmp180.init();

    int temperature = 27;
    int length = sprintf(buffer,"T = %2d C",temperature); /// print formatted data to buffer
    ///it is important the format specifier ensures the length will fit in the buffer
    if (length <= 14)  /// if string will fit on display

        lcd.printString(buffer,0,1); /// display on screen



    Measurement measurement;  /// measurement structure declared in BMP180 class

    buzzer.period(1.0/50.0); ///50Hz period // higher frequency drains power

    while(1) {

        time_t seconds = time(NULL); /// get current time
/// format time into a string (time)
        strftime(timeBuffer, 14 , "%X", localtime(&seconds));


       
        lcd.printString("Weather Today",0,0);///print at 0,0)

        char buffer[14];  /// each character is 6 pixels wide, screen is 84 pixels (84/6 = 14)
        /// so can display a string of a maximum 14 characters in length
        /// or create formatted strings - ensure they aren't more than 14 characters long
        int temperature = measurement.temperature;

        backlight = 1.0 - pot;

        ///LEDS & BUZZER THRESHOLDS///

        if (measurement.temperature > 27) { ///if temperature is greater than 28deg
            redled = 1;///led on
            greenled = 0;///led off
            buzzer = 0.5;/// high temp alarm using PWM
        }

        else if  (measurement.temperature < 27) { ///if temperature is less than 28deg
            redled = 0;///led off
            greenled = 1;///led on
            buzzer = 0.0;///buzzer off
        }




        int length = sprintf(buffer,"T = %2d C",temperature); /// print formatted data to buffer
        /// it is important the format specifier ensures the length will fit in the buffer
        if (length <= 14)  /// if string will fit on display
            lcd.printString(buffer,0,1); /// display on screen

        float pressure = measurement.pressure;  /// same idea with floats
        length = sprintf(buffer,"P = %.2f mb",pressure);///print formatted data to buffer


        if (length <= 14)
            lcd.printString(buffer,0,2);///print
        lcd.printString(timeBuffer,0,3);///print


        /// read values (T in Celsius and P in mb) and print over serial port
        measurement = bmp180.readValues();

        wait(1.0);  /// 1 second until next reading

        lcd.printString("Press But1",0,4); ///print
        lcd.printString("to sleep/wake",0,5);///print

        /// BUTTON INTERRUPT///
        if (buttonFlag) {  ///if flag is set
            buttonFlag = 0; /// reset flag
            greenled = 0;  /// turn off greenled
            redled = 0;  /// turn off redled
            buzzer = 0.0; /// turn off buzzer
            lcd.turnOff();  /// turn off lcd

            while (1) {
                if (buttonFlag) {  ///if flag is set
                    buttonFlag = 0; /// reset flag
                    lcd.init(); ///Initialise display
                    break;
                }
                Sleep();  // put to sleep until next interrupt
            }

        }

    }


}

#endif