#include "mbed.h"
#include "LCD_DISCO_L476VG.h"
#include "COMPASS_DISCO_L476VG.h"
#include "nRF24L01P.h"
#define TRANSFER_SIZE 1


#define USE_PRINTF (1)

////////////////////////////////////////////////////////////////////////////////
// Joystick button
InterruptIn center(JOYSTICK_CENTER);
InterruptIn left(JOYSTICK_LEFT);
InterruptIn right(JOYSTICK_RIGHT);
InterruptIn up(JOYSTICK_UP);
InterruptIn down(JOYSTICK_DOWN);

////////////////////////////////////////////////////////////////////////////////
Serial pc(USBTX, USBRX); // tx, rx
nRF24L01P my_nrf24l01p(PE_15, PE_14, PE_13, PE_12, PE_10, PE_11);    // mosi, miso, sck, csn, ce, irq
////////////////////////////////////////////////////////////////////////////////
    char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];
    int txDataCnt = 0;
    int rxDataCnt = 0;
////////////////////////////////////////////////////////////////////////////////
// LEDs
DigitalOut led_green(LED1);
DigitalOut led_red(LED2);
LCD_DISCO_L476VG lcd;
COMPASS_DISCO_L476VG compass;
////////////////////////////////////////////////////////////////////////////////

int16_t AccBuffer[3];
int16_t ctrlgrp = 0;
int16_t alphacntrl = 0;
char L0 = ' ';
int16_t barval = 0;
uint8_t whileloop = 0;
char runval;
int RMV = 1;
int TMV = 1;
int sendsignal = 0;
////////////////////////////////////////////////////////////////////////////////
void center_released() {
    BSP_COMPASS_DeInit();
    BSP_COMPASS_Init();
    lcd.Clear();
}
void center_pressed() {
    lcd.Clear();
    lcd.DisplayString((uint8_t *)" SENT");
         if (alphacntrl == 1){L0 = 'A';}
    else if (alphacntrl == 2){L0 = 'B';}
    else if (alphacntrl == 3){L0 = 'C';}
    else if (alphacntrl == 4){L0 = 'D';}
    else if (alphacntrl == 5){L0 = 'E';}
    else if (alphacntrl == 6){L0 = 'F';}
    else if (alphacntrl == 7){L0 = 'G';}
    else if (alphacntrl == 8){L0 = 'H';}
    else if (alphacntrl == 9){L0 = 'I';}
    else if (alphacntrl == 10){L0 = 'J';}
    else if (alphacntrl == 11){L0 = 'K';}
    else if (alphacntrl == 12){L0 = 'L';}
    else if (alphacntrl == 13){L0 = 'M';}
    else if (alphacntrl == 14){L0 = 'N';}
    else if (alphacntrl == 15){L0 = 'O';}
    else if (alphacntrl == 16){L0 = 'P';}
    else if (alphacntrl == 17){L0 = 'Q';}
    else if (alphacntrl == 18){L0 = 'R';}
    else if (alphacntrl == 19){L0 = 'S';}
    else if (alphacntrl == 20){L0 = 'T';}
    else if (alphacntrl == 21){L0 = 'U';}
    else if (alphacntrl == 22){L0 = 'V';}
    else if (alphacntrl == 23){L0 = 'W';}
    else if (alphacntrl == 24){L0 = 'X';}
    else if (alphacntrl == 25){L0 = 'Y';}
    else if (alphacntrl == 26){L0 = 'Z';}  
    txData[0] = L0;
    my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );}
    
////////////////////////////////////////////////////////////////////////////////
void left_released() {
    barval = 0;
    whileloop = 0;
    lcd.Clear();
}
////////////////////////////////////////////////////////////////////////////////
void left_pressed() {
    lcd.Clear();
    printf("-Compass Reset-- \r\n");
    printf("\r\nHold Left Input for 3 seconds to turn off ''Recieve Mode'' \r\n");
    BSP_COMPASS_DeInit();
    BSP_COMPASS_Init();
    whileloop = 1;
    }
////////////////////////////////////////////////////////////////////////////////
void right_released() {
    lcd.Clear();
    barval = 0;
    whileloop = 0;
}
////////////////////////////////////////////////////////////////////////////////
void right_pressed() {
        lcd.Clear();
        lcd.BarLevelConfig((int16_t)barval);
        L0 = ' ';
        lcd.DisplayString((uint8_t *)" SPACE");
        txData[0] = L0;
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, TRANSFER_SIZE );
        wait(.5);
}
////////////////////////////////////////////////////////////////////////////////
void up_released() {
    lcd.Clear();
}
////////////////////////////////////////////////////////////////////////////////
void up_pressed() {
    lcd.Clear();
    ctrlgrp += 1;
    if (ctrlgrp == 7) ctrlgrp = 0;
    if (ctrlgrp == 0){
        lcd.DisplayString((uint8_t *) " ABCD ");}
    else if (ctrlgrp == 1){
        lcd.DisplayString((uint8_t *) " EFGH ");}
    else if (ctrlgrp == 2){
        lcd.DisplayString((uint8_t *) " IJKL ");}
    else if (ctrlgrp == 3){
        lcd.DisplayString((uint8_t *) " MNOP ");}
    else if (ctrlgrp == 4){
        lcd.DisplayString((uint8_t *) " QRST ");}
    else if (ctrlgrp == 5){
        lcd.DisplayString((uint8_t *) " UVWX ");}
    else if (ctrlgrp == 6){
        lcd.DisplayString((uint8_t *) " -YZ- ");}
}
////////////////////////////////////////////////////////////////////////////////
void down_released() {
    lcd.Clear();
}
////////////////////////////////////////////////////////////////////////////////
void down_pressed() {
    lcd.Clear(); 
    ctrlgrp -= 1;
    if (ctrlgrp == -1) ctrlgrp = 6;
    if (ctrlgrp == 0){
        lcd.DisplayString((uint8_t *) " ABCD ");}
    else if (ctrlgrp == 1){
        lcd.DisplayString((uint8_t *) " EFGH ");}
    else if (ctrlgrp == 2){
        lcd.DisplayString((uint8_t *) " IJKL ");}
    else if (ctrlgrp == 3){
        lcd.DisplayString((uint8_t *) " MNOP ");}
    else if (ctrlgrp == 4){
        lcd.DisplayString((uint8_t *) " QRST ");}
    else if (ctrlgrp == 5){
        lcd.DisplayString((uint8_t *) " UVWX ");}
    else if (ctrlgrp == 6){
        lcd.DisplayString((uint8_t *) " -YZ- ");}
}
////////////////////////////////////////////////////////////////////////////////
    int main() {
    uint8_t title[] = "      SEE TERMINAL";
    uint8_t stemp[7] = {0};  
    printf("WELCOME USER \r\n");
    printf("****************************************************************************** \r\n");
    printf("This user friendly program uses the STM32L476VG DISCOVERY board \r\n");
    printf("Use the on-board compass to navigate the L0s \r\n");
    printf("To use the compass tilt the board left or right horizontally \r\n");
    printf("****************************************************************************** \r\n");
    lcd.Clear();
    lcd.ScrollSentence(title, 1, 100);
////////////////////////////////////////////////////////////////////////////////    
    printf("0000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    printf("000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    printf("00000000000000000000000000000000000000000000000000000000000000000000000000000000");
    printf("0000111111111111111100011111111111111100011111000000000011111000000000000000000000");
    printf("000011111111111111110001111111111111110001110110000000011011100000000000000000000");
    printf("00001110000000000000000000000111000000000111001100000011001110000000000000000000");
    printf("0000111000000000000000000000011100000000011100011000011000111000000000000000000000");
    printf("000011100000000000000000000001110000000001110000110011000011100000000000000000000");
    printf("00001111111111111111000000000111000000000111000000111000001110000000000000000000");
    printf("0000111111111111111100000000011100000000011100000001000000111000000000000000000000");
    printf("000000000000000001110000000001110000000001110000000000000011100000000000000000000");
    printf("00000000000000000111000000000111000000000111000000000000001110000000000000000000");
    printf("0000000000000000011100000000011100000000011100000000000000111000000000000000000000");
    printf("000011111111111111110000000001110000000001110000000000000011100000000000000000000");
    printf("00001111111111111111000000000111000000000111000000000000001110000000000000000000");
    printf("0000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    printf("000000000000000000000000000000000000000000000000000000000000000000000000000000000");
    printf("00000000000000000000000000000000000000000000000000000000000000000000000000000000");
    printf("00000000000000000000000000000000000000000000000000000000000000");
    
////////////////////////////////////////////////////////////////////////////////    
    printf("Compass started \r\n");
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );
    printf("------------------------------------------------------------------------------ ");
    printf(" Welcome to the Terminal \r\n");
    printf("The Joypad is as follows: \r\n");
    printf("Left Input will reset compass \r\n");
    printf("Holding Left Input will turn off the STM32L76VG Board \r\n");
    printf("Center Input will send the selected letter \r\n");
    printf("Up Input will cycle letter control group \r\n");
    printf("Down Input will cycle letter control group \r\n");
    printf("Right Input will insert a space\r\n");
    printf("------------------------------------------------------------------------------ \r\n");
////////////////////////////////////////////////////////////////////////////////     
    // Both rise and fall edges generate an interrupt
    center.fall(&center_released);
    center.rise(&center_pressed);
    left.fall(&left_released);
    left.rise(&left_pressed);
    right.fall(&right_released);
    right.rise(&right_pressed);
    up.fall(&up_released);
    up.rise(&up_pressed);
    down.fall(&down_released);
    down.rise(&down_pressed);

    // Add pull-down on these pins
    // Warning: must be done AFTER edges setting
    left.mode(PullDown);
    right.mode(PullDown);
    up.mode(PullDown);
    down.mode(PullDown);
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTransferSize(TRANSFER_SIZE);
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();
////////////////////////////////////////////////////////////////////////////////        
    while (1) {
        wait(.75);
        compass.AccGetXYZ(AccBuffer);
        lcd.DisplayString(stemp);
////////////////////////////////////////////////////////////////////////////////
   if (RMV == 1){
       led_green = !led_green;
        if ( my_nrf24l01p.readable() ) {
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );
            if (rxDataCnt > 0){

            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {
            led_green = !led_green;
                pc.putc( rxData[i] );
            }
            }
        }
////////////////////////////////////////////////////////////////////////////////  
   if (ctrlgrp == 0)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= -6000)){
        lcd.DisplayString((uint8_t *)("   A"));
        alphacntrl = 1;}
        
    else if ((AccBuffer[0] > -5999) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   B"));
        alphacntrl = 2;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 8000)){
        lcd.DisplayString((uint8_t *)("   C"));
        alphacntrl = 3;}
        
    else if((AccBuffer[0] > 8001) && (AccBuffer[0] <= 20000)){
        lcd.DisplayString((uint8_t *)("   D"));
        alphacntrl = 4;}
    }
////////////////////////////////////////////////////////////////////////////////
       else if (ctrlgrp == 1)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= -6000)){
        lcd.DisplayString((uint8_t *)("   E"));
        alphacntrl = 5;}
        
    else if ((AccBuffer[0] > -5999) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   F"));
        alphacntrl = 6;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 8000)){
        lcd.DisplayString((uint8_t *)("   G"));
        alphacntrl = 7;}
        
    else if((AccBuffer[0] > 8001) && (AccBuffer[0] <= 20000)){
        lcd.DisplayString((uint8_t *)("   H"));
        alphacntrl = 8;}
    }
////////////////////////////////////////////////////////////////////////////////
       else if (ctrlgrp == 2)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= -6000)){
        lcd.DisplayString((uint8_t *)("   I"));
        alphacntrl = 9;}
        
    else if ((AccBuffer[0] > -5999) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   J"));
        alphacntrl = 10;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 8000)){
        lcd.DisplayString((uint8_t *)("   K"));
        alphacntrl = 11;}
        
    else if((AccBuffer[0] > 8001) && (AccBuffer[0] <= 20000)){
        lcd.DisplayString((uint8_t *)("   L"));
        alphacntrl = 12;}
    }
////////////////////////////////////////////////////////////////////////////////
       else if (ctrlgrp == 3)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= -6000)){
        lcd.DisplayString((uint8_t *)("   M"));
        alphacntrl = 13;}
        
    else if ((AccBuffer[0] > -5999) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   N"));
        alphacntrl = 14;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 8000)){
        lcd.DisplayString((uint8_t *)("   O"));
        alphacntrl = 15;}
        
    else if((AccBuffer[0] > 8001) && (AccBuffer[0] <= 20000)){
        lcd.DisplayString((uint8_t *)("   P"));
        alphacntrl = 16;}
    }
////////////////////////////////////////////////////////////////////////////////
       else if (ctrlgrp == 4)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= -6000)){
        lcd.DisplayString((uint8_t *)("   Q"));
        alphacntrl = 17;}
        
    else if ((AccBuffer[0] > -5999) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   R"));
        alphacntrl = 18;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 8000)){
        lcd.DisplayString((uint8_t *)("   S"));
        alphacntrl = 19;}
        
    else if((AccBuffer[0] > 8001) && (AccBuffer[0] <= 20000)){
        lcd.DisplayString((uint8_t *)("   T"));
        alphacntrl = 20;}
    }
////////////////////////////////////////////////////////////////////////////////
       else if (ctrlgrp == 5)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= -6000)){
        lcd.DisplayString((uint8_t *)("   U"));
        alphacntrl = 21;}
        
    else if ((AccBuffer[0] > -5999) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   V"));
        alphacntrl = 22;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 8000)){
        lcd.DisplayString((uint8_t *)("   W"));
        alphacntrl = 23;}
        
    else if((AccBuffer[0] > 8001) && (AccBuffer[0] <= 20000)){
        lcd.DisplayString((uint8_t *)("   X"));
        alphacntrl = 24;}
    }
////////////////////////////////////////////////////////////////////////////////
       else if (ctrlgrp == 6)
   {   
    if(( AccBuffer[0] > -30000) && (AccBuffer[0] <= 200)){
        lcd.DisplayString((uint8_t *)("   Y"));
        alphacntrl = 25;}
        
    else if ((AccBuffer[0] > 201) && (AccBuffer[0] <= 30000)){
        lcd.DisplayString((uint8_t *)("   Z"));
        alphacntrl = 26;}
    }
////////////////////////////////////////////////////////////////////////////////
 if (whileloop == 1)
    {
        lcd.Clear();
        barval = 1;
        lcd.BarLevelConfig((int16_t)barval);
        whileloop = 2;
        lcd.DisplayString((uint8_t *)"1 sec");
        wait(0.25);
    }
////////////////////////////////////////////////////////////////////////////////
        else if (whileloop == 2)
    {
        lcd.Clear();
        barval = 2;
        lcd.BarLevelConfig((int16_t)barval);
        whileloop = 3;
        lcd.DisplayString((uint8_t *)"2 sec");
        wait(0.25);
    }
////////////////////////////////////////////////////////////////////////////////
        else if (whileloop == 3)
    {
        lcd.Clear();
        barval = 3;
        lcd.BarLevelConfig((int16_t)barval);
        whileloop = 4;
        lcd.DisplayString((uint8_t *)"3 sec");
        wait(0.25);
    }
////////////////////////////////////////////////////////////////////////////////
        else if (whileloop == 4)
    {
        lcd.Clear();
        barval = 3;
        lcd.BarLevelConfig((int16_t)barval);
        printf("STM32L476VG Will now Turn Off! Use Reset to Reactivate!  \r\n");
        
    uint8_t title2[] = "      !!!SHUTTING DOWN!!!";
    lcd.Clear();
    lcd.ScrollSentence(title2, 1, 200);
    while (1){
    led_red = 0;
    led_green = 0;
    lcd.Clear();
    }
    }
////////////////////////////////////////////////////////////////////////////////
}
}
}
