/*
    +3.3v
      |
      \
      /  10k Résistance série
      \
      /
      |
      .-----------O Vers Anolog 0 de la carte
      |
      \
      /
  Thermistance  10k Nominal
      \
      /
      |
     ---
     GND
 *
 * Author(s): Michael Ball  unix_guru@hotmail.com
 *
 */

#include "mbed.h"
#include "millis.h"
#include "PID.h"                                       
                                        
float getTemperature();
                                        
Serial pc(USBTX, USBRX);
Ticker PrintTicker;                     // Send process results to Console once per second       
Ticker ticker;                          // Set up the millis() ticker.
                                       
#define  DEFAULT_Kp 100
#define  DEFAULT_Ki 0
#define  DEFAULT_Kd 0

#define AUTOMATIC 1
#define MANUAL    0
#define DIRECT  0
#define REVERSE  1
#define thermistor A0                       // Analog input pin A0 
#define driver PB_3                         // PWM output pin PB_3
#define PERIOD 2.0
AnalogIn Thermistor(thermistor);            // Read temperature value from thermistor on A0
PwmOut Driver(PB_3);                      // PWM drive values are 0-1.0 
                                            // For 0-100% 
float temp;             
float Input, Output, Setpoint; 
PID controller(&Input, &Output, &Setpoint, DEFAULT_Kp , DEFAULT_Ki , DEFAULT_Kd , DIRECT);

#define RATE 2.0                            // Print rate  once every two seconds
  
void PrintValues() {                        // Routine to print out results to console
    pc.printf("Input      Output     Setpoint   Kp        Ki        Kd        time\r\n");
    pc.printf("%f, %f, %f, %f, %f, %f, %d \r\n", 
            Input, Output, Setpoint, controller.GetKp() , controller.GetKi() , controller.GetKd() , millis() );

}    


int main(){
 
  startMillis();                            // Initialize timer.
 
  pc.baud(9600);    
  //pc.printf("\r\nThermistor PID Test - Build " __DATE__ " " __TIME__ "\r\n");
  
  PrintTicker.attach(&PrintValues,RATE);    // Start PID process running at 2s rate.
  controller.SetSampleTime(2000);
  Setpoint = 24;                            // Set target temperature in degrees Celcius.
  controller.SetMode(AUTOMATIC);            // Turn PID controller on.

  while(1){
   
     Input = getTemperature();              // Actual temperature in Degrees Celcius

     controller.Compute();                  // Process PID loop. 

     Driver = Output/1000;                  // Sent PWM value scaled 0 - 1.0 as mbed requires 
    
  }
 
}


float getTemperature() {
float h = Thermistor.read_u16();
    h = (h/65536)*3.3;                      //Conversion Bit to Voltage
    pc.printf("voltage %f\r\n", h);
    temp = -30.705*h+91.788;                //Converson Voltage to °C
    pc.printf("temp = %f\r\n",temp);
 
    return temp;    

}

