/*
* INCLUDES
*/
#include "mbed.h"

/*
* CONSTANTES
*/
const unsigned char AUDIO_VOLUME[10] = { 0, 28, 56, 84, 112, 140, 168, 197, 226, 255 };

/*
* VARIABLES GLOBALES
*/
unsigned int global_PWM_Period;
unsigned int global_PWM_Duty;
unsigned int global_PWM_PeriodReload;
unsigned int global_PWM_DutyReload;
unsigned int global_PWM_Counter;
unsigned int global_PWM_State;

/*
* DEFINITION DES MODULES
*/
// définitions des LEDs
//DigitalOut myLed1(LED1);
DigitalOut myLed2(LED2);
DigitalOut myLed3(LED3);
DigitalOut myLed4(LED4);
// définitions des boutons
DigitalIn myButton1(p17);
DigitalIn myButton2(p18);
DigitalIn myButton3(p19);
DigitalIn myButton4(p20);
// définitions du son
DigitalOut audioCS(p25);
SPI audioVolume(p5, NC, p7);
//DigitalOut audioPWM(p26);
DigitalOut audioPWM(LED1);
Ticker tickerPWM;

/*
* INTERRUPTIONS
*/
// interruption permettant la génération du PWM
void IRQ_PWM( void )
{
    // si un signal PWM doit etre généré
    if( global_PWM_Period ){
        // incrémente le compteur
        global_PWM_Counter++;
        // si l'état de la pin de PWM est haute ( duty < counter < period )
        if( global_PWM_State ){
            // si le compteur dépasse la période
            if( global_PWM_Counter >= global_PWM_Period ){
                // mise à 0 du signal
                audioPWM = 0;
                global_PWM_State = 0;
                // reset du counter
                global_PWM_Counter = 0;
                // recharge la période du PWM
                global_PWM_Period = global_PWM_PeriodReload;
                // recharge le rapport cyclique du PWM
                global_PWM_Duty = global_PWM_DutyReload;
            }
        // si l'état de la pîn de PWM est basse ( 0 < counter < duty )
        }else{
            // si le compteur dépasse la période
            if( global_PWM_Counter >= global_PWM_Duty ){
                // mise à 0 du signal
                audioPWM = 1;
                global_PWM_State = 1;
            }
        }
    }
}

/*
* SOUS PROGRAMMES
*/
void audio_SetVolume( unsigned int volumeIndex )
{
    audioCS = 0;
    audioVolume.write( AUDIO_VOLUME[volumeIndex] );
    audioCS = 1;
}

void UpdatePWM( unsigned int period, unsigned int duty )
{
    global_PWM_PeriodReload = period;
    global_PWM_DutyReload = duty;
}

void InitPWM( void )
{
    // définition de la fonction qui gère le signal PWM (appellée toutes les 10µs)
    tickerPWM.attach_us( &IRQ_PWM, 10 );
    // reset des variables liées au PWM
    global_PWM_Counter = 0;
    global_PWM_Period = 0;
    global_PWM_PeriodReload = 0;
    global_PWM_Duty = 0;
    global_PWM_DutyReload = 0;
    global_PWM_State = 0;
    audioPWM = 0;
}

/*
* FONCTION PRINCIPALE
*/
int main()
{
    // variable locale
    unsigned char i;
    unsigned int delay;
    unsigned char flagStart, flagSens;
    
    // initialise les variables
    i = 0;
    delay = 200;
    flagStart = 1;
    flagSens = 0;
    // boucle de fonctionnement principale
    while(1) {
/*        // si l'application est lancée
        if( flagStart )
        {
            // éteint toutes les LED
            myLed1 = 1;
            myLed2 = 1;
            myLed3 = 1;
            myLed4 = 1;
            // en fonction de la valeur de i
            switch( i & 0x03 )
            {
                case 0 :
                    myLed1 = 0;
                    break;
                case 1 :
                    myLed2 = 0;
                    break;
                case 2 :
                    myLed4 = 0;
                    break;
                case 3 :
                    myLed3 = 0;
                    break;
            }
            // délay d'attente
            wait_ms(delay);
            // si le sens est positif
            if( flagSens ){
                // incrémente le compteur
                i++;
            // si le sens est négatif
            }else{
                // décrémente le compteur
                i--;
            }
        }
*/        // si appuie sur bouton 1
        if(!myButton1){
            led = led - 0.1;
            // change l'état de marche arret
            flagStart ^= 0x01;
            // attend que le bouton soit relaché
            while( !myButton1 );
        }
        // si appuie sur bouton 2
        if(!myButton2){
            led = led + 0.1;
            // change le sens
            flagSens ^= 0x01;
            // attend que le bouton soit relaché
            while( !myButton2 );
        }
        // si appuie sur bouton 3
        if(!myButton3){
            // réduit le délay de changement
            delay -= 10;
            // attend que le bouton soit relaché
            while( !myButton3 );
        }
        // si appuie sur bouton 4
        if(!myButton4){
            // augmente le délay de changement
            delay += 10;
            // attend que le bouton soit relaché
            while( !myButton4 );
        }
    }
}
