#include "mbed.h"

#include "AD5260.h"
#include "AD5263.h"
#include "LTC2664.h"
#include "LTC234x.h"
//#include "MCP4161.h"

#include "TaskEthernet.h"
#include "LocalConfig.h"
#include "TestBoardConfig.h"
#include "ChipSelector.h"
#include "Global.h"
#include "def.h"

bool Mode0;
bool Mode1;
bool Mode2;
bool Mode3;
bool Mode4;
bool Mode5;
bool Mode6;
bool Mode7;
bool Mode6Encours;
bool SensTrig = 0;
bool ENABLE_TRACE = 1;
bool ver_carte = 0;
uint8_t debug_adc = 0;
uint16_t dac_value = 0;
uint16_t tempo_source = 50;
const version_t fw_version =  { .ver = {
                                  .major = 01,
                                  .minor = 15
                                }
                              };
TestBoardConfig cfg1;
TestBoardConfig cfg2;
TestBoardConfig cfg3;
TestBoardConfig cfg4;
TestBoardConfig cfg5;
TestBoardConfig cfg6;
BufferedSerial  pc(USBTX, USBRX, 115200);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4); 
 
void DiplayTrace(char *trace)
{
    printf("%s",trace);
}

int main() 
{   
    led1=0;
    led3=1;
    
    ChipSelector::get()->unselectAll();
    AD5260::get()->init();
    AD5263::get()->init();
    LTC2664::get()->init();
    LTC234x::get()->init();
    LocalConfig::get()->init();             

    cfg1.init(ChipSelector::CS_EEPROM_T1);  
    cfg2.init(ChipSelector::CS_EEPROM_T2);  
    cfg3.init(ChipSelector::CS_EEPROM_T3);  
    cfg4.init(ChipSelector::CS_EEPROM_T4);  
    cfg5.init(ChipSelector::CS_EEPROM_T5);  
    cfg6.init(ChipSelector::CS_EEPROM_T6);
    
    TaskEthernet::get()->init();
    ENABLE_TRACE = 0;
    while (true) 
    {
        if (Mode0) LTC234x::get()->start_capture_2348_mode0();
        if (Mode1) LTC234x::get()->start_capture_2348_mode1();
        if (Mode2) LTC234x::get()->start_capture_2348_mode2();
        if (Mode3) LTC234x::get()->start_capture_2348_mode3();
        if (Mode4) LTC234x::get()->start_capture_2348_mode4();
        if (Mode5) LTC234x::get()->start_capture_2348_mode5();
        if (Mode6) LTC234x::get()->start_capture_2348_mode6();
        if (Mode7) LTC234x::get()->start_capture_2348_mode7();
    }
}