#ifndef TestBoardConfig_h
#define TestBoardConfig_h

#include "mbed.h"

#include "ChipSelector.h"
#include "ConfigFile.h"
#include "TestBoardConfig.h"


extern char tmp_all_f[32];
extern uint16_t tmp_v0[6];
extern uint16_t tmp_v1[6];
extern uint16_t tmp_v2[6];
extern uint16_t tmp_v3[6];

class TestBoardConfig {

#define  DEFAULT_SERIAL         "Vxx.xxxx"
#define  DEFAULT_TRANSISTOR     "T0"
#define  DEFAULT_V0             "32768"
#define  DEFAULT_V1             "32768"
#define  DEFAULT_V2             "32768"
#define  DEFAULT_V3             "32768"
#define  DEFAULT_GAIN           "2"
#define  DEFAULT_ALL_F          "32768;32768;32768;32768"


//data 
private:

    ChipSelector::ChipToSelect _cs;
    bool _enabled;
    ConfigFile cfg;
    
    char _serial[16];
    char _transistor[4];
    char all_f[32];
    uint16_t _v0;
    uint16_t _v1;
    uint16_t _v2;
    uint16_t _v3;
    char _gain[4];
    
    
   void printConfig(void);
    
    
public:
    TestBoardConfig();
    void setAll(bool typ,uint8_t num_board);

    int init(ChipSelector::ChipToSelect cs);
    bool setConfig(char *key, char*value);
    bool getConfig(char *key, char *buffer, uint8_t buffer_len);
    bool getConf(uint8_t num_board,char *buffer, uint8_t buffer_len);   
    bool saveConfig();
    bool applyConfig();

    char *   get_serial();
    char *   get_transistor();
    uint16_t get_v0();
    uint16_t get_v1();
    uint16_t get_v2();
    uint16_t get_v3();
};
#endif

