#include "mbed.h"
#include "rtos.h"

#include <stdio.h>
#include <string.h>
#include <inttypes.h>
  
#include "ChipSelector.h"
#include "CAT25160.h"
#include "LTC2664.h"
#include "AD5263.h"
#include "Global.h"
#include "TestBoardConfig.h"
#include "TaskEthernet.h"

char tmp_all_f[32];
static char trace[100];
uint16_t tmp_v0[6];
uint16_t tmp_v1[6];
uint16_t tmp_v2[6];
uint16_t tmp_v3[6];

TestBoardConfig::TestBoardConfig()
{
    _enabled = false;
}

int TestBoardConfig::init(ChipSelector::ChipToSelect cs)
{
    _cs = cs;
    char value[32];
    uint8_t *buffer_config = NULL;

    _enabled = (CAT25160::get()->checkAccess(_cs) == 0?true:false);
    present[_cs] = _enabled;    
    valdefault[_cs] = _enabled;
    if (ENABLE_TRACE) {sprintf(trace,"_enabled for %d is %d\r\n",_cs, _enabled); DiplayTrace(trace);}
    
    if (_enabled == true)
    {
        buffer_config = CAT25160::get()->readConfig(_cs);
        if (buffer_config == NULL)
        {
            // on tente une deuxième fois
            thread_sleep_for(50);
            if (ENABLE_TRACE) {sprintf(trace,"TestBoard %d no EEPROM config found. TRY second read !\r\n",_cs); DiplayTrace(trace);}
            buffer_config = CAT25160::get()->readConfig(_cs);
        }
    }   

    //free(buffer_config);//debug
    //buffer_config = NULL;//debug
 
    if ( (_enabled == false) || (buffer_config == NULL) )
    {
        if (ENABLE_TRACE) {sprintf(trace,"no EEPROM config found. using default config !\r\n"); DiplayTrace(trace);}
        
        // serial
        cfg.setValue("serial",DEFAULT_SERIAL);     sprintf(_serial,"%s",DEFAULT_SERIAL);
        // transistor
        cfg.setValue("transistor",DEFAULT_TRANSISTOR);     sprintf(_transistor,"%s",DEFAULT_TRANSISTOR);
        // v0-v3
        cfg.setValue("v0",DEFAULT_V0);       _v0 = atoi(DEFAULT_V0) ;
        cfg.setValue("v1",DEFAULT_V1);       _v1 = atoi(DEFAULT_V1) ;
        cfg.setValue("v2",DEFAULT_V2);       _v2 = atoi(DEFAULT_V2) ;
        cfg.setValue("v3",DEFAULT_V3);       _v3 = atoi(DEFAULT_V3) ;
        //gain
        cfg.setValue("gain",DEFAULT_GAIN);  sprintf(_gain,"%s",DEFAULT_GAIN); 
        // all
        cfg.setValue("all",DEFAULT_ALL_F);  sprintf(all_f,"%s",DEFAULT_ALL_F);

        if (_enabled == true)
        {
            //SAVE CONFIG TO EEPROM
            buffer_config = cfg.writeBuffer();
            if (buffer_config == NULL)
            {
                if (ENABLE_TRACE) {sprintf(trace,"Error on make config!!!\r\n"); DiplayTrace(trace);}
            }
            //printf("make config %s\r\n",buffer_config);
            if ( CAT25160::get()->writeConfigCheck((uint8_t*) buffer_config,strlen((char *)buffer_config)+1,_cs) == -1)
            {       
                if (ENABLE_TRACE) {sprintf(trace,"Error on writing config !!!\r\n"); DiplayTrace(trace);}
            }
            free(buffer_config);
        }
    }
    else
    {
        if (ENABLE_TRACE) {sprintf(trace,"using ConfigFile on EEPROM\r\n"); DiplayTrace(trace);}
        cfg.readBuffer((char *)buffer_config,strlen((char *)buffer_config)+1);    
        free(buffer_config);
        
        //all
        if (cfg.getValue("all", &value[0], sizeof(value)) == true) sprintf(all_f,"%s",value); 
        else 
        {   cfg.setValue("all",DEFAULT_ALL_F); sprintf(all_f,"%s",DEFAULT_ALL_F); valdefault[_cs] = 0; }
        
        // serial
        if (cfg.getValue("serial", &value[0], sizeof(value)) == true) sprintf(_serial,"%s",value);  
        else   
        {   cfg.setValue("serial",DEFAULT_SERIAL); sprintf(_serial,"%s",DEFAULT_SERIAL); valdefault[_cs] = 0; }  

        // transistor
        if (cfg.getValue("transistor", &value[0], sizeof(value)) == true) sprintf(_transistor,"%s",value);  
        else 
        {   cfg.setValue("transistor",DEFAULT_TRANSISTOR);sprintf(_transistor,"%s",DEFAULT_TRANSISTOR); valdefault[_cs] = 0; }

        // v0-v3
        if (cfg.getValue("v0", &value[0], sizeof(value)) == true) _v0 = atoi(value); 
        else {cfg.setValue("v0",DEFAULT_V0); _v0 = atoi(DEFAULT_V0); valdefault[_cs] = 0; }
        if (cfg.getValue("v1", &value[0], sizeof(value)) == true) _v1 = atoi(value); 
        else {cfg.setValue("v1",DEFAULT_V1); _v1 = atoi(DEFAULT_V1); valdefault[_cs] = 0; }
        if (cfg.getValue("v2", &value[0], sizeof(value)) == true) _v2 = atoi(value); 
        else {cfg.setValue("v2",DEFAULT_V2); _v2 = atoi(DEFAULT_V2); valdefault[_cs] = 0; }
        if (cfg.getValue("v3", &value[0], sizeof(value)) == true) _v3 = atoi(value); 
        else {cfg.setValue("v3",DEFAULT_V3); _v3 = atoi(DEFAULT_V3); valdefault[_cs] = 0; }
        
        //gain
        if (cfg.getValue("gain", &value[0], sizeof(value)) == true) sprintf(_gain,"%s",value);  
        else 
        { cfg.setValue("gain",DEFAULT_GAIN); sprintf(_gain,"%s",DEFAULT_GAIN); valdefault[_cs] = 0; }
    }
    setAll (0,_cs);
    setConfig("all",all_f);
    printConfig();
    applyConfig();
    
    return 0;
}

void TestBoardConfig::setAll (bool typ, uint8_t num_board)
{
    char value[70];
    uint8_t i = 0;
    if (typ)
    {
        _v0 = tmp_v0[num_board]; _v1 = tmp_v1[num_board]; _v2 = tmp_v2[num_board]; _v3 = tmp_v3[num_board];
    }
    else
    {
        tmp_v0[num_board] = _v0; tmp_v1[num_board] = _v1; tmp_v2[num_board] = _v2; tmp_v3[num_board] = _v3;
    }
    sprintf(value, "%u", _v0); if (typ) cfg.setValue ("v0",value);
    memcpy((char *)&all_f[i], (char *)&value, strlen(value));   i += strlen(value); all_f[i++]=0x3b;
    sprintf(value, "%u", _v1); if (typ) cfg.setValue ("v1",value); 
    memcpy((char *)&all_f[i], (char *)&value, strlen(value));   i += strlen(value); all_f[i++]=0x3b;
    sprintf(value, "%u", _v2); if (typ) cfg.setValue ("v2",value);
    memcpy((char *)&all_f[i], (char *)&value, strlen(value));   i += strlen(value); all_f[i++]=0x3b;
    sprintf(value, "%u", _v3); if (typ) cfg.setValue ("v3",value);
    memcpy((char *)&all_f[i], (char *)&value, strlen(value));   i += strlen(value);
    for (;i<sizeof(all_f);i++)
        all_f[i]=0;
    memcpy(tmp_all_f,all_f,sizeof(all_f));
}

void TestBoardConfig::printConfig()
{
    if ( _enabled == false) 
        return;
    if (ENABLE_TRACE) 
    {
        sprintf(trace,"CONFIG:\r\n"); DiplayTrace(trace);
        sprintf(trace,"serial:%s\r\n",_serial); DiplayTrace(trace);
        sprintf(trace,"transistor:%s\r\n",_transistor); DiplayTrace(trace);
        sprintf(trace,"v0:%d\r\nv1:%d\r\nv2:%d\r\nv3:%d\r\n", _v0,_v1,_v2,_v3); DiplayTrace(trace);
        sprintf(trace,"gain:%s\r\n",_gain); DiplayTrace(trace);
        sprintf(trace,"all:%s\r\n",all_f); DiplayTrace(trace);
    }
}

bool TestBoardConfig::setConfig(char *key, char*value)
{
    if (_enabled == false)
    {
        if (ENABLE_TRACE) {sprintf(trace,"setConfig error because disabled\r\n"); DiplayTrace(trace);}
        return false;
    }

    char tmp[32];
    if (cfg.getValue(key, &tmp[0], sizeof(tmp)) == true)
    {
        return cfg.setValue(key,value); 
    }
    else
    {
        if (ENABLE_TRACE) {sprintf(trace,"setConfig : %s is not a valid parameter !!\r\n",key); DiplayTrace(trace);}
        return false;
    }
}

bool TestBoardConfig::getConfig(char *key, char *buffer, uint8_t buffer_len)
{
    if (buffer_len < 32) 
        return false;
    memset(buffer,0x0,buffer_len);

    //ConfigFile *p_cfg = NULL;
    
    if (cfg.getValue(key, &buffer[0], buffer_len) == false)
    {
        if (ENABLE_TRACE) {sprintf(trace,"setConfig : %s is not a valid parameter !!\r\n",key); DiplayTrace(trace);}
        return false;
    }
    else
        return true;
}

bool TestBoardConfig::getConf(uint8_t num_board, char *buffer, uint8_t buffer_len)
{
    char value[75];
    uint8_t i = 0;
    if (buffer_len < 32) 
        return false;
    
    memset(buffer,0x0,buffer_len);

    sprintf(value, "%u", tmp_v0[num_board]);
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_v1[num_board]); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_v2[num_board]); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_v3[num_board]); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); 
    
    return true;
}
bool TestBoardConfig::applyConfig()
{
    ChipSelector::ChipToSelect tmp_cs;
    
    if ( _enabled == false) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"no applyConfig because disabled\r\n"); DiplayTrace(trace);}
        return false;
    }
  
    switch(_cs)
    {
        case ChipSelector::CS_EEPROM_T1: 
            tmp_cs = ChipSelector::CS_DAC_T1; 
        break;
        case ChipSelector::CS_EEPROM_T2: 
            tmp_cs = ChipSelector::CS_DAC_T2; 
        break;
        case ChipSelector::CS_EEPROM_T3: 
            tmp_cs = ChipSelector::CS_DAC_T3; 
        break;
        case ChipSelector::CS_EEPROM_T4: 
            tmp_cs = ChipSelector::CS_DAC_T4; 
        break;
        case ChipSelector::CS_EEPROM_T5: 
            tmp_cs = ChipSelector::CS_DAC_T5; 
        break;
        case ChipSelector::CS_EEPROM_T6: 
            tmp_cs = ChipSelector::CS_DAC_T6; 
        break;
        default: 
            return false;
    }
    if (ENABLE_TRACE) {sprintf(trace,"applyConfig carte_fille:%d\r\n",_cs); DiplayTrace(trace);} 
    
    LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x00 /*DAC 0*/,_v0,tmp_cs); //V0
    LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x01 /*DAC 1*/,_v1,tmp_cs); //V1
    LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x02 /*DAC 2*/,_v2,tmp_cs); //V2
    LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x03 /*DAC 3*/,_v3,tmp_cs); //V3
    
    return true;       
}


bool TestBoardConfig::saveConfig()
{
    if (_enabled == false)
    {
        if (ENABLE_TRACE) {sprintf(trace,"saveConfig error because disabled\r\n"); DiplayTrace(trace);}
        return false;
    }

    uint8_t *buffer_config;
    buffer_config = cfg.writeBuffer();
    if (buffer_config == NULL)
    {
        if (ENABLE_TRACE) {sprintf(trace,"Error on make config!!!\r\n"); DiplayTrace(trace);}
        return false;
    }
    
    if ( CAT25160::get()->writeConfigCheck( buffer_config,strlen((char *)buffer_config)+1,_cs) == -1)
    {
        if (ENABLE_TRACE) {sprintf(trace,"Error on write config\r\n"); DiplayTrace(trace);}
        free(buffer_config);
        return false;
    }
    free(buffer_config);

    return true;
}



char *   TestBoardConfig::get_serial(){    return _serial;   }
char *   TestBoardConfig::get_transistor(){    return _transistor;   }

uint16_t TestBoardConfig::get_v0(){    return _v0;   }
uint16_t TestBoardConfig::get_v1(){    return _v1;   }
uint16_t TestBoardConfig::get_v2(){    return _v2;   }
uint16_t TestBoardConfig::get_v3(){    return _v3;   }
