/** Digole Serial Display library, I2C
 *
 * @Author: Digole Digital Solutions : www.digole.com ported from Arduino to mbed by Michael Shimniok www.bot-thoughts.com
 */
#ifndef TaskEthernet_h
#define TaskEthernet_h

#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "arch.h"
#include "version.h"

extern uint8_t present[6];
extern uint8_t valdefault[6];

class TaskEthernet {

private :

    typedef enum { ST_UNKNOW, ST_WAIT_IP, ST_WAIT_CONNEXION, ST_CLIENT } NetStatesType ;
    typedef enum { ST_WAIT_0X02_LEN, ST_FILL_DATA, ST_DATA_COMPLETE } PacketStatesType ;
    
    typedef struct 
    {
        uint8_t type;
        uint16_t len;
        uint16_t current_len;
        uint8_t payload[512];
        //uint8_t *payload;
    } TLV;

    static TaskEthernet sSingleton;
    Thread *mThread;
    NetStatesType    _current_state;
    //TCPSocketServer  _server2;
    //TCPSocketConnection  _client2;
    u32_t   _lastWatchDog;
    EthernetInterface _eth;
    UDPSocket _server;
    //UDPSocket _server(&_eth);
    SocketAddress pc_udp;
    
    unsigned char _buffer[256];
    uint16_t _buffer_pos;
    
    PacketStatesType _current_packet_state;
    TLV _packetTLV;
    
    TaskEthernet& operator=(const TaskEthernet&);
    TaskEthernet(const TaskEthernet&);
    int processNetData();
    int mailTLV();
    int sendTLV(uint8_t type, uint16_t len, uint8_t *datas);
    int sendTLVNoTmpBuffer(uint8_t type, uint16_t len, uint32_t offset,uint8_t *datas);
    const char *byte_to_binary(int x);

public:
    typedef struct {
      uint8_t typeTLV;
      uint16_t lenTLV;
      uint8_t datas[8];
    } mail_t;
    
    TaskEthernet() ;
    //static TCPSocketConnection  client;

    static TaskEthernet *get()  {
      return &sSingleton;
    }

    int init();
    Mail<mail_t, 6> mail_box; // 6 elements max
    bool isClientConnected();
    void startProcess();
};



#endif
