#include "mbed.h"
#include "rtos.h"

#include <stdio.h>
#include <string.h>
#include <inttypes.h>

#include "Global.h"
#include "LocalConfig.h"

#include "ChipSelector.h"
#include "LTC2664.h"
#include "MCP4161.h"
#include "LTC234x.h"
#include "CAT25160.h"
#include "AD5263.h"
#include "AD5260.h"

#include "TaskEthernet.h"
#include "version.h"

uint8_t present[6];
uint8_t valdefault[6];
uint8_t watchdog = 20;
uint8_t buf_circ = 0;
bool reset_acqui = 0;
static char trace[400];
TaskEthernet TaskEthernet::sSingleton;

TaskEthernet::TaskEthernet()
    //:_buffer(256)
{
    mThread = NULL;  
    _buffer_pos = 0;
    _current_packet_state = ST_WAIT_0X02_LEN;
    _current_state = ST_UNKNOW;
}

int TaskEthernet::init()
{ 
    if(mThread== NULL)
    {   
        mThread = new Thread();
        //mThread->start(TaskEthernet::get(),&TaskEthernet::startProcess);
    }

    return 0;
}

int TaskEthernet::processNetData()
{  
    uint8_t found0x02;
    
    // 0x02  -   T   -    L               -  V   - 0x03
    // 1byte - 1byte -  2bytes (MSB,LSB)  -  ... - 1byte
    
    if (_current_packet_state == ST_WAIT_0X02_LEN )
    {
        if (_buffer_pos < 3) 
        {
            if (ENABLE_TRACE) {sprintf(trace,"processNetData _buffer_pos < 3\r\n"); DiplayTrace(trace);}
            return 0; // on a besoin du 0x02 + LEN
        }
        found0x02 = 0;
    
        //scan for 0x02
        for (int i=0; i < _buffer_pos - 3; i++)
        {   //on s'assure qu'il y a bien au minimum 3 octets derriere           
            //if (ENABLE_TRACE) {sprintf(trace,"0x%02x\r\n",_buffer[i]); DiplayTrace(trace);}
                        
            if ( _buffer[i] == 0x02)
            {
                found0x02 = 1;
                memset((void *)&_packetTLV, 0x00, sizeof(TLV));
                
                uint16_t len = (_buffer[i+2] << 8) + _buffer[i+3];
                _packetTLV.len = len;
                _packetTLV.type = _buffer[i+1];
                if (ENABLE_TRACE) {sprintf(trace,"dec. type: 0x%02x - len:%d\r\n", _packetTLV.type, _packetTLV.len); DiplayTrace(trace);}
                
                if (len > 6400)
                {
                    if (ENABLE_TRACE) {sprintf(trace,"Packet exceed max len (6400) TRASH IT!!!\r\n"); DiplayTrace(trace);}
                    _buffer_pos = 0;
                    return 0;
                }
                
                if (_packetTLV.payload == NULL)
                {   //on ne doit plus passer ici
                    memset(&_packetTLV,0x00,sizeof(TLV));
                    break;
                }
                else
                {                   
                    _current_packet_state = ST_FILL_DATA;
                    _packetTLV.current_len = 0;
                    memmove((unsigned char*)_buffer, (unsigned char*)_buffer + i+4, _buffer_pos - (i+4));
                    _buffer_pos = _buffer_pos - (i+4);
                    break;
                }      
            } // fin si 0x02 trouvé 
        } // fin for
        
        if (found0x02 == 0)
        {
            _buffer_pos = 0;
        }  
    } // fin si etat ST_WAIT_0X02_LEN

    if (_current_packet_state == ST_FILL_DATA )
    {      
        int16_t copyleft = _packetTLV.len - _packetTLV.current_len;
        int16_t copylen = copyleft < _buffer_pos  ? copyleft : _buffer_pos;

        //if (ENABLE_TRACE) {sprintf(trace,"copyleft:%d - copylen:%d\r\n", copyleft, copylen); DiplayTrace(trace);}

        if (copylen > 0)
        {
            // copy data to payload
            memcpy(&_packetTLV.payload[_packetTLV.current_len],_buffer,copylen);
            _packetTLV.current_len += copylen;
            memmove((unsigned char*)_buffer, (unsigned char*)_buffer + copylen, _buffer_pos - (copylen));
            _buffer_pos = _buffer_pos - copylen;
        }

        if (_buffer_pos > 0)
        {
            // manque le 0x03
            if ( _buffer[0] == 0x03)
            {   // on a une trame valide/ 
                _buffer_pos--; // enleve le 0x03
                mailTLV();
                //if (ENABLE_TRACE) {sprintf(trace,"FULL TLV\r\n"); DiplayTrace(trace);}
                _current_packet_state = ST_WAIT_0X02_LEN;
            }
            else
            {   // pas de 0x03 !!!  
                if (ENABLE_TRACE) {sprintf(trace,"NO 0x03 !!!\r\n"); DiplayTrace(trace);}
                _buffer_pos = 0;
                _current_packet_state = ST_WAIT_0X02_LEN;
            }
        }
            
        if ((copylen == 0) && (_buffer_pos == 0)) 
            return 0;     
    } // fin si fill data

//    _buffer_pos = 0;
//    processNetData(); // pour traiter le cas où on a 2 trames

    return 0;
}

int TaskEthernet::mailTLV()
{
    #ifdef ENABLE_PC_WATCHDOG
        _lastWatchDog = time(NULL);
    #endif
    
    //  Watchdog 
    if (_packetTLV.type == 0x00) 
    {
        // watchdog
        #ifdef ENABLE_PC_WATCHDOG
            _lastWatchDog = time(NULL);
        #endif
        sendTLV(0x01,3,(uint8_t*)"OK;");
        return 0;
    }

    //  Potar 5k (non utilisé en V2 car non présent)
    if (_packetTLV.type == 0x20) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd POT5K 4161\r\n"); DiplayTrace(trace);}
        // non existant en V2
        sendTLV(0x21,3,(uint8_t*)"OK;");
        return 0;
    }

    //  Potar 50k (non utilisé en V2 car non présent)
    if (_packetTLV.type == 0x22) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd POT50K 4161\r\n"); DiplayTrace(trace);}
        // non existant en V2
        sendTLV(0x23,3,(uint8_t*)"OK;");
        return 0;
    }

    //  DAC Carte Fille 
    if (_packetTLV.type == 0x24) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd DAC test board 2664\r\n"); DiplayTrace(trace);}
        uint8_t numcard=0;
        //Set DAC carte fille (DAC 2664)  
        //N° carte fille (1 octet) - Vgrille(2 octets) – Voffset (2 octets)– Vcourant (2 octets)
        if (_packetTLV.len != 7)
        {
            sendTLV(0x25,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        ChipSelector::ChipToSelect cs;
        switch(_packetTLV.payload[0])
        {
            case 1: cs = ChipSelector::CS_DAC_T1; numcard = 0; break;
            case 2: cs = ChipSelector::CS_DAC_T2; numcard = 1; break;
            case 3: cs = ChipSelector::CS_DAC_T3; numcard = 2; break;
            case 4: cs = ChipSelector::CS_DAC_T4; numcard = 3; break;
            case 5: cs = ChipSelector::CS_DAC_T5; numcard = 4; break;
            case 6: cs = ChipSelector::CS_DAC_T6; numcard = 5; break;
            default: 
                sendTLV(0x25,28,(uint8_t*)"KO;Invalid test board number");
                return 0;
        }

        uint16_t dac_value = 0;
        dac_value = (_packetTLV.payload[1] << 8) + _packetTLV.payload[2];
        tmp_v0[numcard] = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x00 /*DAC 0*/,dac_value,cs); //VGRILLE J4 ok

        dac_value = (_packetTLV.payload[3] << 8)  + _packetTLV.payload[4];
        tmp_v1[numcard] = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x01 /*DAC 1*/,dac_value,cs); //VGRILLE J8 ok

        dac_value = (_packetTLV.payload[5] << 8)  + _packetTLV.payload[6];
        tmp_v2[numcard] = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x02 /*DAC 2*/,dac_value,cs); //VCOURANT

        sendTLV(0x25,3,(uint8_t*)"OK;");
        return 0;
    }

    //  Potar 50k Carte Mère AD5263
    if (_packetTLV.type == 0x26) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd potar motherboard AD5263\r\n"); DiplayTrace(trace);}
        
        //r0-r3 (1 octet chaque)
        if (_packetTLV.len != 4)
        {
            sendTLV(0x27,9,(uint8_t*)"KO;Format");
            return 0;
        }
        tmp_gain_1 = _packetTLV.payload[0];
        tmp_gain_2 = _packetTLV.payload[1];
        tmp_gain_3 = _packetTLV.payload[2];
        tmp_gain_4 = _packetTLV.payload[3];     
        
        if (ver_carte)
        {
            AD5263::get()->write_data(0,tmp_gain_1,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(1,tmp_gain_2,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(2,tmp_gain_3,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(3,tmp_gain_4,ChipSelector::CS_AD5263_LOCAL);
        }       
        else
        {
            AD5263::get()->write_data(2,tmp_gain_1,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(0,tmp_gain_2,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(1,tmp_gain_3,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(3,tmp_gain_4,ChipSelector::CS_AD5263_LOCAL);
        } 

        sendTLV(0x27,3,(uint8_t*)"OK;");
        return 0;
    }
    //  Potar 50k Carte Mère AD5260
    if (_packetTLV.type == 0x28) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd potar motherboard AD5260\r\n"); DiplayTrace(trace);}
        //r0 (1 octet)
        if (_packetTLV.len != 1)
        {
            sendTLV(0x29,9,(uint8_t*)"KO;Format");
            return 0;
        }
        tmp_gain_5 = _packetTLV.payload[0];
        AD5260::get()->write_data(0,_packetTLV.payload[0],ChipSelector::CS_AD5260_LOCAL); 
        sendTLV(0x29,3,(uint8_t*)"OK;");
        return 0;
    }

    //  DAC Carte Mère 
    if (_packetTLV.type == 0x2a) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd DAC motherboard 2664\r\n"); DiplayTrace(trace);}
        // Set DAC LTC2664 carte Mère 
        // N° DAC 1 ou 2 (1 octet) - v0 ; v1 ; v2 ; v3 (v0-v3 = 2 octets chaque)
        if (_packetTLV.len != 9)
        {
            sendTLV(0x2b,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        ChipSelector::ChipToSelect cs;
        switch(_packetTLV.payload[0])
        {
            case 1: cs = ChipSelector::CS_DAC1_LOCAL; 
                break;
            case 2: cs = ChipSelector::CS_DAC2_LOCAL; 
                break;
            default: 
                sendTLV(0x2b,27,(uint8_t*)"KO;Invalid DAC board number");
                return 0;
        }
        
        uint16_t dac_value = 0;
        
        dac_value = (_packetTLV.payload[1] << 8) + _packetTLV.payload[2];
        if (_packetTLV.payload[0] == 1) tmp_dac1_1 = dac_value; else tmp_dac2_1 = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x00 /*DAC 0*/,dac_value,cs); //V1

        dac_value = (_packetTLV.payload[3] << 8) + _packetTLV.payload[4];
        if (_packetTLV.payload[0] == 1) tmp_dac1_2 = dac_value; else tmp_dac2_2 = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x01 /*DAC 1*/,dac_value,cs); //V2

        dac_value = (_packetTLV.payload[5] << 8) + _packetTLV.payload[6];
        if (_packetTLV.payload[0] == 1) tmp_dac1_3 = dac_value; else tmp_dac2_3 = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x02 /*DAC 2*/,dac_value,cs); //V3

        dac_value = (_packetTLV.payload[7] << 8) + _packetTLV.payload[8];
        if (_packetTLV.payload[0] == 1) tmp_dac1_4 = dac_value; else tmp_dac2_4 = dac_value;
        LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x03 /*DAC 3*/,dac_value,cs); //V4

        sendTLV(0x2b,3,(uint8_t*)"OK;");
        return 0;
    }
    
    //  Potar 50k Carte Mère AD5262
    if (_packetTLV.type == 0x2c) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd potar motherboard AD5262\r\n"); DiplayTrace(trace);}
        //r0 (1 octet)
        if (_packetTLV.len != 2)
        {
            sendTLV(0x2d,9,(uint8_t*)"KO;Format");
            return 0;
        }
        if (!ver_carte)
        {
            sendTLV(0x2d,15,(uint8_t*)"KO;NotImplanted");
            return 0;
        }
        tmp_gain_5 = _packetTLV.payload[0];
        tmp_gain_6 = _packetTLV.payload[1];
        AD5260::get()->write_data(0,tmp_gain_5,ChipSelector::CS_AD5260_LOCAL); 
        AD5260::get()->write_data(1,tmp_gain_6,ChipSelector::CS_AD5260_LOCAL); 
        sendTLV(0x2d,3,(uint8_t*)"OK;");
        return 0;
    }
    //  Potar 50k Carte Mère
    if (_packetTLV.type == 0x2e) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd potar motherboard\r\n"); DiplayTrace(trace);}
        //r0 (1 octet)
        if (_packetTLV.len != 2)
        {
            sendTLV(0x2f,9,(uint8_t*)"KO;Format");
            return 0;
        }

        switch (_packetTLV.payload[0])
        {
            case 0:
                tmp_gain_1 = _packetTLV.payload[1];
                if (ver_carte)
                    AD5263::get()->write_data(0,tmp_gain_1,ChipSelector::CS_AD5263_LOCAL);
                else
                    AD5263::get()->write_data(2,tmp_gain_1,ChipSelector::CS_AD5263_LOCAL);
                break;  
            case 1:
                tmp_gain_2 = _packetTLV.payload[1];
                if (ver_carte)
                    AD5263::get()->write_data(1,tmp_gain_2,ChipSelector::CS_AD5263_LOCAL);
                else
                    AD5263::get()->write_data(0,tmp_gain_2,ChipSelector::CS_AD5263_LOCAL);
                break;  
            case 2:
                tmp_gain_3 = _packetTLV.payload[1];
                if (ver_carte)
                    AD5263::get()->write_data(2,tmp_gain_3,ChipSelector::CS_AD5263_LOCAL);
                else
                    AD5263::get()->write_data(1,tmp_gain_3,ChipSelector::CS_AD5263_LOCAL);
                break;  
            case 3:
                tmp_gain_4 = _packetTLV.payload[1];
                AD5263::get()->write_data(3,tmp_gain_4,ChipSelector::CS_AD5263_LOCAL);
                break;  
            case 4:
                tmp_gain_5 = _packetTLV.payload[1];
                AD5260::get()->write_data(0,tmp_gain_5,ChipSelector::CS_AD5260_LOCAL); 
                break;  
            case 5:
                tmp_gain_6 = _packetTLV.payload[1];
                AD5260::get()->write_data(1,tmp_gain_6,ChipSelector::CS_AD5260_LOCAL); 
                break;  
            default:
                break;
        }           

        sendTLV(0x2f,3,(uint8_t*)"OK;");
        return 0;
    }
    //  DAC Carte Mère (autre commande qui programme que la voie voulue)
    if (_packetTLV.type == 0x30)
    {
        uint8_t dac_cs = 0;
        uint8_t dac_voie = 0;
        uint16_t dac_value = 0;
        
        if (ENABLE_TRACE) {sprintf(trace,"cmd DAC motherboard 2664\r\n"); DiplayTrace(trace);}
        // Set DAC LTC2664 carte Mère 
        // N° DAC 1 ou 2 (1 octet) - N° voie - valeur (2 octets)
        if (_packetTLV.len != 4)
        {
            sendTLV(0x31,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        ChipSelector::ChipToSelect cs;
        
        dac_cs = _packetTLV.payload[0];
        dac_voie = _packetTLV.payload[1];
        dac_value = (_packetTLV.payload[2] << 8) + _packetTLV.payload[3];
        switch(dac_cs)
        {
            case 1: 
                cs = ChipSelector::CS_DAC1_LOCAL; 
                break;
            case 2: 
                cs = ChipSelector::CS_DAC2_LOCAL; 
                break;
            default: 
                sendTLV(0x31,27,(uint8_t*)"KO;Invalid DAC board number");
                return 0;
        }
        switch(dac_voie)
        {
            case 0: 
                if (dac_cs == 1) tmp_dac1_1 = dac_value; else tmp_dac2_1 = dac_value;
                break;
            case 1: 
                if (dac_cs == 1) tmp_dac1_2 = dac_value; else tmp_dac2_2 = dac_value;
                break;
            case 2: 
                if (dac_cs == 1) tmp_dac1_3 = dac_value; else tmp_dac2_3 = dac_value;
                break;
            case 3: 
                if (dac_cs == 1) tmp_dac1_4 = dac_value; else tmp_dac2_4 = dac_value;
                break;
            default: 
                sendTLV(0x31,25,(uint8_t*)"KO;Invalid DAC pin number");
                return 0;
        }
        LTC2664::get()->write_data(0x03,dac_voie,dac_value,cs); 
        sendTLV(0x31,3,(uint8_t*)"OK;");
        return 0;
    }
    //  LTC234x
    if (_packetTLV.type == 0x40) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd capture 2348\r\n"); DiplayTrace(trace);}
        // Commande capture 2348
        // N°cartes filles (1 octet <=> 00011111); Mode (1 octet) ; NbMoyModulation (1 octet) ; Tempo(µs) ou nb tics (4 octets); Délai(µs)(1 octet) ; Nb points (2 octets) ; freq SPI (2 octet)
        if (_packetTLV.len != 12)
        {
            sendTLV(0x41,9,(uint8_t*)"KO;Format");
            return 0;
        }
        reset_acqui = 0;
        uint8_t nbr_channels = 0;
        uint8_t channels = _packetTLV.payload[0];
        if ( (channels & 0x01) == 0x01 ) nbr_channels++;
        if ( (channels & 0x02) == 0x02 ) nbr_channels++;
        if ( (channels & 0x04) == 0x04 ) nbr_channels++;
        if ( (channels & 0x08) == 0x08 ) nbr_channels++;
        if ( (channels & 0x10) == 0x10 ) nbr_channels++;
        if ( (channels & 0x20) == 0x20 ) nbr_channels++;
            
        uint8_t mode = _packetTLV.payload[1];
        uint8_t nb_moy_modulation = _packetTLV.payload[2];
        uint32_t tempo = (_packetTLV.payload[3] << 24) + (_packetTLV.payload[4] << 16) +(_packetTLV.payload[5] << 8) +_packetTLV.payload[6];
        uint8_t delay = _packetTLV.payload[7];
        uint16_t points = (_packetTLV.payload[8] << 8) +_packetTLV.payload[9];
        uint16_t freq = (_packetTLV.payload[10] << 8) +_packetTLV.payload[11];

        /*if (ENABLE_TRACE) 
        {   
            sprintf(trace,"channels=%s - nbr_channels=%u - mode=%u - NbMoyModulation=%u - Tempo=%zu us - Delai=%d us - NbPoints=%u - FreqSpi:%u\r\n", byte_to_binary(channels),nbr_channels,mode,nb_moy_modulation,tempo, delay, points,freq);
            DiplayTrace(trace);
        }
        */
        if (LTC234x::get()->test_memory_2348(channels,points,nb_moy_modulation,delay,tempo,freq,mode) == -1)
        {
            sendTLV(0x41,9,(uint8_t*)"KO;-2348-");  
            return 0;
        }
        else
        {
            switch (mode)
            {
                case 0:
                    Mode0 = 1;  
                break;
                case 1:
                    Mode1 = 1;  
                break;
                case 2:
                    Mode2 = 1;
                break;
                case 3:
                    Mode3 = 1;
                break;
                case 4:
                    Mode4 = 1;
                break;
                case 5:
                    Mode5 = 1;
                break;
                case 6:
                    Mode6 = 1;
                    buf_circ = 0;
                break;
                case 7:
                    Mode7 = 1; 
                    buf_circ = 0;
                break;
                default:
                    sendTLV(0x41,9,(uint8_t*)"KO;-2348-");  
                    return 0;
                    break;
            }

            unsigned char capture_size[8] = "OK;1234";
            uint32_t cap_size = (points*3*nbr_channels) + points;
            if (Mode6)
                cap_size = cap_size*nb_moy_modulation;
            //if (ENABLE_TRACE) {sprintf(trace,"capture size:%d\r\n", cap_size); DiplayTrace(trace);}
            capture_size[3]= (cap_size >> 24) & 0xff;
            capture_size[4]= (cap_size >> 16) & 0xff;
            capture_size[5]= (cap_size >> 8) & 0xff;
            capture_size[6]= cap_size & 0xff;
            
            sendTLV(0x41,7,(uint8_t*)capture_size);
        }
    }
    
    //  demande des donnees de l'acquisition
    if (_packetTLV.type == 0x42) 
    {
        //if (ENABLE_TRACE) {sprintf(trace,"cmd send capture buffer\r\n"); DiplayTrace(trace);}
        // Commande send capture
        if (_packetTLV.len != 3)
        {
            sendTLV(0x43,9,(uint8_t*)"KO;Format");
            if (ENABLE_TRACE) {sprintf(trace,"KO;Format\r\n"); DiplayTrace(trace);}
            return 0;
        }
        if (Mode0 || Mode1 || Mode2 || Mode3 || Mode4 || Mode5 || Mode6Encours) 
        {       
            sendTLV(0x43,10,(uint8_t*)"KO;EnCours");
            if (ENABLE_TRACE) {sprintf(trace,"KO;EnCours\r\n"); DiplayTrace(trace);}
            return 0;
        }
        
        if (reset_acqui)
            return 0;
        
        uint8_t page = _packetTLV.payload[0];
        uint16_t len = (_packetTLV.payload[1] << 8) + _packetTLV.payload[2];

        if (Mode6 || Mode7) 
        {   
            sendTLVNoTmpBuffer(0x43,len,(page << 16),LTC234x::get()->capture_buffer_to_send[buf_circ]);
            free(LTC234x::get()->capture_buffer_to_send[buf_circ]);
            LTC234x::get()->capture_buffer_to_send[buf_circ] = NULL;
            buf_circ++;
            if (ENABLE_TRACE) {sprintf(trace,"buff_circ=%d\r\n",buf_circ); DiplayTrace(trace);}
            if (buf_circ >= TAILLE_BUF_CIRC) 
                buf_circ = 0;
            if (buf_circ == buf)
                Mode6Encours = 1;
        }
        else
        {
            if (ENABLE_TRACE) {sprintf(trace,"page=%d len=%d\r\n",page,len); DiplayTrace(trace);}
            sendTLVNoTmpBuffer(0x43,len,(page << 16),LTC234x::get()->capture_buffer);           
        }
    }
    
    //  Active / desactive la modulation
    if (_packetTLV.type == 0x44) 
    {
        if (_packetTLV.len != 1)
        {
            sendTLV(0x45,9,(uint8_t*)"KO;Format");
            return 0;
        }
        switch (_packetTLV.payload[0])
        {
            case 0 ://mode normal
                acq_modul_off = 0;
                modulation_out = SensTrig;
                if (ENABLE_TRACE) {sprintf(trace,"Modulation on\r\n"); DiplayTrace(trace);}
            break;
            case 1 ://OFF
                acq_modul_off = 1;
                modulation_out = SensTrig;
                if (ENABLE_TRACE) {sprintf(trace,"Modulation off\r\n"); DiplayTrace(trace);}
            break;
            case 2 ://ON
                acq_modul_off = 2;
                modulation_out = !SensTrig;
                if (ENABLE_TRACE) {sprintf(trace,"Modulation always on\r\n"); DiplayTrace(trace);}
            break;
            default:
                break;
        }
            
        sendTLV(0x45,3,(uint8_t*)"OK;");
        return 0;
    }
    //  Reset Acquisition
    if (_packetTLV.type == 0x46) 
    {
        reset_acqui = 1;
        Mode0 = 0; Mode1 = 0;
        Mode2 = 0; Mode3 = 0;
        Mode4 = 0; Mode5 = 0;   
        Mode6 = 0; Mode7 = 0;
        if (ENABLE_TRACE) {sprintf(trace,"Reset Acqui\r\n"); DiplayTrace(trace);}
        sendTLV(0x47,3,(uint8_t*)"OK;");
        return 0;
    }
    //  Set Source
    if (_packetTLV.type == 0x48) 
    {
        if (_packetTLV.len != 3)
        {
            sendTLV(0x49,9,(uint8_t*)"KO;Format");
            return 0;
        }
        if (_packetTLV.payload[0])
            SensTrig = 1;
        else
            SensTrig = 0;
        
        tempo_source = (_packetTLV.payload[1] << 8) + _packetTLV.payload[2];
        if ( acq_modul_off == 2)
            modulation_out = !SensTrig;
        else
            modulation_out = SensTrig;
        
        if (ENABLE_TRACE) {sprintf(trace,"Set Source\r\n"); DiplayTrace(trace);}
        sendTLV(0x49,3,(uint8_t*)"OK;");
        return 0;
    }
    // Gestion Config
    // lecture param
    if (_packetTLV.type == 0x50) 
    {
        if (_packetTLV.len > 32)
        {
            sendTLV(0x51,10,(uint8_t*)"KO;TooLong");
            return 0;
        }
        uint8_t count = 0;
        uint8_t pos1 = 0;
        for (uint8_t i = 0; i<_packetTLV.len; i++)
        {
            if (_packetTLV.payload[i] == ';')
            {
                count++;
                if (count == 1) 
                    pos1 = i;
            }
        }
        if (count != 1)
        {
            sendTLV(0x51,9,(uint8_t*)"KO;Format");
            return 0;
        }

        char tmp0[8];
        char tmp1[32];
        memset(tmp0,0x0,sizeof(tmp0));
        memset(tmp1,0x0,sizeof(tmp1));
        memcpy(tmp0,&_packetTLV.payload[0],pos1);
        memcpy(tmp1,&_packetTLV.payload[pos1+1], (_packetTLV.len - pos1)-1 );
        
        char tmp_ret[75 + 4];
        tmp_ret[0] = 'O';
        tmp_ret[1] = 'K';
        tmp_ret[2] = ';';

        if (LocalConfig::get()->getConfig(atoi(tmp0),tmp1,&tmp_ret[3],75) == true)
        {
            tmp_ret[75] = '\0';
            sendTLV(0x51,strlen(tmp_ret),(uint8_t*)tmp_ret);
        }
        else
        {
            sendTLV(0x51,6,(uint8_t*)"KO;Err");
        }
    }

    // ecriture param
    if (_packetTLV.type == 0x52) 
    {
        if (_packetTLV.len > 32)
        {
            sendTLV(0x53,10,(uint8_t*)"KO;TooLong");
            return 0;
        }
        uint8_t count = 0;
        uint8_t pos1 = 0;
        uint8_t pos2 = 0;
        uint8_t board = 0;
        for (uint8_t i = 0; i<_packetTLV.len; i++)
        {
            if (_packetTLV.payload[i] == ';')
            {
                count++;
                if (count == 1) 
                    pos1 = i;
                if (count == 2) 
                    pos2 = i;
            }
        }
        if (count != 2)
        {
            sendTLV(0x53,9,(uint8_t*)"KO;Format");
            return 0;
        }

        char tmp0[8];
        char tmp1[32];
        char tmp2[75];
        memset(tmp0,0x0,sizeof(tmp0));
        memset(tmp1,0x0,sizeof(tmp1));
        memset(tmp2,0x0,sizeof(tmp2));
        memcpy(tmp0,&_packetTLV.payload[0],pos1);
        memcpy(tmp1,&_packetTLV.payload[pos1+1], (pos2 - pos1)-1 );
        memcpy(tmp2,&_packetTLV.payload[pos2+1],_packetTLV.len - (pos2+1) );

        board = atoi(tmp0);
        if (strcmp("all",tmp1) == 0)
        {   
            switch (board)
            {
                case 0: LocalConfig::get()->setAll(1); memcpy(tmp2,tmp_all,strlen(tmp_all)); break;
                case 1: cfg1.setAll(1,0); memcpy(tmp2,tmp_all_f,strlen(tmp_all_f)); break;
                case 2: cfg2.setAll(1,1); memcpy(tmp2,tmp_all_f,strlen(tmp_all_f)); break; 
                case 3: cfg3.setAll(1,2); memcpy(tmp2,tmp_all_f,strlen(tmp_all_f)); break; 
                case 4: cfg4.setAll(1,3); memcpy(tmp2,tmp_all_f,strlen(tmp_all_f)); break; 
                case 5: cfg5.setAll(1,4); memcpy(tmp2,tmp_all_f,strlen(tmp_all_f)); break;  
                case 6: cfg6.setAll(1,5); memcpy(tmp2,tmp_all_f,strlen(tmp_all_f)); break; 
                default:    break;
            }
        }
        
        if (LocalConfig::get()->setConfig(atoi(tmp0),tmp1,tmp2) == true)
        {
            sendTLV(0x53,3,(uint8_t*)"OK;");
        }
        else
        {
            sendTLV(0x53,6,(uint8_t*)"KO;Err");
        }
    }
   
    // sauvegarde config
    if (_packetTLV.type == 0x54) 
    {
        if (_packetTLV.len != 1)
        {
            sendTLV(0x55,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        if (LocalConfig::get()->saveConfig( _packetTLV.payload[0] ) == true)
        {
            sendTLV(0x55,3,(uint8_t*)"OK;");
        }
        else
        {
            sendTLV(0x55,9,(uint8_t*)"KO;EE Err");
        }
    }
    
    // lecture param actuellement programmé
    if (_packetTLV.type == 0x56) 
    {
        if (_packetTLV.len != 1)
        {
            sendTLV(0x57,9,(uint8_t*)"KO;Format");
            return 0;
        }

        char tmp_ret[75 + 4];
        tmp_ret[0] = 'O';
        tmp_ret[1] = 'K';
        tmp_ret[2] = ';';

        if (LocalConfig::get()->getConf(_packetTLV.payload[0],&tmp_ret[3],75) == true)
        {
            tmp_ret[75] = '\0';
            sendTLV(0x57,strlen(tmp_ret),(uint8_t*)tmp_ret);
        }
        else
        {
            sendTLV(0x57,6,(uint8_t*)"KO;Err");
        }
    }
    
    //  Uptime / sysinfo
    if (_packetTLV.type == 0x60) 
    {
        if (_packetTLV.len != 0)
        {
            sendTLV(0x61,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        u32_t seconds = time(NULL);
        unsigned char uptime_s[8] = "OK;1234";
        if (ENABLE_TRACE) {sprintf(trace,"UpTime:%d\r\n", seconds); DiplayTrace(trace);}
        uptime_s[3]= (seconds >> 24) & 0xff;
        uptime_s[4]= (seconds >> 16) & 0xff;
        uptime_s[5]= (seconds >> 8) & 0xff;
        uptime_s[6]= seconds & 0xff;
        sendTLV(0x61,7,(uint8_t*)uptime_s);
        return 0;
    }
    // Version Soft + hardware
    if (_packetTLV.type == 0x62) 
    {
        if (_packetTLV.len != 0)
        {
            sendTLV(0x63,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        char infos[32];// = "OK;1.0;1.0;160;70";
        uint8_t len;
        sprintf(infos, "infos: V%02dR%02d - 20 AVR 2020", fw_version.ver.major, fw_version.ver.minor); //6 caracteres
        if (ENABLE_TRACE) {sprintf(trace,"%s\r\n", infos); DiplayTrace(trace);}
        len = strlen(infos);
        sendTLV(0x63,len,(uint8_t*)infos);
        return 0;
    }

    //      TEST
    if (_packetTLV.type == 0x70) 
    {
        if (_packetTLV.len != 1)
        {
            sendTLV(0x71,9,(uint8_t*)"KO;Format");
            return 0;
        }
        
        uint8_t test_num  = _packetTLV.payload[0];
        if (ENABLE_TRACE) {sprintf(trace,"Test %d\r\n",test_num); DiplayTrace(trace);}
        if (test_num == 1)
            sendTLV(0x71,6,(uint8_t*)present);
        else if (test_num == 2)
            sendTLV(0x71,6,(uint8_t*)valdefault);
        else if (test_num > 2)
            sendTLV(0x71,6,(uint8_t*)"KO; NA");
        return 0;
    }

    if (_packetTLV.type == 0x88) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"cmd test DAC NEED RESET TO HALT !!!\r\n"); DiplayTrace(trace);}
        // Commande de test boucle par pas de 0x1000 sur tous les DAC locaux + T1 (faire un reset de la carte pour en sortir)
        sendTLV(0x87,3,(uint8_t*)"OK;");

        ChipSelector::get()->unselectAll();

        char *test="BONJOUR -123-";
        uint8_t outbuffer[21];
        memset(outbuffer,0x0,sizeof(outbuffer));

        ChipSelector::get()->unselectAll();
        CAT25160::get()->init();
        CAT25160::get()->unprotectAll(ChipSelector::CS_EEPROM_T1);
        CAT25160::get()->writeBlock(0x0,13,test,ChipSelector::CS_EEPROM_T1);
        CAT25160::get()->readBlock(0x0,20,outbuffer,ChipSelector::CS_EEPROM_T1);
        if (ENABLE_TRACE) {sprintf(trace,"lit:%s\r\n",outbuffer); DiplayTrace(trace);}
        
        return 0;
    }
    
    if (_packetTLV.type == 0x90) 
    {
        sendTLV(0x91,3,(uint8_t*)"OK;");
        if (ENABLE_TRACE)       
            ENABLE_TRACE = 0;
        else 
            ENABLE_TRACE = 1;
            
        return 0;
    }
    return 0;
}

int TaskEthernet::sendTLVNoTmpBuffer(uint8_t type, uint16_t len, uint32_t offset,uint8_t *datas)
{
    uint8_t save0x03;
    uint8_t buffer[5];
//  uint8_t buffer[len+6];
    buffer[0] = 0x02;
    buffer[1] = type;
    buffer[2] = (len >> 8) & 0xff;
    buffer[3] =  len & 0xff;
    
//  buffer[len + 4] = 0x03;
//  memcpy(&buffer[4],datas,len);
//  _server.sendTo(pc_udp,(char *)buffer,len+5);

    // pour ajouter le 0x03 on sauvegarde la valeur pour la restaurer apres l'envoi (on a prevu un buffer + 1 si dernière page)
    _server.sendto(pc_udp,(char *)buffer ,4);
    if (offset != 0)
        save0x03 = datas[offset + len];
    datas[offset + len] = 0x03;
    
    _server.sendto(pc_udp,(char *)(datas + offset),len+1);
    
    if (offset != 0) //s'il y a plusieur page, on restaure la valeur, sinon ca ne sert a rien
        datas[offset + len] = save0x03;
    
    #ifdef ENABLE_PC_WATCHDOG
        _lastWatchDog = time(NULL);
    #endif
    
    //if (ENABLE_TRACE) {sprintf(trace,"sendTLV type:0x%02x offset:%d ret(datas):%d\r\n",type,offset,ret); DiplayTrace(trace);}
    return 0;
}

int TaskEthernet::sendTLV(uint8_t type, uint16_t len, uint8_t *datas)
{
    uint8_t buffer[128];
    
    if ((len + 5) > 128) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"ERROR sendTLV data len is larger than buffer space !!!!!\r\n"); DiplayTrace(trace);}
        return -1;
    }
    
    //if ( _client == NULL ) return -1;//TODO
    
    buffer[0] = 0x02;
    buffer[1] = type;
    buffer[2] = (len >> 8) & 0xff;
    buffer[3] =  len & 0xff;
    memcpy(&buffer[4],datas,len);
    buffer[len + 4] = 0x03;
    
    //int ret = _client2.send((char *)buffer,len+5);
    int ret = _server.sendto(pc_udp,(char *)buffer,len+5);
    
    //if (ENABLE_TRACE) {sprintf(trace,"sendTLV type:0x%02x ret:%d\r\n",type,ret); DiplayTrace(trace);}

    return 0;
}

const char *TaskEthernet::byte_to_binary(int x)
{
    static char b[9];
    b[0] = '\0';

    int z;
    for (z = 128; z > 0; z >>= 1)
    {
        strcat(b, ((x & z) == z) ? "1" : "0");
    }

    return b;
}

bool TaskEthernet::isClientConnected()
{
    int ret = 0;
    //ret = _client2.receive((char *)_buffer,256);
    if (ret == 0)
        return false;
    else
        return true;
    //return (_current_state == ST_CLIENT);
}

void TaskEthernet::startProcess() 
{
    SocketAddress sockAddr;
    uint8_t eth_init_done=0;
    int ret=0;
    _current_state = ST_WAIT_IP;
    _lastWatchDog = time(NULL);
    
    while(1)
    {
        led2 = !led2;
        if (_current_state == ST_WAIT_IP)
        {           
            if (eth_init_done == 0)
            {
                eth_init_done = 1;

                if (strncmp("dhcp",LocalConfig::get()->get_ip(),4) == 0)
                {
                    printf("Eth init() DHCP\r\n");
                    _eth.set_dhcp(1); //Use DHCP
                }               
                else
                {
                    printf("Eth init() %s\r\n",LocalConfig::get()->get_ip());
                    _eth.set_network((char *) LocalConfig::get()->get_ip(),"255.255.255.0","0.0.0.0"); // static mode
                }
            }                
            _eth.connect();
            
            if (ret ==  0)
            {
                led3 = 0;
                _eth.get_ip_address(&sockAddr);
                const char *mac = _eth.get_mac_address();
                printf("IP address is: %s\n\r", sockAddr.get_ip_address() ? sockAddr.get_ip_address() : "No IP");
                printf("MAC address is: %s\n\r", mac ? mac : "No MAC");
                _current_state = ST_WAIT_CONNEXION;
                _server.open(&_eth);
                if (_server.bind(1234) < 0) 
                {
                   printf("Could not bind server socket to port 1234.\n\r"); 
                }
                _server.set_blocking(false); // non bloking 100ms
                _server.set_timeout(20);
                //_server.set_broadcasting(0);
            }
            else
            {
                printf("No IP Address\r\n");
            }
        }
        
        if (_current_state == ST_WAIT_CONNEXION)
        {
            _current_state = ST_CLIENT;
        }

        if (_current_state == ST_CLIENT)
        {
            ret = _server.recvfrom(&pc_udp,&_buffer,256);
            if (ret>0)
            {
                _buffer_pos = _buffer_pos + ret;                
                processNetData();
            } 
        }
    }
}

