#ifndef MBED_MCP4161_H
#define MBED_MCP4161_H

/*support SPI serial interface (10 MHz, modes 0,0 & 1,1)*/

#include "mbed.h"

#include "ChipSelector.h"
 



class MCP4161 {
public:
    MCP4161(PinName mosi,PinName miso, PinName scl);

    static MCP4161 *get()  {
        return &sSingleton;
    }
    
    
    int init();
    void write_data(uint8_t addr, uint16_t data,ChipSelector::ChipToSelect cs);

private:
    SPI _spi; 
    bool _initComplete;

    static MCP4161 sSingleton;

    // methods
    MCP4161& operator=(const MCP4161&);
    MCP4161(const MCP4161&);    
    
};



#endif
 