#include "mbed.h"

#include "ChipSelector.h"
#include "MCP4161.h"
 
MCP4161 MCP4161::sSingleton = MCP4161(PTD2, PTD3, PTD1);

MCP4161::MCP4161(PinName mosi,PinName miso, PinName scl)
        : _spi(mosi, miso, scl)// mosi, miso, sclk    
{
    _initComplete = false;

}

int MCP4161::init()
{
    // Chip must be deselected
    ChipSelector::get()->unselectAll();
 
    // Setup the spi for 16 bits data, 
    // 10KHz clock rate
    _spi.format(16,3);
    _spi.frequency(10000);
  
    _initComplete = true;
  
    return 0;
}

void MCP4161::write_data(uint8_t addr, uint16_t data,ChipSelector::ChipToSelect cs)
{
    // addr         what
    
    // 00h          Volatile Wiper 0
    // 02h          NV Wiper 0   
    // 04h          Volatile TCON Register 
    // 05h          Status Register
    // 06h to 0Fh   Data EEPROM
    
    // Valid data range for resistor network is 0x0-0x100
    
    if (data > 0x100)
    {
        printf("!!! WARNING order CANCELLED. Data resistor is > 0x100 (0x%04x). \r\n", data);
        return;
    }
    
    uint16_t value;
    uint16_t ret;
  
    ChipSelector::get()->setCS(cs,0);
    wait_us(1);
    
    value = ((addr & 0x0f) << 4 | 0x00 /*Write command cf page 45*/) << 8;
    value |= (data & 0x1ff);
    
    printf("write=0x%04x\r\n", value);
    //ret = _spi.write(0x0);

    ret = _spi.write(value); // tel que c'est câblé on ne peut pas récupérer le valeur de retour, donc on ne peut pas vérifier le bit CMDERR
    
    //printf("ret=0x%04x\r\n",ret);

    ChipSelector::get()->setCS(cs,1);
    wait_us(1);
}
