#ifndef LocalConfig_h
#define LocalConfig_h

#include "mbed.h"
#include "ConfigFile.h"
extern char tmp_all[75];
extern uint16_t tmp_dac1_1;
extern uint16_t tmp_dac1_2;
extern uint16_t tmp_dac1_3;
extern uint16_t tmp_dac1_4;
extern uint16_t tmp_dac2_1;
extern uint16_t tmp_dac2_2;
extern uint16_t tmp_dac2_3;
extern uint16_t tmp_dac2_4;
extern uint8_t tmp_gain_1;
extern uint8_t tmp_gain_2;
extern uint8_t tmp_gain_3;
extern uint8_t tmp_gain_4;
extern uint8_t tmp_gain_5;
extern uint8_t tmp_gain_6;

class LocalConfig {

//data 
private:

#define  DEFAULT_IP                 "192.168.0.30"
//#define  DEFAULT_IP                 "dhcp"
#define  DEFAULT_MB_SERIAL          "Vxx.xxxx"
#define  DEFAULT_MB_DAC1_1            "32768"
#define  DEFAULT_MB_DAC1_2            "32768"
#define  DEFAULT_MB_DAC1_3            "32768"
#define  DEFAULT_MB_DAC1_4            "32768"
#define  DEFAULT_MB_DAC2_1            "32768"
#define  DEFAULT_MB_DAC2_2            "32768"
#define  DEFAULT_MB_DAC2_3            "32768"
#define  DEFAULT_MB_DAC2_4            "32768"
#define  DEFAULT_MB_AD5263_1          "0"
#define  DEFAULT_MB_AD5263_2          "0"
#define  DEFAULT_MB_AD5263_3          "0"
#define  DEFAULT_MB_AD5263_4          "0"
#define  DEFAULT_MB_AD5260            "0"
#define  DEFAULT_MB_AD5262            "0"
#define  DEFAULT_ALL            "32768;32768;32768;32768;32768;32768;32768;32768;0;0;0;0;0;0"


    static LocalConfig sSingleton;

    ConfigFile cfg;
    
    // Config Motherboard
    char all[75];
    char _ip[32];
    char serial[16];
    uint16_t dac1_1;
    uint16_t dac1_2;
    uint16_t dac1_3;
    uint16_t dac1_4;
    uint16_t dac2_1;
    uint16_t dac2_2;
    uint16_t dac2_3;
    uint16_t dac2_4;
    uint8_t gain_1;
    uint8_t gain_2;
    uint8_t gain_3;
    uint8_t gain_4;
    uint8_t gain_5;
    uint8_t gain_6;
    //Config testBoard
    //TODO
    //tensions v0-v2 => ok 2 octets pour chaque soit 6 octets
    //- N° de série carte fille et carte mère 11 octets : (année.mois.increment, xxxx.xx.xxx, 2018.12.001)
    //- Type de transitor 2 octets : xx, 0M

    // methods
    LocalConfig& operator=(const LocalConfig&);
    LocalConfig(const LocalConfig&);

    void printConfig(void);
    
    
public:
    LocalConfig() ;
    static LocalConfig *get()  
    {
      return &sSingleton;
    }

    int init();
    void setAll(bool typ);
    bool setConfig(uint8_t num_card, char *key, char*value);
    bool getConfig(uint8_t num_card, char *key, char *buffer, uint8_t buffer_len);
    bool getConf(uint8_t num_card, char *buffer, uint8_t buffer_len);
    bool saveConfig(uint8_t num_card);
    bool applyConfig(uint8_t num_card);

    char *   get_ip();
    char *   get_mb_serial();
    char *   get_all();
    uint16_t get_mb_dac1_1();
    uint16_t get_mb_dac1_2();
    uint16_t get_mb_dac1_3();
    uint16_t get_mb_dac1_4();

    uint16_t get_mb_dac2_1();
    uint16_t get_mb_dac2_2();
    uint16_t get_mb_dac2_3();
    uint16_t get_mb_dac2_4();

    uint8_t get_mb_ad5263_1();
    uint8_t get_mb_ad5263_2();
    uint8_t get_mb_ad5263_3();
    uint8_t get_mb_ad5263_4();

    uint8_t get_mb_ad5260();
    uint8_t get_mb_ad5262();
};
#endif

