#include "mbed.h"
#include "rtos.h"

#include <stdio.h>
#include <string.h>
#include <inttypes.h>

#include "ChipSelector.h"
#include "CAT25160.h"
#include "LTC2664.h"
#include "AD5263.h"
#include "AD5260.h"
#include "Global.h"
#include "LocalConfig.h"

LocalConfig   LocalConfig::sSingleton;
char tmp_all[75];
uint16_t tmp_dac1_1;
uint16_t tmp_dac1_2;
uint16_t tmp_dac1_3;
uint16_t tmp_dac1_4;
uint16_t tmp_dac2_1;
uint16_t tmp_dac2_2;
uint16_t tmp_dac2_3;
uint16_t tmp_dac2_4;
uint8_t tmp_gain_1;
uint8_t tmp_gain_2;
uint8_t tmp_gain_3;
uint8_t tmp_gain_4;
uint8_t tmp_gain_5;
uint8_t tmp_gain_6;
static char trace[100];

LocalConfig::LocalConfig()
{
}

int LocalConfig::init()
{
    char value[75];
    
    uint8_t *buffer_config = CAT25160::get()->readConfig(ChipSelector::CS_EEPROM_LOCAL);

    if (buffer_config == NULL)
    {
        // on tente une deuxième fois
        thread_sleep_for(50);
        if (ENABLE_TRACE) {sprintf(trace,"no EEPROM config found. TRY second read !\r\n"); DiplayTrace(trace);}
        
        buffer_config = CAT25160::get()->readConfig(ChipSelector::CS_EEPROM_LOCAL);
    }

    //free(buffer_config);//debug
    //buffer_config = NULL;//debug
 
    if (buffer_config == NULL)
    {
        led1 = 1;

        if (ENABLE_TRACE) {sprintf(trace,"no EEPROM config found. using default config !\r\n"); DiplayTrace(trace);}
                
        // mb_serial
        cfg.setValue("serial",DEFAULT_MB_SERIAL);     
        sprintf(serial,"%s",DEFAULT_MB_SERIAL);

        // ip
        cfg.setValue("ip",DEFAULT_IP);      
        sprintf(_ip,"%s",DEFAULT_IP) ;

        // mb_dac1_x
        cfg.setValue("dac1_1",DEFAULT_MB_DAC1_1);       dac1_1 = atoi(DEFAULT_MB_DAC1_1) ;
        cfg.setValue("dac1_2",DEFAULT_MB_DAC1_2);       dac1_2 = atoi(DEFAULT_MB_DAC1_2) ;
        cfg.setValue("dac1_3",DEFAULT_MB_DAC1_3);       dac1_3 = atoi(DEFAULT_MB_DAC1_3) ;
        cfg.setValue("dac1_4",DEFAULT_MB_DAC1_4);       dac1_4 = atoi(DEFAULT_MB_DAC1_4) ;

        // mb_dac2_x
        cfg.setValue("dac2_1",DEFAULT_MB_DAC2_1);       dac2_1 = atoi(DEFAULT_MB_DAC2_1) ;
        cfg.setValue("dac2_2",DEFAULT_MB_DAC2_2);       dac2_2 = atoi(DEFAULT_MB_DAC2_2) ;
        cfg.setValue("dac2_3",DEFAULT_MB_DAC2_3);       dac2_3 = atoi(DEFAULT_MB_DAC2_3) ;
        cfg.setValue("dac2_4",DEFAULT_MB_DAC2_4);       dac2_4 = atoi(DEFAULT_MB_DAC2_4) ;

        // mb_ad5263_x
        cfg.setValue("gain_1",DEFAULT_MB_AD5263_1);     gain_1 = atoi(DEFAULT_MB_AD5263_1) ;
        cfg.setValue("gain_2",DEFAULT_MB_AD5263_2);     gain_2 = atoi(DEFAULT_MB_AD5263_2) ;
        cfg.setValue("gain_3",DEFAULT_MB_AD5263_3);     gain_3 = atoi(DEFAULT_MB_AD5263_3) ;
        cfg.setValue("gain_4",DEFAULT_MB_AD5263_4);     gain_4 = atoi(DEFAULT_MB_AD5263_4) ;

        cfg.setValue("gain_5",DEFAULT_MB_AD5260);       gain_5 = atoi(DEFAULT_MB_AD5260) ;
        cfg.setValue("gain_6",DEFAULT_MB_AD5262);       gain_6 = atoi(DEFAULT_MB_AD5262) ;
        
        cfg.setValue("all",DEFAULT_ALL);                sprintf(all,"%s",DEFAULT_ALL);
       
        //SAVE CONFIG TO EEPROM
        buffer_config = cfg.writeBuffer();
        if (buffer_config == NULL)
        {
            if (ENABLE_TRACE) {sprintf(trace,"Error on make config!!!\r\n"); DiplayTrace(trace);}
        }
        //printf("make config %s\r\n",buffer_config);
//      if ( CAT25160::get()->writeConfigCheck((uint8_t*) buffer_config,strlen((char *)buffer_config)+1,ChipSelector::CS_EEPROM_LOCAL) == -1)
//      {
//          if (ENABLE_TRACE) {sprintf(trace,"Error on writing config !!!\r\n"); DiplayTrace(trace);}
//      }
        free(buffer_config);
    }
    else
    {
        if (ENABLE_TRACE) {sprintf(trace,"using ConfigFile on EEPROM\r\n"); DiplayTrace(trace);}
        
        cfg.readBuffer((char *)buffer_config,strlen((char *)buffer_config)+1);    
        free(buffer_config);
        
        //all
        if (cfg.getValue("all", &value[0], sizeof(value)) == true) sprintf(all,"%s",value); 
        else {  cfg.setValue("all",DEFAULT_ALL); sprintf(all,"%s",DEFAULT_ALL); }
        
        // mb_serial
        if (cfg.getValue("serial", &value[0], sizeof(value)) == true) sprintf(serial,"%s",value); 
        else {  cfg.setValue("serial",DEFAULT_MB_SERIAL); sprintf(serial,"%s",DEFAULT_MB_SERIAL); }
        
        if (strncmp("V03",serial,3) == 0)
        {
            ver_carte = 1;
            AD5260::get()->init();
        }
        // ip
        if (cfg.getValue("ip", &value[0], sizeof(value)) == true) sprintf(_ip,"%s",value); 
        else {  cfg.setValue("ip",DEFAULT_IP); sprintf(_ip,"%s",DEFAULT_IP); }
        
        // mb_dac1_x
        if (cfg.getValue("dac1_1", &value[0], sizeof(value)) == true) dac1_1 = atoi(value); 
        else {  cfg.setValue("dac1_1",DEFAULT_MB_DAC1_1); dac1_1 = atoi(DEFAULT_MB_DAC1_1); }       
        if (cfg.getValue("dac1_2", &value[0], sizeof(value)) == true) dac1_2 = atoi(value); 
        else {  cfg.setValue("dac1_2",DEFAULT_MB_DAC1_2); dac1_2 = atoi(DEFAULT_MB_DAC1_2); }       
        if (cfg.getValue("dac1_3", &value[0], sizeof(value)) == true) dac1_3 = atoi(value); 
        else {  cfg.setValue("dac1_3",DEFAULT_MB_DAC1_3); dac1_3 = atoi(DEFAULT_MB_DAC1_3); }       
        if (cfg.getValue("dac1_4", &value[0], sizeof(value)) == true) dac1_4 = atoi(value); 
        else {  cfg.setValue("dac1_4",DEFAULT_MB_DAC1_4); dac1_4 = atoi(DEFAULT_MB_DAC1_4); }   
        
        // mb_dac2_x
        if (cfg.getValue("dac2_1", &value[0], sizeof(value)) == true) dac2_1 = atoi(value);
        else {  cfg.setValue("dac2_1",DEFAULT_MB_DAC2_1); dac2_1 = atoi(DEFAULT_MB_DAC2_1); }           
        if (cfg.getValue("dac2_2", &value[0], sizeof(value)) == true) dac2_2 = atoi(value);
        else {  cfg.setValue("dac2_2",DEFAULT_MB_DAC2_2); dac2_2 = atoi(DEFAULT_MB_DAC2_2); }       
        if (cfg.getValue("dac2_3", &value[0], sizeof(value)) == true) dac2_3 = atoi(value); 
        else {  cfg.setValue("dac2_3",DEFAULT_MB_DAC2_3); dac2_3 = atoi(DEFAULT_MB_DAC2_3); }       
        if (cfg.getValue("dac2_4", &value[0], sizeof(value)) == true) dac2_4 = atoi(value); 
        else {  cfg.setValue("dac2_4",DEFAULT_MB_DAC2_4); dac2_4 = atoi(DEFAULT_MB_DAC2_4); }   

        // mb_ad5263_x
        if (cfg.getValue("gain_1", &value[0], sizeof(value)) == true) gain_1 = atoi(value); 
        else {  cfg.setValue("gain_1",DEFAULT_MB_AD5263_1); gain_1 = atoi(DEFAULT_MB_AD5263_1); }       
        if (cfg.getValue("gain_2", &value[0], sizeof(value)) == true) gain_2 = atoi(value); 
        else {  cfg.setValue("gain_2",DEFAULT_MB_AD5263_2); gain_2 = atoi(DEFAULT_MB_AD5263_2); }       
        if (cfg.getValue("gain_3", &value[0], sizeof(value)) == true) gain_3 = atoi(value); 
        else {  cfg.setValue("gain_3",DEFAULT_MB_AD5263_3); gain_3 = atoi(DEFAULT_MB_AD5263_3); }       
        if (cfg.getValue("gain_4", &value[0], sizeof(value)) == true) gain_4 = atoi(value); 
        else {  cfg.setValue("gain_4",DEFAULT_MB_AD5263_4); gain_4 = atoi(DEFAULT_MB_AD5263_3); } 
        if (cfg.getValue("gain_5", &value[0], sizeof(value)) == true) gain_5 = atoi(value); 
        else {  cfg.setValue("gain_5",DEFAULT_MB_AD5260); gain_5 = atoi(DEFAULT_MB_AD5260); } 
        if (cfg.getValue("gain_6", &value[0], sizeof(value)) == true) gain_6 = atoi(value); 
        else {  cfg.setValue("gain_6",DEFAULT_MB_AD5262); gain_6 = atoi(DEFAULT_MB_AD5262); } 
    }
    setAll (0);
    setConfig(0,"all",all);
    printConfig();   
    applyConfig(0);
   
    return 0;
}

void LocalConfig::printConfig()
{
    if (ENABLE_TRACE) 
    {
        sprintf(trace,"\r\nCONFIG:\r\nip:%s\r\nserial:%s", _ip, serial); DiplayTrace(trace);
        sprintf(trace,"\r\ndac1_1:%u\r\ndac1_2:%u\r\ndac1_3:%u\r\ndac1_4:%u", dac1_1,dac1_2,dac1_3,dac1_4); DiplayTrace(trace);
        sprintf(trace,"\r\ndac2_1:%u\r\ndac2_2:%u\r\ndac2_3:%u\r\ndac2_4:%u", dac2_1,dac2_2,dac2_3,dac2_4); DiplayTrace(trace);
        sprintf(trace,"\r\ngain_1:%u\r\ngain_2:%u\r\ngain_3:%u\r\ngain_4:%u", gain_1,gain_2,gain_3,gain_4); DiplayTrace(trace);
        sprintf(trace,"\r\ngain_5:%u\r\ngain_6:%u", gain_5,gain_6); DiplayTrace(trace);
        sprintf(trace,"\r\nall:%s\r\n",all); DiplayTrace(trace);
    }
}

void LocalConfig::setAll (bool typ)
{
    char value[75];
    uint8_t i = 0;
    if (typ)
    {
        dac1_1 = tmp_dac1_1; dac1_2 = tmp_dac1_2; dac1_3 = tmp_dac1_3; dac1_4 = tmp_dac1_4;
        dac2_1 = tmp_dac2_1; dac2_2 = tmp_dac2_2; dac2_3 = tmp_dac2_3; dac2_4 = tmp_dac2_4;
        gain_1 = tmp_gain_1; gain_2 = tmp_gain_2; gain_3 = tmp_gain_3; gain_4 = tmp_gain_4; 
        gain_5 = tmp_gain_5; gain_6 = tmp_gain_6;
    }
    else
    {
        tmp_dac1_1 = dac1_1; tmp_dac1_2 = dac1_2; tmp_dac1_3 = dac1_3; tmp_dac1_4 = dac1_4;
        tmp_dac2_1 = dac2_1; tmp_dac2_2 = dac2_2; tmp_dac2_3 = dac2_3; tmp_dac2_4 = dac2_4;
        tmp_gain_1 = gain_1; tmp_gain_2 = gain_2; tmp_gain_3 = gain_3; tmp_gain_4 = gain_4; 
        tmp_gain_5 = gain_5; tmp_gain_6 = gain_6;       
    }
    sprintf(value, "%u", dac1_1); if (typ) cfg.setValue ("dac1_1",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac1_2); if (typ) cfg.setValue ("dac1_2",value); 
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac1_3); if (typ) cfg.setValue ("dac1_3",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac1_4); if (typ) cfg.setValue ("dac1_4",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac2_1); if (typ) cfg.setValue ("dac2_1",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac2_2); if (typ) cfg.setValue ("dac2_2",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac2_3); if (typ) cfg.setValue ("dac2_3",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", dac2_4); if (typ) cfg.setValue ("dac2_4",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;

    sprintf(value, "%u", gain_1); if (typ) cfg.setValue ("gain_1",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", gain_2); if (typ) cfg.setValue ("gain_2",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", gain_3); if (typ) cfg.setValue ("gain_3",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", gain_4); if (typ) cfg.setValue ("gain_4",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", gain_5); if (typ) cfg.setValue ("gain_5",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); all[i++]=0x3b;
    sprintf(value, "%u", gain_6); if (typ) cfg.setValue ("gain_6",value);
    memcpy((char *)&all[i], (char *)&value, strlen(value)); i += strlen(value); 
    for (;i<sizeof(all);i++)
        all[i]=0;
    memcpy(tmp_all,all,sizeof(all));
}

bool LocalConfig::setConfig(uint8_t num_card,char *key, char *value)
{
    if (ENABLE_TRACE) {sprintf(trace,"setConfig card %d '%s' = '%s'\r\n",num_card,key,value); DiplayTrace(trace);}

    ConfigFile *p_cfg = NULL;
    
    switch (num_card)
    {
        case 0: p_cfg = &cfg;   break;
        case 1: return cfg1.setConfig(key,value); 
        case 2: return cfg2.setConfig(key,value); 
        case 3: return cfg3.setConfig(key,value); 
        case 4: return cfg4.setConfig(key,value); 
        case 5: return cfg5.setConfig(key,value);    
        case 6: return cfg6.setConfig(key,value);       
        default:
            return false;
    }

    char tmp[75];
    if (p_cfg->getValue(key, &tmp[0], sizeof(tmp)) == true)
    {
        return p_cfg->setValue(key,value); 
    }
    else
    {
        if (ENABLE_TRACE) {sprintf(trace,"setConfig : %s is not a valid parameter !!\r\n",key); DiplayTrace(trace);}
        return false;
    }
}

bool LocalConfig::getConfig(uint8_t num_card, char *key, char *buffer, uint8_t buffer_len)
{   //Config Memoire
    if (ENABLE_TRACE) {sprintf(trace,"getConfig mem card %d '%s'\r\n",num_card,key); DiplayTrace(trace);}
    
    if (buffer_len < 32) 
        return false;
    memset(buffer,0x0,buffer_len);

    ConfigFile *p_cfg = NULL;
    
    switch (num_card)
    {
        case 0:  p_cfg = &cfg;    break;
        case 1:  return cfg1.getConfig(key,buffer,buffer_len); 
        case 2:  return cfg2.getConfig(key,buffer,buffer_len); 
        case 3:  return cfg3.getConfig(key,buffer,buffer_len); 
        case 4:  return cfg4.getConfig(key,buffer,buffer_len); 
        case 5:  return cfg5.getConfig(key,buffer,buffer_len); 
        case 6:  return cfg6.getConfig(key,buffer,buffer_len); 
        default:
            return false;
    }
    
    if (p_cfg->getValue(key, &buffer[0], buffer_len) == false)
    {
        if (ENABLE_TRACE) {sprintf(trace,"getConfig : %s is not a valid parameter !!\r\n",key); DiplayTrace(trace);}
        return false;
    }
    else
    {
        return true;
    }
}
bool LocalConfig::getConf(uint8_t num_card, char *buffer, uint8_t buffer_len)
{   //config programmée
    char value[75];
    uint8_t i = 0;
    if (ENABLE_TRACE) {sprintf(trace,"getConfig card %d \r\n",num_card); DiplayTrace(trace);}
    
    if (buffer_len < 32) 
        return false;
    memset(buffer,0x0,buffer_len);
    
    switch (num_card)
    {
        case 0:  break;
        case 1:  return cfg1.getConf(0,buffer,buffer_len); 
        case 2:  return cfg2.getConf(1,buffer,buffer_len); 
        case 3:  return cfg3.getConf(2,buffer,buffer_len); 
        case 4:  return cfg4.getConf(3,buffer,buffer_len); 
        case 5:  return cfg5.getConf(4,buffer,buffer_len); 
        case 6:  return cfg6.getConf(5,buffer,buffer_len); 
        default:
            return false;
    }

    sprintf(value, "%u", tmp_dac1_1); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac1_2); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac1_3); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac1_4); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac2_1); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac2_2);
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac2_3);
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_dac2_4); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;

    sprintf(value, "%u", tmp_gain_1);
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_gain_2); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_gain_3); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_gain_4); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_gain_5); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); 
    if (!ver_carte)
        return true;
    
    buffer[i++]=0x3b;
    sprintf(value, "%u", tmp_gain_6); 
    memcpy((char *)&buffer[i], (char *)&value, strlen(value));  i += strlen(value); 

    return true;
}

bool LocalConfig::applyConfig(uint8_t num_card)
{
    if (ENABLE_TRACE) {sprintf(trace,"applyConfig card %d \r\n",num_card); DiplayTrace(trace);}

    switch (num_card)
    {

        case 0:
            //Mother Board
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x00 /*DAC 0*/,dac1_1,ChipSelector::CS_DAC1_LOCAL); //V1
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x01 /*DAC 1*/,dac1_2,ChipSelector::CS_DAC1_LOCAL); //V2
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x02 /*DAC 2*/,dac1_3,ChipSelector::CS_DAC1_LOCAL); //V3
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x03 /*DAC 3*/,dac1_4,ChipSelector::CS_DAC1_LOCAL); //V4
    
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x00 /*DAC 0*/,dac2_1,ChipSelector::CS_DAC2_LOCAL); //V1
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x01 /*DAC 1*/,dac2_2,ChipSelector::CS_DAC2_LOCAL); //V2
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x02 /*DAC 2*/,dac2_3,ChipSelector::CS_DAC2_LOCAL); //V3
            LTC2664::get()->write_data(0x03 /* write code to n, update n*/,0x03 /*DAC 3*/,dac2_4,ChipSelector::CS_DAC2_LOCAL); //V4
            
            AD5263::get()->write_data(0,gain_1,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(1,gain_2,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(2,gain_3,ChipSelector::CS_AD5263_LOCAL); 
            AD5263::get()->write_data(3,gain_4,ChipSelector::CS_AD5263_LOCAL); 
            
            AD5260::get()->write_data(0,gain_5,ChipSelector::CS_AD5260_LOCAL);
            AD5260::get()->write_data(1,gain_6,ChipSelector::CS_AD5260_LOCAL);
            return true;
        
        case 1:  return cfg1.applyConfig(); 
        case 2:  return cfg2.applyConfig(); 
        case 3:  return cfg3.applyConfig(); 
        case 4:  return cfg4.applyConfig(); 
        case 5:  return cfg5.applyConfig(); 
        case 6:  return cfg6.applyConfig(); 
        default:
            return false;
    }
     //return false;    
}


bool LocalConfig::saveConfig(uint8_t num_card)
{
    ConfigFile *p_cfg = NULL;
    
    switch (num_card)
    {
        case 0:  p_cfg = &cfg;  break;
        case 1:  return cfg1.saveConfig(); 
        case 2:  return cfg2.saveConfig(); 
        case 3:  return cfg3.saveConfig(); 
        case 4:  return cfg4.saveConfig(); 
        case 5:  return cfg5.saveConfig(); 
        case 6:  return cfg6.saveConfig();      
        default:
            return false;
    }
  
    uint8_t *buffer_config;
    buffer_config = p_cfg->writeBuffer();
    if (buffer_config == NULL)
    {
        if (ENABLE_TRACE) {sprintf(trace,"Error on make config!!!\r\n"); DiplayTrace(trace);}
        return false;
    }
    if (ENABLE_TRACE) {sprintf(trace,"make config %s\r\n",buffer_config); DiplayTrace(trace);}
    if ( CAT25160::get()->writeConfigCheck( buffer_config,strlen((char *)buffer_config)+1,ChipSelector::CS_EEPROM_LOCAL) == -1)
    {
        if (ENABLE_TRACE) {sprintf(trace,"Error on write config\r\n"); DiplayTrace(trace);}
        free(buffer_config);
        return false;
    }
    free(buffer_config);

    return true;
}


// MotherBoard
char *   LocalConfig::get_ip(){    return _ip;   }
char *   LocalConfig::get_mb_serial(){    return serial;   }
char *   LocalConfig::get_all()      {    return all;       }
uint16_t LocalConfig::get_mb_dac1_1(){    return dac1_1;   }
uint16_t LocalConfig::get_mb_dac1_2(){    return dac1_2;   }
uint16_t LocalConfig::get_mb_dac1_3(){    return dac1_3;   }
uint16_t LocalConfig::get_mb_dac1_4(){    return dac1_4;   }

uint16_t LocalConfig::get_mb_dac2_1(){    return dac2_1;   }
uint16_t LocalConfig::get_mb_dac2_2(){    return dac2_2;   }
uint16_t LocalConfig::get_mb_dac2_3(){    return dac2_3;   }
uint16_t LocalConfig::get_mb_dac2_4(){    return dac2_4;   }

uint8_t LocalConfig::get_mb_ad5263_1(){    return gain_1;   }
uint8_t LocalConfig::get_mb_ad5263_2(){    return gain_2;   }
uint8_t LocalConfig::get_mb_ad5263_3(){    return gain_3;   }
uint8_t LocalConfig::get_mb_ad5263_4(){    return gain_4;   }

uint8_t LocalConfig::get_mb_ad5260(){    return gain_5;   }
uint8_t LocalConfig::get_mb_ad5262(){    return gain_6;   }

