#ifndef MBED_LTC2664_H
#define MBED_LTC2664_H

/*support SPI serial interface (10 MHz, modes 0,0 & 1,1)*/

#include "mbed.h"
#include "ChipSelector.h"
 
class LTC2664 {
public:
    LTC2664(PinName mosi,PinName miso, PinName scl);

    static LTC2664 *get()  {
        return &sSingleton;
    }
    
    int init();
    void write_data(uint8_t command,uint8_t dac_addr, uint16_t data,ChipSelector::ChipToSelect cs);

private:
    SPI _spi; 
    bool _initComplete;

    static LTC2664 sSingleton;

    // methods
    LTC2664& operator=(const LTC2664&);
    LTC2664(const LTC2664&);    
};

#endif
 