#include "mbed.h"

#include "ChipSelector.h"
#include "LTC2664.h"
#include "Global.h"
 
/*  SPI DATA FORMAT (MSB First):

 24-Bit Load Sequence:

              Byte #1                       Byte #2                       Byte #3
              Command                   MSB                             LSB
 LTC2664-16 : C3 C2 C1 C0 A3 A2 A1 A0   D15 D14 D13 D12 D11 D10 D9 D8   D7 D6 D5 D4 D3 D2 D1 D0
 LTC2664-12 : C3 C2 C1 C0 A3 A2 A1 A0   D11 D10 D9  D8  D7  D6  D5 D4   D3 D2 D1 D0 X  X  X  X

 32-Bit Load Sequence:
              Byte #1                       Byte #2                       Byte #3                 Byte #4
              Command                   MSB                             LSB
 LTC2664-16 : X  X  X  X  X  X  X  X    C3 C2 C1 C0 A3 A2 A1 A0   D15 D14 D13 D12 D11 D10 D9 D8   D7 D6 D5 D4 D3 D2 D1 D0
 LTC2664-12 : X  X  X  X  X  X  X  X    C3 C2 C1 C0 A3 A2 A1 A0   D11 D10 D9  D8  D7  D6  D5 D4   D3 D2 D1 D0 X  X  X  X

 Cx   : DAC Command Code
 Ax   : DAC Address (0 to F, corresponding to DAC 0 to DAC 15)
 Dx   : DAC Data Bits
 X    : Don't care
*/


/* 

--------- DAC Command Code LIST ---------

C3 C2 C1 C0
0 0 0 0 Write Code to n
1 0 0 0 Write Code to All
0 1 1 0 Write Span to n
1 1 1 0 Write Span to All
0 0 0 1 Update n (Power Up)
1 0 0 1 Update All (Power Up)
0 0 1 1 Write Code to n, Update n (Power Up)
0 0 1 0 Write Code to n, Update All (Power Up)
1 0 1 0 Write Code to All, Update All (Power Up)
0 1 0 0 Power Down n
0 1 0 1 Power Down Chip (All DACs, Mux and Reference)
1 0 1 1 Analog Mux
1 1 0 0 Toggle Select
1 1 0 1 Global Toggle
0 1 1 1 Config
1 1 1 1 No Operation
*/

/*
 -------- DAC Address --------
A3 A2 A1 A0
0 0 0 0 DAC 0
0 0 0 1 DAC 1
0 0 1 0 DAC 2
0 0 1 1 DAC 3
*/
static char trace[100];
LTC2664 LTC2664::sSingleton = LTC2664(PTD2, PTD3, PTD1); //SPI connecteur mbed J2
//LTC2664 LTC2664::sSingleton = LTC2664(PTD6,PTD7,PTD5); // SPI connecteur mbed J6

LTC2664::LTC2664(PinName mosi,PinName miso, PinName scl)
        : _spi(mosi, miso, scl)// mosi, miso, sclk
      
{
    _initComplete = false;
}

int LTC2664::init()
{
    // Chip must be deselected
    ChipSelector::get()->unselectAll();
 
    // Setup the spi for 8 bits data, 
    // 10KHz clock rate
    _spi.format(8,3);
    _spi.frequency(1000000);
  
    _initComplete = true;
  
    return 0;
}

void LTC2664::write_data(uint8_t command,uint8_t dac_addr, uint16_t data,ChipSelector::ChipToSelect cs)
{
    uint8_t value;
    //uint8_t ret;

    ChipSelector::get()->unselectAll();
    if (ENABLE_TRACE) 
    {
        switch (dac_addr)
        {
            case 0:
                if (cs == ChipSelector::CS_DAC1_LOCAL)
                    sprintf(trace,"DAC1_1:%u\r\n",data); 
                else if (cs == ChipSelector::CS_DAC2_LOCAL)
                    sprintf(trace,"DAC1_2:%u\r\n",data);
                else
                    sprintf(trace,"DAC_FILLE_1:%u\r\n",data);
                break;   
            case 1:
                if (cs == ChipSelector::CS_DAC1_LOCAL)
                    sprintf(trace,"DAC1_2:%u\r\n",data);
                else if (cs == ChipSelector::CS_DAC2_LOCAL)
                    sprintf(trace,"DAC2_2:%u\r\n",data);
                else
                    sprintf(trace,"DAC_FILLE_2:%u\r\n",data);
                break;       
            case 2:
                if (cs == ChipSelector::CS_DAC1_LOCAL)
                    sprintf(trace,"DAC1_3:%u\r\n",data);
                else if (cs == ChipSelector::CS_DAC2_LOCAL)
                    sprintf(trace,"DAC2_3:%u\r\n",data);
                else
                    sprintf(trace,"DAC_FILLE_3:%u\r\n",data);
                break;
            case 3:
                if (cs == ChipSelector::CS_DAC1_LOCAL)
                    sprintf(trace,"DAC1_4:%u\r\n",data);
                else if (cs == ChipSelector::CS_DAC2_LOCAL)
                    sprintf(trace,"DAC2_4:%u\r\n",data);
                else
                    sprintf(trace,"DAC_FILLE_4:%u\r\n",data);
                break;
                 
            default:
                break;
        }
        DiplayTrace(trace);
    }
    
    ChipSelector::get()->setCS(cs,0);
    //wait_us(10);
    
    // Byte #1
    value = ((command & 0x0f) << 4 | (dac_addr & 0x0f) ) ; // C3 C2 C1 C0 A3 A2 A1 A0
    _spi.write(value);

    // Byte #2
    value = (data >> 8) ; // D15 D14 D13 D12 D11 D10 D9 D8
    _spi.write(value);

    // Byte #3
    value = (data & 0xff) ; // D7 D6 D5 D4 D3 D2 D1 D0
    _spi.write(value);

    ChipSelector::get()->setCS(cs,1);
    //wait_us(10);
}
