#ifndef MBED_LTC2345_H
#define MBED_LTC2345_H

/*support SPI serial interface (10 MHz, modes 0,0 & 1,1)*/

#include "mbed.h"

//#define MAX_CAPTURE_SIZE     4000*5*3
//#define MAX_CAPTURE_NUM_CHANNEL 5
#define TAILLE_BUF_CIRC     15

extern uint16_t trigger_count;
extern uint8_t buf;
extern uint8_t acq_modul_off;
extern DigitalOut modulation_out;
extern DigitalOut cs_ltc2348;

extern uint32_t tick;

class LTC234x {
public:
    LTC234x();

    static LTC234x *get()  
    {
        return &sSingleton;
    }
      
    int init();
    int test_memory_2348(uint8_t channels, uint16_t points,uint8_t nbMoyMod, uint8_t delai, uint32_t tempo, uint16_t freq, uint8_t mode);
    int start_capture_2348_mode0();
    int start_capture_2348_mode1();
    int start_capture_2348_mode2();
    int start_capture_2348_mode3();
    int start_capture_2348_mode4();
    int start_capture_2348_mode5();
    int start_capture_2348_mode6();
    int start_capture_2348_mode7();
    uint8_t *capture_buffer;
    uint8_t *capture_buffer_to_send[TAILLE_BUF_CIRC];
    
private:
    SPI _spi; 
    bool _initComplete;
    
    uint16_t    _capture_count;
    uint32_t     swap_endian(uint32_t dword);

    DigitalIn busy_ltc2345; 
    DigitalIn busy_ltc2348; 

    static LTC234x sSingleton;

    // methods
    LTC234x& operator=(const LTC234x&);
    LTC234x(const LTC234x&);    
    
    int dump_data_memory(char *buffer,uint16_t len,int num_channel);
};


#endif

