#include "mbed.h"
#include "rtos.h"

#include "LTC234x.h"
#include "Global.h"
#include "ChipSelector.h" 
#include "TaskEthernet.h"
#include "MK64F12.h"

DigitalOut  cnv_ltc2348(PTB2);
DigitalOut  cs_ltc2348(PTC3);

DigitalOut  modulation_out(PTC10);

InterruptIn in_trigger(PTB11);
//InterruptIn in_trigger2(PTB10);
//DigitalIn in_trigger2(PTB10);
DigitalIn in_trigger2(PTB20);   //pin3 J6

LTC234x     LTC234x::sSingleton;
    
//
// config pour choisir les channels et amplitude
//

uint8_t _adc_tx_chans_buffer[18] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
uint16_t trigger_count; 
uint8_t trigger2_count; 
uint32_t memory = 0;
uint8_t *pbuffer_config = NULL;
uint8_t buf = 0; 
Timer timer;
int32_t somme[5] ;
int32_t stmp32;
uint32_t tmp32;
uint32_t *ptmp32;
uint8_t tmp_buffer[5*3];
uint32_t moy_count;
uint32_t moy;
uint32_t current_timer;
uint8_t moy_mod_count;
uint8_t t_wait;
int32_t zero[5] ;
uint32_t data[5] ;

uint8_t span;
uint8_t nbr_channels = 0;
uint8_t nbr_reel_channels = 0;
uint16_t nb_points = 0;
uint8_t nb_MoyMod = 0;
uint8_t nb_delai = 0;
int32_t nb_tempo = 0;
uint8_t PtIgnores = 0;

uint8_t acq_modul_off = 0;
bool channel_0_on;
bool channel_1_on;
bool channel_2_on;
bool channel_3_on;
bool channel_4_on;
bool channel_5_on;
//bool sens;
static char trace[100];

// INTERRUPTIONS
void trigger_rise(void) 
{

//  if (!in_trigger2)
//      position_count++;
//  else
//      position_count--;
    trigger_count++;    
}

// FIN INTERRUPTIONS   
LTC234x::LTC234x()
        : _spi(PTD2, PTD3, PTD1)// mosi, miso, sclk
        ,busy_ltc2345(PTB9) //in
        ,busy_ltc2348(PTB3) //in     
{
    in_trigger.rise(&trigger_rise);
    
    _initComplete = false;
}
 
int LTC234x::init()
{   
    if ( _initComplete == true)
    {
        if (ENABLE_TRACE) {sprintf(trace,"Error LTC234x::init already initialize !!!d\r\n"); DiplayTrace(trace);}
        
        return -1;
    }
    
    // Setup the spi for 8 bits data, 
    _spi.format(8,3);    
    _spi.frequency(1000000); 
    
    cs_ltc2348 = 0;
    
    _spi.write((char*)_adc_tx_chans_buffer, 3, (char*)&tmp_buffer[0], 3);

    cnv_ltc2348 = 0;
    cs_ltc2348 = 1;
    _initComplete = true;
  
    return 0;
}

int LTC234x::dump_data_memory(char *buffer,uint16_t points,int num_channel)
{
    for (int i=0; i < (points*num_channel*3) + points; i++)
    {
        if (ENABLE_TRACE) {sprintf(trace,"0x%02x ", buffer[i]); DiplayTrace(trace);}
        if ( (i+1) % ((num_channel*3)+1) == 0)
        {
            if (ENABLE_TRACE) {sprintf(trace,"\r\n"); DiplayTrace(trace);}
        }
    }
    if (ENABLE_TRACE) {sprintf(trace,"done\r\n");  DiplayTrace(trace);}
    
    return 0;
}
int LTC234x::test_memory_2348(uint8_t channels, uint16_t points, uint8_t nbMoyMod, uint8_t delai, uint32_t tempo, uint16_t freq, uint8_t mode)
{
    nb_points = points;
    nb_MoyMod = nbMoyMod;
    nb_delai = delai;
    nb_tempo = tempo;
    nbr_channels = 0;
    
    memset (_adc_tx_chans_buffer,0x00,sizeof(_adc_tx_chans_buffer));
    channel_0_on = 0;channel_1_on = 0;channel_2_on = 0;
    channel_3_on = 0;channel_4_on = 0;channel_5_on = 0;
    nbr_reel_channels = 0;
    
    if (Mode0 || Mode1 || Mode2 || Mode3 || Mode4 || Mode5 || Mode6 || Mode7)
        return -1;
    
    if ( (channels & 0x01) == 0x01 ) 
        {nbr_channels = 1; channel_0_on = 1; _adc_tx_chans_buffer[2] |= 0x02; nbr_reel_channels++;}
    if ( (channels & 0x02) == 0x02 ) 
        {nbr_channels = 2; channel_1_on = 1; _adc_tx_chans_buffer[2] |= 0x10; nbr_reel_channels++;}
    if ( (channels & 0x04) == 0x04 ) 
        {nbr_channels = 3; channel_2_on = 1; _adc_tx_chans_buffer[2] |= 0x80; nbr_reel_channels++;}
    if ( (channels & 0x08) == 0x08 ) 
        {nbr_channels = 4; channel_3_on = 1; _adc_tx_chans_buffer[1] |= 0x04; nbr_reel_channels++;}
    if ( (channels & 0x10) == 0x10 ) 
        {nbr_channels = 5; channel_4_on = 1; _adc_tx_chans_buffer[1] |= 0x20; nbr_reel_channels++;}
    if ( (channels & 0x20) == 0x20 ) 
        {nbr_channels = 6; channel_5_on = 1; _adc_tx_chans_buffer[0] |= 0x01; nbr_reel_channels++;}
        
    if (nbr_reel_channels == 0) 
        return -1;      //si pas de channel selectionné
    if (nb_MoyMod == 0)     
        nb_MoyMod = 1;  //pour eviter les divisions par zero
    
    pbuffer_config = _adc_tx_chans_buffer; 
    
    if (_initComplete == false)
        return -1;

    if (capture_buffer != NULL)
    {
        free(capture_buffer);
        capture_buffer = NULL;
    }
    
    for (uint8_t k = 0; k < TAILLE_BUF_CIRC; k++)
    {   
        if (capture_buffer_to_send[k] != NULL)
        {
            free(capture_buffer_to_send[k]);
            capture_buffer_to_send[k] = NULL;
        }
    }

    if (mode == 6 )//|| mode == 7
        memory = ((points * nbr_reel_channels * 3) + points)* nb_MoyMod + 1 ;
    else
        memory = (points * nbr_reel_channels * 3) + points + 1 ; // 3 octets par point + delta capture + 0x03 de fin de trame TLV

    if (ENABLE_TRACE) {sprintf(trace,"start_capture_2348 memory needed:(%u) for %u channels \r\n",memory,nbr_channels); DiplayTrace(trace);}
    
    capture_buffer = (uint8_t *)malloc(memory); 

    if (capture_buffer == NULL) 
    {
        if (ENABLE_TRACE) {sprintf(trace,"init MALLOC Error (%d)\r\n",memory); DiplayTrace(trace);}
        return -1;
    }

    _spi.frequency(freq * 1000);

    ChipSelector::get()->unselectAll();

    if (!acq_modul_off && mode != 6)
    {
        modulation_out = !SensTrig; 
        thread_sleep_for(tempo_source);
    }
        
    //init Mode
    cnv_ltc2348 = 0;
    cs_ltc2348 = 0;
    memset(capture_buffer,0xa0,memory);
    // un coup dans le vent pour configurer la prochaine capture
    cnv_ltc2348 = 1;
    cnv_ltc2348 = 0;
    _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&capture_buffer[0], nbr_channels*3);// nbr_channels channels, avec 3 octets par channel
    // fin coup dans le vent 
    _capture_count = 0;
    moy_mod_count = 0;
    moy_count = 0; 
    memset(somme,0x00,nbr_channels*sizeof(uint32_t));
    memset(zero,0x00,nbr_channels*sizeof(uint32_t));
    PtIgnores = 0;
    t_wait = 1;
    trigger_count = 0;

    return 0;
}
//Mode 0 
int LTC234x::start_capture_2348_mode0()
{   
    while((_capture_count < nb_points) && Mode0)
    {
        //start cnv
        cnv_ltc2348 = 1;
        cnv_ltc2348 = 0;
        _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);

        uint8_t j = 0;
        for (uint8_t i=0; i < nbr_channels; i++)
        {
            capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] = tmp_buffer[(i*3)];  
            capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) + 1] = tmp_buffer[(i*3) + 1];
            capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) + 2] = tmp_buffer[(i*3) + 2];
            if(i==0 && channel_0_on) j++;
            if(i==1 && channel_1_on) j++;
            if(i==2 && channel_2_on) j++;
            if(i==3 && channel_3_on) j++;   
            if(i==4 && channel_4_on) j++;
            if(i==5 && channel_5_on) j++;           
        }
        capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) + 3] = 0;//(uint8_t) timer.read_us();

        _capture_count++;
    }
   
    cs_ltc2348 = 1;
    if (!acq_modul_off)
        modulation_out = SensTrig;
    Mode0 = 0;
    
    return 0;
}

// mode tempo
int LTC234x::start_capture_2348_mode1()
{
    timer.start();
    while((_capture_count < nb_points) && Mode1)
    {   
        //start cnv
        cnv_ltc2348 = 1;
        cnv_ltc2348 = 0;  
        _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
        
        // fait la somme des channels ATTENTION à ne pas dépasser la limite (16384 sommes si pleine échelle)
        // tmp_buffer contient 3 octets par channel, il faut extraire les 18 bits de poids faible
        for (uint8_t i=0; i < nbr_channels; i++)
        {
            ptmp32 = (uint32_t *) &tmp_buffer[i*3];
            tmp32 = *ptmp32;
            tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
            span = (tmp32 >> 8) & 0x03;
            tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
            tmp32 = tmp32 & 0x3ffff;
            if (tmp32 <= 131072 - 1)
            {
                stmp32 = tmp32;
                somme[i] += stmp32;
                if (somme[i] < 0)   //si on change de signe, ce qui veut dire que l'on a depassé la limite
                {                   //on moyenne l'existant 
                    somme[i] -= stmp32;
                    somme[i] = somme[i] / (int32_t) moy_count;
                    moy_count = 0; 
                }   
            }
            else
            {
                stmp32 = tmp32 - 262144;
                somme[i] += stmp32; 
                if (somme[i] > 0)
                {   
                    somme[i] -= stmp32;
                    somme[i] = somme[i] / (int32_t) moy_count;
                    moy_count = 0; 
                }   
            }
        }
        moy_count++;
        
        current_timer = timer.read_us();
        if (current_timer >= nb_tempo)
        {      
            uint8_t j=0;
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                somme[i] = somme[i] / (int32_t) moy_count;              
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] =    (somme[i] >> (10)) & 0xff ; 
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +1] = (somme[i] >> (2)) & 0xff;
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +2] = ((somme[i] << (6)) & 0xc0) | (i<<3) | span; // 24 >> et 6 <<
                if(i==0 && channel_0_on) j++;
                if(i==1 && channel_1_on) j++;
                if(i==2 && channel_2_on) j++;
                if(i==3 && channel_3_on) j++;   
                if(i==4 && channel_4_on) j++;
                if(i==5 && channel_5_on) j++;
            }
            capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) + 3] = current_timer;
            
            _capture_count++;
            memset(somme,0x00,nbr_channels*sizeof(int32_t));
            moy_count = 0;
            
            timer.reset();
        }
    }
   
    timer.stop();
    timer.reset();
    cs_ltc2348 = 1;
    if (!acq_modul_off)
        modulation_out = SensTrig;
    Mode1 = 0;

    return 0;
}

// mode trigger
int LTC234x::start_capture_2348_mode2()
{
    float pas_temp = 0;
    int16_t diff_pas = 0;
    uint32_t count_trig = 0;
    float nbr_pas_mm = nb_tempo;

    nbr_pas_mm /= 100;
    nb_tempo = nbr_pas_mm;
    trigger_count = 0;
    
    while ((_capture_count < nb_points) && Mode2)
    {
        //start cnv
        cnv_ltc2348 = 1;
        cnv_ltc2348 = 0;  
        _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
               
        // fait la somme des channels ATTENTION à ne pas dépasser la limite (16384 sommes si pleine échelle)
        // tmp_buffer contient 3 octets par channel, il faut extraire les 18 bits de poids faible
        for (uint8_t i=0; i < nbr_channels; i++)
        {
            ptmp32 = (uint32_t *) &tmp_buffer[i*3];
            tmp32 = *ptmp32;
            tmp32 = tmp32 & 0x00ffffff;
            tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
            span = (tmp32 >> 8) & 0x03;
            tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
            tmp32 = tmp32 & 0x3ffff;
            if (tmp32 <= 131072 - 1)
            {
                stmp32 = tmp32;
                somme[i] += stmp32;
                if (somme[i] < 0)   //si on change de signe, ce qui veut dire que l'on a depassé la limite
                {                   //on moyenne l'existant 
                    somme[i] -= stmp32;
                    somme[i] = somme[i] / (int32_t) moy_count;
                    moy_count = 0; 
                }   
            }
            else
            {
                stmp32 = tmp32 - 262144;
                somme[i] += stmp32; 
                if (somme[i] > 0)
                {   
                    somme[i] -= stmp32;
                    somme[i] = somme[i] / (int32_t) moy_count;
                    moy_count = 0; 
                }   
            }
        }
        moy_count++;    
        
        if (trigger_count >= nb_tempo)
        {    
            uint8_t j=0;
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                somme[i] = somme[i] / (int32_t) moy_count;              
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] =    (somme[i] >> (10)) & 0xff ; 
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +1] = (somme[i] >> (2)) & 0xff;
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +2] = ((somme[i] << (6)) & 0xc0) | (i<<3) | span; // 24 >> et 6 <<
                if(i==0 && channel_0_on) j++;
                if(i==1 && channel_1_on) j++;
                if(i==2 && channel_2_on) j++;
                if(i==3 && channel_3_on) j++;   
                if(i==4 && channel_4_on) j++;       
                if(i==5 && channel_5_on) j++;               
            }
            capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) +3] = (uint8_t) trigger_count;
            _capture_count++;
                                
            count_trig += trigger_count;
            pas_temp = (_capture_count*nbr_pas_mm);
            diff_pas = count_trig - int16_t(pas_temp);
            
            if (diff_pas != 0)
                nb_tempo = nbr_pas_mm - diff_pas;
            else
                nb_tempo = nbr_pas_mm;  
            
            memset(somme,0x00,nbr_channels*sizeof(int32_t));
            moy_count = 0;    
            trigger_count = 0;
        }
    }
    
    cs_ltc2348 = 1;
    if (!acq_modul_off)
        modulation_out = SensTrig;
    Mode2 = 0;
        
    return 0;
}

// mode DEMOD + tempo
int LTC234x::start_capture_2348_mode3()
{  
    modulation_out = SensTrig;
    timer.start();

    while((_capture_count < nb_points) && Mode3)
    {
        if (t_wait == 0)
        {
            //start cnv
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;     
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);

            // fait la somme
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                ptmp32 = (uint32_t *) &tmp_buffer[i*3];
                tmp32 = *ptmp32;
                tmp32 = tmp32 & 0x00ffffff;
                tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
                span = (tmp32 >> 8) & 0x03;
                tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
                tmp32 = tmp32 & 0x3ffff;
                if (tmp32 <= 131072 - 1)
                {
                    stmp32 = tmp32;
                    somme[i] += stmp32;
                }
                else
                {
                    stmp32 = tmp32 - 262144;
                    somme[i] += stmp32 ;
                }
            }
            moy_mod_count++;
            
            if (moy_mod_count == nb_MoyMod)
            {
                modulation_out = !modulation_out; // inverse la sortie modulation
                t_wait = 1;
               
                if (modulation_out == SensTrig)
                {
                    for (uint8_t i=0; i < nbr_channels; i++)
                    {
                        somme[i] = (somme[i] / (int32_t) moy_mod_count);
                        if (somme[i] >= zero[i])
                            data[i] += somme[i] - zero[i];  
                        else
                            data[i] += zero[i] - somme[i];
                    }
                    moy++;
                }
                else
                {
                    for (uint8_t i=0; i < nbr_channels; i++)
                        zero[i] = somme[i] / (int32_t) moy_mod_count;
                }   
                memset(somme,0x00,nbr_channels*sizeof(int32_t)); //ajout romain
                moy_mod_count = 0;
            }          
        }
        else // wait == 1
        {        
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
            PtIgnores ++;
            if (PtIgnores == nb_delai)
            {
                t_wait = 0; 
                PtIgnores = 0;
            }
        }
            
        current_timer = timer.read_us();
        if (current_timer >= nb_tempo)
        {
            uint8_t j=0;
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                data[i] = data[i] / moy;                
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] =    (data[i] >> (10)) & 0xff ; 
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +1] = (data[i] >> (2)) & 0xff;
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +2] = ((data[i] << (6)) & 0xc0) | (i<<3) | span; // 24 >> et 6 <<
                if(i==0 && channel_0_on) j++;
                if(i==1 && channel_1_on) j++;
                if(i==2 && channel_2_on) j++;
                if(i==3 && channel_3_on) j++;   
                if(i==4 && channel_4_on) j++;   
                if(i==5 && channel_5_on) j++;               
            }
            capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) +3] = (uint8_t) current_timer;
            _capture_count++;
            timer.reset();
            memset(data,0x00,nbr_channels*sizeof(int32_t));
            moy = 0;
        }
    }// fin while
    
    timer.stop();
    timer.reset();
    cs_ltc2348 = 1;
    if (acq_modul_off == 2)
        modulation_out = !SensTrig;
    else
        modulation_out = SensTrig;
    Mode3 = 0;

    return 0;
}

// mode DEMOD + ACQ Trigger
int LTC234x::start_capture_2348_mode4()
{    
    float pas_temp = 0;
    int16_t diff_pas = 0;
    uint32_t count_trig = 0;
    float nbr_pas_mm = nb_tempo;

    nbr_pas_mm /= 100;
    nb_tempo = nbr_pas_mm;
    trigger_count = 0;
    modulation_out = SensTrig;
    
    while((_capture_count < nb_points) && Mode4)
    {
        if (t_wait == 0)
        {
            //start cnv
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);

            // fait la somme
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                ptmp32 = (uint32_t *) &tmp_buffer[i*3];
                tmp32 = *ptmp32;
                tmp32 = tmp32 & 0x00ffffff;
                tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
                span = (tmp32 >> 8) & 0x03;
                tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
                tmp32 = tmp32 & 0x3ffff;
                if (tmp32 <= 131072 -1)
                {
                    stmp32 = tmp32;
                    somme[i] += stmp32;
                }
                else
                {
                    stmp32 = tmp32 -262144;
                    somme[i] += stmp32 ;
                }
            }
            moy_mod_count++;
            
            if (moy_mod_count == nb_MoyMod)
            {
                modulation_out = !modulation_out; // inverse la sortie modulation
                t_wait = 1;
                
                if (modulation_out == SensTrig)
                {
                    for (uint8_t i=0; i < nbr_channels; i++)
                    {
                        somme[i] = (somme[i] / (int32_t) moy_mod_count);
                        if (somme[i] >= zero[i])
                            data[i] += somme[i] - zero[i];  
                        else
                            data[i] += zero[i] - somme[i];
                    }
                    moy++;
                }
                else
                {
                    for (uint8_t i=0; i < nbr_channels; i++)
                        zero[i] = somme[i] / (int32_t) moy_mod_count;
                }
                memset(somme,0x00,nbr_channels*sizeof(int32_t)); //ajout romain
                moy_mod_count = 0;
            }  
        }
        else// wait == 1
        {      
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
            PtIgnores ++;
            if (PtIgnores == nb_delai)
            {
                t_wait = 0; 
                PtIgnores = 0;
            }
        }

        if (trigger_count >= nb_tempo)
        {
            uint8_t j=0;
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                data[i] = data[i] / moy;                
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] =    (data[i] >> (10)) & 0xff ; 
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) + 1] = (data[i] >> (2)) & 0xff;
                capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) + 2] = ((data[i] << (6)) & 0xc0) | (i<<3) | span; // 24 >> et 6 <<
                if(i==0 && channel_0_on) j++;
                if(i==1 && channel_1_on) j++;
                if(i==2 && channel_2_on) j++;
                if(i==3 && channel_3_on) j++;   
                if(i==4 && channel_4_on) j++;   
                if(i==5 && channel_5_on) j++;
            }
            capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) + 3] = (uint8_t) trigger_count;
            _capture_count++;
            
            count_trig += trigger_count;
            pas_temp = (_capture_count*nbr_pas_mm);
            diff_pas = count_trig - int16_t(pas_temp);
            
            if (diff_pas != 0)
                nb_tempo = nbr_pas_mm - diff_pas;
            else
                nb_tempo = nbr_pas_mm;  
            
            memset(data,0x00,nbr_channels*sizeof(uint32_t));
            trigger_count = 0;
            moy = 0;     
        }
    }// fin while
   
    cs_ltc2348 = 1;
    if (acq_modul_off == 2)
        modulation_out = !SensTrig;
    else
        modulation_out = SensTrig;
    Mode4 = 0;

    return 0;
}

// mode DEMOD
int LTC234x::start_capture_2348_mode5()
{  
    modulation_out = SensTrig;
    while((_capture_count < nb_points) && Mode5)
    {
        if (t_wait == 0)
        {
            //start cnv
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);

            // fait la somme
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                ptmp32 = (uint32_t *) &tmp_buffer[i*3];
                tmp32 = *ptmp32;
                tmp32 = tmp32 & 0x00ffffff;
                tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
                span = (tmp32 >> 8) & 0x03;
                tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
                tmp32 = tmp32 & 0x3ffff;
                if (tmp32 <= 131072 - 1)
                {
                    stmp32 = tmp32;
                    somme[i] += stmp32;
                }
                else
                {
                    stmp32 = tmp32 - 262144;
                    somme[i] += stmp32 ;
                }
            }
            moy_mod_count++; // faut le sortir de la boucle
            
            if (moy_mod_count == nb_MoyMod)
            {
                modulation_out = !modulation_out; // inverse la sortie modulation
                t_wait = 1;
           
                if (modulation_out == SensTrig)
                {
                    uint8_t j=0;
                    for (uint8_t i=0; i < nbr_channels; i++)
                    {
                        somme[i] = somme[i] / (int32_t) moy_mod_count;
                        if (somme[i] >= zero[i])
                            somme[i] = somme[i] - zero[i];
                        else
                            somme[i] = zero[i] - somme[i];

                        capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] =    (somme[i] >> (10)) & 0xff ; 
                        capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) + 1] = (somme[i] >> (2)) & 0xff;
                        capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) + 2] = ((somme[i] << (6)) & 0xc0) | (i<<3) | span; // 24 >> et 6 <<
                        if(i==0 && channel_0_on) j++;
                        if(i==1 && channel_1_on) j++;
                        if(i==2 && channel_2_on) j++;
                        if(i==3 && channel_3_on) j++;   
                        if(i==4 && channel_4_on) j++;   
                        if(i==5 && channel_5_on) j++;
                    }
                    capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) + 3] = moy_mod_count;//(uint8_t) timer.read_us();
                    
                    _capture_count++;
                }
                else
                {
                    for (uint8_t i=0; i < nbr_channels; i++)
                    {
                        zero[i] = somme[i] /(int32_t) moy_mod_count;
                    }
                }
                memset(somme,0x00,nbr_channels*sizeof(uint32_t));
                moy_mod_count = 0;
            }
        }
        else
        {
            // wait == 1
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
            PtIgnores ++;
            if (PtIgnores == nb_delai)
            {
                t_wait = 0; 
                PtIgnores = 0;
            }
        }
    }// fin while
   
    cs_ltc2348 = 1;
    if (acq_modul_off == 2)
        modulation_out = !SensTrig;
    else
        modulation_out = SensTrig;
    Mode5 = 0;

    return 0;
}

// mode camera balayée
int LTC234x::start_capture_2348_mode6()
{   
    buf = 0; 
    uint8_t ligne = 0;
    uint16_t offset=0;
    int32_t val;

    Mode6Encours = 1;
    
    while(Mode6)
    {
        modulation_out = !SensTrig;
        _capture_count = 0;
        moy_count = 0;
        memset(somme,0x00,nbr_channels*sizeof(int32_t));        
        trigger_count = 0;
        
        while ((_capture_count < nb_points) && Mode6)
        {
            //start cnv
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
        
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
                   
//          // fait la somme des channels ATTENTION à ne pas dépasser la limite (16384 sommes si pleine échelle)
//          // tmp_buffer contient 3 octets par channel, il faut extraire les 18 bits de poids faible
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                ptmp32 = (uint32_t *) &tmp_buffer[i*3];
                tmp32 = *ptmp32;
                tmp32 = tmp32 & 0x00ffffff;
                tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
                span = (tmp32 >> 8) & 0x03;
                tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
                tmp32 = tmp32 & 0x3ffff;
                if (tmp32 <= 131072 - 1)
                {
                    stmp32 = tmp32;
                    somme[i] += stmp32;
                    if (somme[i] < 0)   //si on change de signe, ce qui veut dire que l'on a depassé la limite
                    {                   //on moyenne l'existant 
                        somme[i] -= stmp32;
                        somme[i] = somme[i] / (int32_t) moy_count;
                        moy_count = 0; 
                    }   
                }
                else
                {
                    stmp32 = tmp32 - 262144;
                    somme[i] += stmp32; 
                    if (somme[i] > 0)
                    {   
                        somme[i] -= stmp32;
                        somme[i] = somme[i] / (int32_t) moy_count;
                        moy_count = 0; 
                    }   
                }
            }
            moy_count++;
            
            if (trigger_count)
            {    
                uint8_t j=0;
                for (uint8_t i=0; i < nbr_channels; i++)
                {
                    if (trigger_count>1)
                        val = 131172;
                    else
                        val = somme[i] / (int32_t) moy_count;   
                    capture_buffer[(_capture_count*3) + _capture_count + (j*3) + offset] =      (val >> (10)) & 0xff; 
                    capture_buffer[(_capture_count*3) + _capture_count + (j*3) + 1 + offset] =  (val >> (2)) & 0xff;
                    capture_buffer[(_capture_count*3) + _capture_count + (j*3) + 2 + offset] =  ((val << (6)) & 0xc0) | (i<<3) | span;  // ((val << 6) & 0xc0) | ((pas_moteur >> 8) & 0x3F);
                    if(i==0 && channel_0_on) j++;                                                                                       // ((val << 6) & 0xc0) | (i<<3) | ((pas_moteur >> 8) & 0x07)                    
                    if(i==1 && channel_1_on) j++;
                    if(i==2 && channel_2_on) j++;
                    if(i==3 && channel_3_on) j++;   
                    if(i==4 && channel_4_on) j++;       
                    if(i==5 && channel_5_on) j++;               
                }
                //capture_buffer[(_capture_count*3) + _capture_count + 3 + offset] = (uint8_t)ligne;
                capture_buffer[(_capture_count*3) + _capture_count + 3 + offset] = not(in_trigger2);//trigger2_count;
                _capture_count++;   
                trigger_count--;
                if (trigger_count == 0)
                {
                    memset(somme,0x00,nbr_channels*sizeof(int32_t));
                    moy_count = 0;
                }                   
            }
        }
        
        ligne++;
//      trigger2_count = 0;
        if(ligne == nb_MoyMod)
        {
            modulation_out = SensTrig;
            if (capture_buffer_to_send[buf] == NULL)
                capture_buffer_to_send[buf] = (uint8_t *) malloc(memory); 
            memcpy(capture_buffer_to_send[buf],capture_buffer,memory);
            buf++;
            if (buf >= TAILLE_BUF_CIRC) 
                buf = 0;
            Mode6Encours = 0;
            ligne = 0;
        }
        offset = (nb_points * 4) * ligne;
    }

    cs_ltc2348 = 1;
    
    if (!acq_modul_off)
        modulation_out = SensTrig;
    Mode6Encours = 0;
    
    return 0;
}

// mode trigger polarisation
int LTC234x::start_capture_2348_mode7()
{    
    buf = 0;
    float nbr_pas_degre = nb_tempo;
    float pas_temp = 0;
    uint16_t count_trig = 0;
    uint16_t count_trig_old = 0;
    int16_t diff_pas = 0;
    int32_t val;
    nbr_pas_degre /= 180;
//  nbr_pas_degre /= 360;
    nb_tempo = nbr_pas_degre + 0.5f;
    uint16_t trigger_count_buffer; 
    
    Mode6Encours = 1;
    while (Mode7)
    {
        _capture_count = 0;
        count_trig = 0;
        count_trig_old = 0;
        nb_tempo = nbr_pas_degre + 0.5f;
        trigger_count_buffer = 0; 
        
        while ((_capture_count < nb_points) && Mode7)
        {
            //start cnv
            cnv_ltc2348 = 1;
            cnv_ltc2348 = 0;
            _spi.write((char*)pbuffer_config, nbr_channels*3, (char*)&tmp_buffer[0], nbr_channels*3);
                   
            // fait la somme des channels ATTENTION à ne pas dépasser la limite (16384 sommes si pleine échelle)
            // tmp_buffer contient 3 octets par channel, il faut extraire les 18 bits de poids faible
            for (uint8_t i=0; i < nbr_channels; i++)
            {
                ptmp32 = (uint32_t *) &tmp_buffer[i*3];
                tmp32 = *ptmp32;
                tmp32 = tmp32 & 0x00ffffff;
                tmp32 = ((tmp32>>24)&0x000000FF) | ((tmp32>>8)&0x0000FF00) | ((tmp32<<8)&0x00FF0000) | ((tmp32<<24)&0xFF000000); // endian swap
                span = (tmp32 >> 8) & 0x03;
                tmp32 = tmp32 >> 14; //on élimine les 8 bits dû au cast en 32 bits + 6 bits (spanbits + channel)
                tmp32 = tmp32 & 0x3ffff;
                if (tmp32 <= 131072 - 1)
                {
                    stmp32 = tmp32;
                    somme[i] += stmp32;
                    if (somme[i] < 0)   //si on change de signe, ce qui veut dire que l'on a depassé la limite
                    {                   //on moyenne l'existant 
                        somme[i] -= stmp32;
                        somme[i] = somme[i] / (int32_t) moy_count;
                        moy_count = 0; 
                    }   
                }
                else
                {
                    stmp32 = tmp32 - 262144;
                    somme[i] += stmp32; 
                    if (somme[i] > 0)
                    {   
                        somme[i] -= stmp32;
                        somme[i] = somme[i] / (int32_t) moy_count;
                        moy_count = 0; 
                    }   
                }
            }
            moy_count++;
                
            //Modif 1703
            trigger_count_buffer += trigger_count;
            count_trig += trigger_count;
            trigger_count = 0;
            
            if (trigger_count_buffer >= nb_tempo)
            {    
                uint8_t j=0;
                        
                for (uint8_t i=0; i < nbr_channels; i++)
                {
                    if (trigger_count_buffer >= (nb_tempo + nb_tempo/2))//si on est a plus d'un pixel et demi
                        val = 131172;
                    else
                        val = somme[i] / (int32_t) moy_count;   
                    capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3)] =    (val >> (10)) & 0xff ; 
                    capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +1] = (val >> (2)) & 0xff;
                    capture_buffer[(_capture_count*nbr_reel_channels*3) + _capture_count + (j*3) +2] = ((val << (6)) & 0xc0) | (i<<3) | span; // 24 >> et 6 <<
                    if(i==0 && channel_0_on) j++;
                    if(i==1 && channel_1_on) j++;
                    if(i==2 && channel_2_on) j++;
                    if(i==3 && channel_3_on) j++;   
                    if(i==4 && channel_4_on) j++;       
                    if(i==5 && channel_5_on) j++;               
                }
                capture_buffer[(_capture_count*nbr_reel_channels*3) +  _capture_count + (3*(nbr_reel_channels-1)) +3] = (uint8_t) (count_trig - count_trig_old);
                count_trig_old = count_trig;
                _capture_count++;
        
                //mise en commentaire 1703 + modif
                pas_temp = _capture_count * nbr_pas_degre;
                diff_pas = count_trig - int16_t(pas_temp);

                if (val != 131172)
                {   
                    trigger_count_buffer -= nb_tempo;

                    if (diff_pas != 0) 
                    {
                        if (diff_pas < (nbr_pas_degre + 0.5f))
                            nb_tempo = (nbr_pas_degre + 0.5f) - diff_pas;
                        else
                            nb_tempo = nbr_pas_degre / 2.0f;
                    }
                    else
                        nb_tempo = nbr_pas_degre + 0.5f;        
                }   
                else
                    trigger_count_buffer -= (nbr_pas_degre + 0.5f);
                    
                memset(somme,0x00,nbr_channels*sizeof(int32_t));
                moy_count = 0;      
            }
        }
    
        if (capture_buffer_to_send[buf] == NULL)
            capture_buffer_to_send[buf] = (uint8_t *) malloc(memory); 
        memcpy(capture_buffer_to_send[buf],capture_buffer,memory);
        buf++;
        if (buf >= TAILLE_BUF_CIRC) 
            buf = 0;
        Mode6Encours = 0;
    }

    cs_ltc2348 = 1;
    if (!acq_modul_off)
        modulation_out = SensTrig;
    Mode6Encours = 0;
    //Mode7 = 0;
        
    return 0;
}

uint32_t LTC234x::swap_endian(uint32_t dword)
{
   return ((dword>>24)&0x000000FF) | ((dword>>8)&0x0000FF00) | ((dword<<8)&0x00FF0000) | ((dword<<24)&0xFF000000);
}
