#include "mbed.h"
 
#ifndef MBED_CHIPSELECTOR_H
#define MBED_CHIPSELECTOR_H

class ChipSelector {
public:

    typedef enum { 
        CS_EEPROM_T1,CS_EEPROM_T2,CS_EEPROM_T3,CS_EEPROM_T4,CS_EEPROM_T5,CS_EEPROM_T6,   //EEPROM    
        CS_DAC_T1,CS_DAC_T2,CS_DAC_T3,CS_DAC_T4,CS_DAC_T5,CS_DAC_T6,
        
        // LOCAL :
        CS_DAC1_LOCAL,CS_DAC2_LOCAL,CS_EEPROM_LOCAL,CS_AD5260_LOCAL,CS_AD5263_LOCAL

    } ChipToSelect ;


    ChipSelector();
    static ChipSelector *get()  {
        return &sSingleton;
    }
 

    int setCS(ChipToSelect chip ,uint8_t value);
    int unselectAll();
    
 
private:
   
    static ChipSelector sSingleton;

    // methods
   ChipSelector& operator=(const ChipSelector&);
   ChipSelector(const ChipSelector&);
};
 
#endif


