#include "ChipSelector.h"
#include "mbed.h"
#include "Global.h"
 
// 74hc4051 management
DigitalOut cs_Eeprom(PTB19);    // Correspond au CS de l'EEPROM carte fille
DigitalOut cs_dac(PTC8);  

DigitalOut in0_sw(PTC5);    //choix de la carte de test 
DigitalOut in1_sw(PTC16);   //choix de la carte de test 
DigitalOut in2_sw(PTC17);   //choix de la carte de test 
// END 74hc4051 management

// Direct CS to chipset
DigitalOut cs_dac1(PTC1);
DigitalOut cs_dac2(PTC0);

DigitalOut cs_eeprom_local(PTC4);   // EEPROM CM
DigitalOut cs_ad5260_local(PTC11); // CS_50K_INTERFACE2_RASP AD5260 CM
DigitalOut cs_ad5263_local(PTC2);  // AD5263 CM

//DigitalOut cs_clk(PTD1); // TEST CLK

static char trace[100];
ChipSelector   ChipSelector::sSingleton;

ChipSelector::ChipSelector(){
    unselectAll();
}
 
int ChipSelector::setCS(ChipToSelect chip, uint8_t value) 
{
    cs_Eeprom = 1;      
    cs_dac = 1;         
    cs_dac1 = 1;    
    cs_dac2 = 1;     
    cs_eeprom_local = 1;     
    cs_ad5260_local = 1;     
    cs_ad5263_local = 1;
    switch (chip)
    {
        //      Local DAC 1/2 , eeprom, ad526x
        case CS_DAC1_LOCAL:
            cs_dac1 = value;    
            //if (ENABLE_TRACE) {sprintf(trace,"CS_DAC1_LOCAL = %d\r\n",value); DiplayTrace(trace);}  
        break;
        case CS_DAC2_LOCAL:
            cs_dac2 = value;    
            //if (ENABLE_TRACE) {sprintf(trace,"CS_DAC2_LOCAL = %d\r\n",value); DiplayTrace(trace);}
        break;
        case CS_EEPROM_LOCAL:
            cs_eeprom_local = value;    
            //if (ENABLE_TRACE) {sprintf(trace,"CS_EEPROM_LOCAL = %d\r\n",value); DiplayTrace(trace);}   
        break;
        case CS_AD5260_LOCAL:
            cs_ad5260_local = value;        
            //if (ENABLE_TRACE) {sprintf(trace,"CS_AD5260_LOCAL = %d\r\n",value); DiplayTrace(trace);}    
        break;
        case CS_AD5263_LOCAL:
            cs_ad5263_local = value;    
            //if (ENABLE_TRACE) {sprintf(trace,"CS_AD5263_LOCAL = %d\r\n",value); DiplayTrace(trace);}
        break;
        //      T1
         case CS_EEPROM_T1:
         case CS_DAC_T1:
            in0_sw = 0;         in1_sw = 0;     in2_sw = 0; 
            //if (ENABLE_TRACE) {sprintf(trace,"CS_T1 = %d\r\n",chip); DiplayTrace(trace);}
            if (chip == CS_EEPROM_T1)
                cs_Eeprom = value;
            else            
                cs_dac = value;
        break;

        //      T2
        case CS_EEPROM_T2:
        case CS_DAC_T2:
            in0_sw = 1;         in1_sw = 0;     in2_sw = 0;
            //if (ENABLE_TRACE) {sprintf(trace,"CS_T2 = %d\r\n",chip); DiplayTrace(trace);}
            if (chip == CS_EEPROM_T2)
                cs_Eeprom = value;
            else            
                cs_dac = value;
        break;
        
        //      T3
        case CS_EEPROM_T3:
        case CS_DAC_T3:
            //in0_sw = 0;         in1_sw = 1;     in2_sw = 0; 
            in0_sw = 0;     in1_sw = 0;         in2_sw = 1; // pour remaper les connecteur
            //if (ENABLE_TRACE) {sprintf(trace,"CS_T3 = %d\r\n",chip); DiplayTrace(trace);}
            if (chip == CS_EEPROM_T3)
                cs_Eeprom = value;
            else            
                cs_dac = value;
        break;
        
        //      T4
        case CS_EEPROM_T4:
        case CS_DAC_T4:
            //in0_sw = 1;     in1_sw = 1;         in2_sw = 0; 
            in0_sw = 1;     in1_sw = 0;         in2_sw = 1; // pour remaper les connecteur
            //if (ENABLE_TRACE) {sprintf(trace,"CS_T4 = %d\r\n",chip); DiplayTrace(trace);}
            if (chip == CS_EEPROM_T4)
                cs_Eeprom = value;
            else            
                cs_dac = value;
        break;
        
        //      T5
       case CS_EEPROM_T5:
       case CS_DAC_T5:
            //in0_sw = 0;     in1_sw = 0;         in2_sw = 1; 
            in0_sw = 0;         in1_sw = 1;     in2_sw = 0; // pour remaper les connecteur
            //if (ENABLE_TRACE) {sprintf(trace,"CS_T5 = %d\r\n",chip); DiplayTrace(trace);}
            if (chip == CS_EEPROM_T5)
                cs_Eeprom = value;
            else            
                cs_dac = value;
        break;
        //  T6
       case CS_EEPROM_T6:
       case CS_DAC_T6:
            //in0_sw = 1;     in1_sw = 0;         in2_sw = 1; 
            in0_sw = 1;     in1_sw = 1;         in2_sw = 0; // pour remaper les connecteur
            //if (ENABLE_TRACE) {sprintf(trace,"CS_T6 = %d\r\n",chip); DiplayTrace(trace);}
            if (chip == CS_EEPROM_T6)
                cs_Eeprom = value;
            else            
                cs_dac = value;
        break;
    }
    return 0;
}
 
int ChipSelector::unselectAll() 
{
    cs_Eeprom = 1;
    cs_dac = 1; 
    cs_dac1 = 1;
    cs_dac2 = 1;
    cs_eeprom_local = 1;
    cs_ad5260_local = 1;
    cs_ad5263_local = 1;
    return 0;
}


