#ifndef MBED_CAT25160_H
#define MBED_CAT25160_H

/*support SPI serial interface (10 MHz, modes 0,0 & 1,1)*/

// https://github.com/mattairtech/EEPROM_CAT25/tree/master/src


#include "mbed.h"
#include "ChipSelector.h" 

#define EEPROM_CAPACITY_CAT25160    0x800
#define EEPROM_PAGE_SIZE_CAT25160   32

#define MAX_WAIT_COUNT          5

// Maximum write time in milliseconds
#define EEPROM_CAT25_MAX_WRITE_TIME_MS      5
#define EEPROM_CAT25_TIMEOUT_TIME_MS        (EEPROM_CAT25_MAX_WRITE_TIME_MS + 1)

#define EEPROM_CAT25_DUMMY_BYTE         0xFF

// Commands supported by all chips
#define EEPROM_CAT25_COMMAND_READ       0x03
#define EEPROM_CAT25_COMMAND_WRITE      0x02
#define EEPROM_CAT25_COMMAND_RDSR       0x05
#define EEPROM_CAT25_COMMAND_WRSR       0x01
#define EEPROM_CAT25_COMMAND_WREN       0x06
#define EEPROM_CAT25_COMMAND_WRDI       0x04
 

// RDY - Ready (ready when low)
#define EEPROM_CAT25_RDY_Msk            0x01
#define EEPROM_CAT25_RDY_BUSY           0x01

class CAT25160 {
public:
    CAT25160();

    static CAT25160 *get()  {
        return &sSingleton;
    }
    
    
    int init();
    bool isReady(ChipSelector::ChipToSelect cs);
    void enableWrite(ChipSelector::ChipToSelect cs);
    void disableWrite(ChipSelector::ChipToSelect cs);
    uint8_t getStatusRegister(ChipSelector::ChipToSelect cs);

    uint8_t readByte(const uint32_t address,ChipSelector::ChipToSelect cs);
    uint8_t writeByte(const uint32_t address, const uint8_t byte,ChipSelector::ChipToSelect cs);

    uint8_t protectAll(ChipSelector::ChipToSelect cs);
    uint8_t unprotectAll(ChipSelector::ChipToSelect cs);
    
    uint16_t readBlock(const uint32_t address, const uint16_t length, void * buffer,ChipSelector::ChipToSelect cs);
    uint16_t writeBlock(uint32_t address, const uint16_t length, void * buffer,ChipSelector::ChipToSelect cs);
    uint16_t writePage(const uint32_t address, const uint16_t length, void * buffer,ChipSelector::ChipToSelect cs);

    void command(uint8_t command, const uint32_t address,ChipSelector::ChipToSelect cs);

    
    // haut niveau
    int16_t checkAccess(ChipSelector::ChipToSelect cs);
    uint8_t *readConfig(ChipSelector::ChipToSelect cs, uint16_t *crc_out = NULL);
    int8_t writeConfig(uint8_t *buffer, uint16_t buffer_len,ChipSelector::ChipToSelect cs, uint16_t *crc_out);
    int8_t writeConfigCheck(uint8_t *buffer, uint16_t buffer_len,ChipSelector::ChipToSelect cs);

private:
    SPI _spi; 
    bool _initComplete;

    static CAT25160 sSingleton;

    // methods
    CAT25160& operator=(const CAT25160&);
    CAT25160(const CAT25160&);    
    
};



#endif
 