#ifndef MBED_AD5260_H
#define MBED_AD5260_H

#include "mbed.h"
#include "ChipSelector.h"
 
class AD5260 
{
    public:
        AD5260(PinName mosi,PinName miso, PinName scl);
    
        static AD5260 *get()  
        {
            return &sSingleton;
        }
               
        int init();
        void write_data(uint8_t addr, uint8_t data, ChipSelector::ChipToSelect cs);
    
    private:
        SPI _spi; 
        bool _initComplete;
    
        static AD5260 sSingleton;
    
        // methods
        AD5260& operator=(const AD5260&);
        AD5260(const AD5260&);    
};

#endif
 