#include "mbed.h"

#include "ChipSelector.h"
#include "AD5260.h"
#include "Global.h"

static char trace[100];
AD5260 AD5260::sSingleton = AD5260(PTD2, PTD3, PTD1); //SPI connecteur mbed J2-
//AD5260 AD5260::sSingleton = AD5260(PTD6,PTD7,PTD5); // SPI connecteur mbed J6

AD5260::AD5260(PinName mosi,PinName miso, PinName scl)
        : _spi(mosi, miso, scl)// mosi, miso, sclk    
{
    _initComplete = false;
}

int AD5260::init()
{  
    // Chip must be deselected
    ChipSelector::get()->unselectAll();
 
    // Setup the spi for 8 bits data, 
    // 10KHz clock rate
    
    if (!ver_carte)
        _spi.format(8,3);
    else
        _spi.format(16,3);
    
    _spi.frequency(1000000);
  
    _initComplete = true;
  
    return 0;
}

void AD5260::write_data(uint8_t addr, uint8_t data, ChipSelector::ChipToSelect cs)
{
    uint16_t value;

    if (!ver_carte && addr)
        return;
    
    ChipSelector::get()->unselectAll();
  
    ChipSelector::get()->setCS(cs,0);
    //wait_us(10);
    
    if (ENABLE_TRACE) {sprintf(trace,"AD5260: GAIN_=%d value=%d\r\n",addr+5,data); DiplayTrace(trace);}
    
    if (!ver_carte)
    {   
        value = 255 - data ; //on inverse la donnée
    }
    else
        value = (addr << 8) + data ; //A0 D7 D6 D5 D4 D3 D2 D1 D0
    _spi.write(value);
    
    ChipSelector::get()->setCS(cs,1);
}
