#define MULTIPLE_PROBES
#define DATA_PIN        A0


#include "mbed.h"
#include "DS1820.h"
#include "QEI.h"

#define TIME 15000
#define MAX_PROBES      16 
#define ON 0
#define OFF 1
#define letraT 10
#define letraC 11
#define guion 12

enum pantalla{MUESTRA_ACTUAL=0 ,PALABRA_T1, MUESTRA_T1,PALABRA_T2, MUESTRA_T2 ,PALABRA_TC,MUESTRA_TC, MODIFICO_T1 , MODIFICO_T2, MODIFICO_TC};
enum{PULSADOR_OFF,PULSADOR_ESPERA,PULSADOR_ON};
enum{NADA,CALIENTA_TC,CALIENTA_SIEMPRE};

QEI wheel (PTA4, PTA12, NC, 624);//giros del encoder
//Segmentos Displays
DigitalOut PUNTO(PTE31);
DigitalOut segmento_A(PTC0);
DigitalOut segmento_B(PTC3);
DigitalOut segmento_C(PTA17);
DigitalOut segmento_D(PTE31);
DigitalOut segmento_E(PTD6);
DigitalOut segmento_F(PTC4);
DigitalOut segmento_G(PTC5);
DigitalOut Punto (PTA16);
// Habilitaciones displays
DigitalOut hab1(PTC12);
DigitalOut hab2(PTC13);
//Encoder
DigitalIn A (PTA12);
DigitalIn B (PTA4);
//Pulsador Encoder

DigitalIn PULS(PTC7);

DigitalOut CALEFACTORA(LED1);
DigitalOut COOLER(LED3);//azul

Ticker temp_1;
Ticker temp_2;
Ticker temp_3;
Ticker Segundos;

unsigned char giro_horario=0; 
unsigned char giro_antihorario=0;
int valor=91,anterior=0;
unsigned char decena=0;
unsigned char unidad=0;
unsigned char estado_encoder=0;
unsigned char nuevo_t1=0, nuevo_t2=0, nuevo_tc=0;

unsigned char display[13]={
         0b11000000,  //0
         0b11111001,  //1
         0b10100100,  //2
         0b10110000,  //3
         0b10011001,  //4
         0b10010010,  //5
         0b10000010,  //6
         0b11111000,  //7
         0b10000000,  //8
         0b10011000,  //9
         0b10000111,  //t
         0b10100111,  //c
         0b10111111   // -
};

//DECLARO VARIABLES
int tiempo=0,temp_actual=0,modo=0, estado_display=0,estado_puls=0,estado_resistencia=0,tiempo_tc=0;
int temp=0,dec=0,uni=0,click=1,click_largo=1,tiempo_lectura=0,timer=0,aux=0;
float valor_encoder=0;
DS1820* probe[MAX_PROBES];

//DECLARO FUNCIONES 
void uno(void);
void detecto_sentido_de_giro();                 //SENTIDO GIRO DEL ENCODER
void encoder();                                 //FUNCIONAMIENTO ENCODER
void interrumpe();
void muestreo_display(unsigned char numero);   //VALORES EN EL DISPLAY
void funcion_muestradisplay();                 //HABILITACIONES DE LOS DISPLAYS  
void display_t1();                             //MUESTRA "T1" EN DISPLAY
void display_t2();                             //MUESTRA "T2" EN DISPLAY
void display_tc();                             // MUESTRA "TC" EN DISPLAY
void display_guion();                          // MUESTRA "--" EN DISPLAY
void mostrar_display(unsigned char cosa);      // SEPARO EN DECENAS Y UNIDADES LOS DISPLAYS
int leo_temperatura();                         // LEO TEMPERATURA SENSADA 
void inicializo_sensor_temp();
void temperatura_act();                        //OBTENGO VALOR DE LA TEMPERATURA ACTUAL
void m_e_display();                            //MAQUINA DE ESTADOS DEL "MENU" DEL DISPLAY
void leo_pulsador();
void limpio_pulsador(void);
void limpio_encoder(void);
void resta_encoder(void);
void funcionamiento(void);
//char pulsador=OFF;   //Variables que guardarán el estado de los pulsadores


 
int main() {  

        inicializo_sensor_temp();
        click=OFF;
        CALEFACTORA=OFF;
        COOLER=OFF;
        temp_1.attach(&funcion_muestradisplay, 0.01);
        temp_2.attach(&interrumpe, 0.001);
        Segundos.attach(&uno, 1);
    while(1) {
            
            leo_pulsador();
            temperatura_act();
            encoder();
            m_e_display();

    }
    
}

//Funciones 

void detecto_sentido_de_giro(void){
    if(anterior<valor){
        giro_horario=1;
        giro_antihorario=0;
        }
    if(anterior>valor){
        giro_horario=0;
        giro_antihorario=1;
    }
    if(anterior==valor){
        giro_horario=0;
        giro_antihorario=0; 
    }
      
    }
    
void limpio_encoder(void){
    wheel.reset();
}

    
void encoder(void){
        valor=wheel.getPulses();
        detecto_sentido_de_giro();
        anterior=valor;

    if(valor>99)limpio_encoder();
            
}

void uno(void){
  if(tiempo_tc>0)tiempo_tc--;  
}

void interrumpe(){
    if(tiempo>0)tiempo--;  
    if(tiempo_lectura>0)tiempo_lectura--;
}
    
void muestreo_display(unsigned char numero){
    segmento_A=display[numero]&0b00000001;
    segmento_B=(display[numero]&0b00000010)>>1;
    segmento_C=(display[numero]&0b00000100)>>2;
    segmento_D=(display[numero]&0b00001000)>>3;
    segmento_E=(display[numero]&0b00010000)>>4;
    segmento_F=(display[numero]&0b00100000)>>5;
    segmento_G=(display[numero]&0b01000000)>>6;
}

void funcion_muestradisplay(){//10mS


  
  if(hab1==ON){
      hab1=OFF;
      hab2=OFF;
      
      
      muestreo_display(decena);
      hab1=OFF;
      hab2=ON;
  }else{
      hab1=OFF;
      hab2=OFF;
      muestreo_display(unidad);
      hab1=ON;
      hab2=OFF;
  }
}

void display_t1(void){
    decena=letraT;
    unidad=1;
    funcion_muestradisplay();
    }
    
void display_t2(void){
    decena=letraT;
    unidad=2;
    funcion_muestradisplay();
    }

void display_tc(void){
    decena=letraT;
    unidad=letraC;
    funcion_muestradisplay();
    }
void display_guion(void){
    decena=guion;
    unidad=guion;
    funcion_muestradisplay();
    }

void mostrar_display(unsigned char temp_3){
        decena=temp_3/10;
        unidad=temp_3%10;
}



int leo_temperatura(void){
            int grados=0;
            probe[0]->convertTemperature(false, DS1820::all_devices);         //Start temperature conversion, wait until ready
            grados=probe[0]->temperature();
 return grados;
}


void inicializo_sensor_temp(void){
     // Initialize the probe array to DS1820 objects
    int num_devices = 0;
    while(DS1820::unassignedProbe(DATA_PIN)) {
        probe[num_devices] = new DS1820(DATA_PIN);
        num_devices++;
        if (num_devices == MAX_PROBES)
            break;
    }
    
}

void temperatura_act(void){
                if(tiempo==0){
                
                tiempo=50;
                temp=leo_temperatura();
                if(temp>0&&temp<99){//solo valores que se pueden mostrar por el display (0-99)
                       dec=(temp/10);
                       uni=(temp%10);
                }
            }
            temp_actual=dec*10+uni;    
}
void m_e_display(void){
    
    switch(estado_display){
        case MUESTRA_ACTUAL: 
                temperatura_act();//Sensa la temperatura y la vuelca en la variable temp actual
            if(aux==0){
                mostrar_display(temp_actual);//Muestra temperatura actual hasta que se presina el pulsador y va al menu
                if(click==ON) { 
                limpio_pulsador();
                     
                    estado_display=PALABRA_T1; //Se presiona el pulsador, entonces se accede al menu
                }
            }
            funcionamiento();
        break;
        case PALABRA_T1:
                estado_display=MUESTRA_T1; //Se presiona el pulsador, entonces se accede al menu
                display_t1();//muestra t1
                //limpio_encoder();
                
        break;
        case MUESTRA_T1: //Comienza el menu mostrando opcion para configurar T1 (temperatura inferior)
            if(click==ON){ 
            limpio_pulsador();
                 
                valor = nuevo_t1;
                estado_display=MODIFICO_T1; //Al presionar por segunda vez, se puede modificar el valor de T1 con el encoder
            }
            if(giro_horario==1) {
                estado_display=PALABRA_T2;// Si se gira en sentido horario se accede a la configuracion de T2
                //display_t2();//muestra t2
            }
            if(giro_antihorario==1){
                 estado_display=PALABRA_TC;//Si se gira en sentido antihorario se mostrará la temperatura actual
            }
        break;
        case PALABRA_T2:
                estado_display=MUESTRA_T2;// Si se gira en sentido horario se accede a la configuracion de T2
                display_t2();//muestra t2
        break;
        case MUESTRA_T2: 
            if(click==ON) { 
            limpio_pulsador();
                 
                estado_display=MODIFICO_T2;//Al presionar por segunda vez, se puede modificar el valor de T2 con el encoder
            }
            if(giro_horario==1) estado_display=PALABRA_TC; // Si se gira en sentido horario se accede a la configuracion de TC
            if(giro_antihorario==1) estado_display=PALABRA_T1;// Si se gira en sentido antihorario se accede a la configuracion de T1
        break;
        
        case PALABRA_TC:
             estado_display=MUESTRA_TC;
             display_tc();
        break;
        case MUESTRA_TC: 
             if(click==ON) { 
             limpio_pulsador();
                 
                estado_display=MODIFICO_TC; //Al presionar por segunda vez, se puede modificar el valor de TC con el encoder
                }
            if(giro_horario==1) estado_display=PALABRA_T1;// Si se gira en sentido horario se muestra en el display la temperatura actual
            if(giro_antihorario==1) estado_display=PALABRA_T2;// Si se gira en sentido antihorario se accede a la configuracion de T2
        break;
        case MODIFICO_T1:
                mostrar_display(valor);//muestra 
                if(click==ON){
                     nuevo_t1=valor;
                     limpio_pulsador();
                     estado_display=PALABRA_T2; //Configuro T1 y muestro T2
                     limpio_encoder();//valor se va a cero
                }
        break;
        case MODIFICO_T2:   
                mostrar_display(valor);//muestra 
                if(click==ON) {
                      nuevo_t2=valor;
                      limpio_pulsador();
                     
                    estado_display=PALABRA_TC; //Configuro T2 y muestro TC
                    limpio_encoder();//valor se va a cero
                    }
        break;
        case MODIFICO_TC:   
        nuevo_tc=valor;
        mostrar_display(nuevo_tc);//muestra tc 
        if(click==ON) { 
        limpio_pulsador();
             
            estado_display=MUESTRA_ACTUAL; //Configuro TC y muestro Temp actual
            limpio_encoder();//valor se va a cero
        }
        break;      
     }
    
 }
 
 //funcion para sacar el rebote del pulsador
void leo_pulsador(){
            if(tiempo_lectura==0){
            tiempo_lectura=5;
            switch(estado_puls){
                case PULSADOR_OFF:
                    if(PULS==0){
                        estado_puls=PULSADOR_ESPERA;
                    }
                break;    
                case PULSADOR_ESPERA:
                    if(PULS==0){
                        estado_puls=PULSADOR_ON;
                    }
                break;
                case PULSADOR_ON:
                    if(PULS==0){
                            timer++;    
                    }
                    else{
                        if(timer<400){//si el tiempo es menor 
                            click=ON;
                        }else{
                            click_largo=ON;
                        }
                        estado_puls=PULSADOR_OFF;
                        timer=0;
                    }
                break;
                
            }
        }
}
//funcion para apagar el pulsador
void limpio_pulsador(){ 
    click=OFF;  
    click_largo=OFF;  
}

void funcionamiento(){
    
    switch (estado_resistencia){
        case NADA:
            CALEFACTORA=OFF;
            COOLER=OFF;
                if(click_largo==ON){
                    limpio_pulsador();
                    aux=1;
                    if(temp_actual<nuevo_t1){
                        CALEFACTORA=ON;
                        COOLER=OFF;
                    }
                         
                    if(temp_actual>nuevo_t2){
                        COOLER=ON;
                        CALEFACTORA=OFF;
                        }else{
                               COOLER=OFF;
                            }
                    if(nuevo_tc>0){
                        estado_resistencia=CALIENTA_TC;
                        tiempo_tc=nuevo_tc;
                    }
                    else{
                        estado_resistencia=CALIENTA_SIEMPRE;
                        display_guion();
                    }    
                }
        break; 
        case CALIENTA_TC:
        
                            if(temp_actual<nuevo_t1){
                        CALEFACTORA=ON;
                        COOLER=OFF;
                    }
                         
                    if(temp_actual>nuevo_t2){
                        COOLER=ON;
                        CALEFACTORA=OFF;
                        }else{
                               COOLER=OFF;
                            }
            if(tiempo_tc==0){
                CALEFACTORA=OFF;
                estado_resistencia=NADA;
                aux=0;
            }else{
                mostrar_display(tiempo_tc);//muestra 
            }
        break;
        
        case CALIENTA_SIEMPRE:
                            if(temp_actual<nuevo_t1){
                        CALEFACTORA=ON;
                        COOLER=OFF;
                    }
                         
                    if(temp_actual>nuevo_t2){
                        COOLER=ON;
                        CALEFACTORA=OFF;
                        }else{
                               COOLER=OFF;
                            }
            if(click_largo==ON){
             limpio_pulsador();
             estado_resistencia=NADA;
             aux=0;
             }
            
        break;
           
    }
    
}

