#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"
#include "MODSERIAL.h"
#include "base64.h"

#define SEND_BUF_SIZE 4096

DigitalOut R(LED_RED);
DigitalOut G(LED_GREEN);
DigitalOut B(LED_BLUE);

MODSERIAL serial(USBTX, USBRX,4096); // tx, rx
EthernetInterface eth;
HTTPClient http;

SPISlave device(D11, D12, D13, D10);

char str2[32000];

char * token;

int length_countdown = 4;

char length_bytes[4];
int length = 0;
int i = 0;

bool onRead(char ch)
{   
    if (ch == 0x11) NVIC_SystemReset(); // Reset
    
    // If length didn't get read yet...
    if (length_countdown > 0){
        length_countdown--;
        length_bytes[3-length_countdown] = ch;
        
        // if last lengthbyte got read...
        if (length_countdown == 0){
                
            //Set length and malloc the token.
            length = length_bytes[0] + (length_bytes[1] << 8) + (length_bytes[2] << 16) + (length_bytes[3] << 24);
            i = length;
            token = (char*) malloc(sizeof(char)*length+1);
        }
        return false;
    }
    
    //Read token
    memset(token+(length-i),ch,1);
    i--;
    
    //If token got read...
    if (i == 0 and length_countdown == 0){
        //Set 0x00 byte to the end and return true.
        memset(token+length,0x00,1);
        length_countdown = 4;
        return true;
    }
    return false;
}

void encodeToken(){
    size_t len;
    char * ptr = strtok(token,"|");
        
    char * t1 = base64_encode((const unsigned char*)ptr,strlen(ptr),&len);
    ptr = strtok(NULL,"|");
    char * t2 = base64_encode((const unsigned char*)ptr,strlen(ptr),&len);
    ptr = strtok(NULL,"|");
        
    free(token);
    token = (char *) malloc(strlen(t1)+strlen(t2)+strlen(ptr)+3);
    sprintf(token,"%s.%s.%s",t1,t2,ptr);
        
    free(t1);
    free(t2);
    free(ptr);
    base64_cleanup();
}

int main() {
    setbuf(stdout, NULL);
    eth.init();
    eth.connect();
    R=!R;G=!G;B=!B;
    wait(1);

    serial.printf("Start");

    //Init SPI
    device.format(8,3);
    device.frequency(2000000);
    
    
    
    while(1){

        // Recieve Token
        while(1){
         if(device.receive()) {
                 if (onRead(device.read())) break;
             }
        }
        
        //serial.printf("%s\r\n\r\n",token);
        
        // Encode the first two parts of the message to get the valid token
        encodeToken();
        
        // Light Blue
        B=!B;
        
        // Token Read, light Yellow
        R=!R;G=!G;B=!B;
            
        // Send token to Server
        HTTPMap map;
        HTTPText inText(str2, 32000);
        map.put("client_id", "a1b2c3");
        map.put("client_secret", "drickyoughurt");
        map.put("token_type_hint", "pop_token");
        map.put("token", token);
            
        int ret = http.post("https://kongsugar.de/introspection", map, &inText);
        
        free(token);
        
        if (!ret)
        {
            // Unlock, Light Green 5s
            R=!R;wait(5);G=!G;
        }
        else
        {
            // Light Red 5s
            G=!G;wait(5);R=!R;
        }
            
        // Bugfix, nervous user send token multiple times!
        memset(&str2[0], 0, sizeof(str2));
        serial.rxBufferFlush();
    }
}
