#include "mbed.h"
#include "ble/BLE.h"
#include "ble/UUID.h"
#include "ble/GattAttribute.h"
#include "ble/GattService.h"

DigitalOut alivenessLED(LED1, 0);
DigitalOut alivenessLED2(LED2, 1);
DigitalOut alivenessLED3(LED3, 1);

Ticker ticker;

const static char     DEVICE_NAME[]        = "KeyOpener3k";
static const char * uuid16_list[] = {"9085495d-f273-443d-9e37-e27c9194f63b"};

Serial pc(USBTX, USBRX);

void periodicCallback(void)
{
    alivenessLED = !alivenessLED; /* Do blinky on LED1 to indicate system aliveness. */
}

UUID uuid = UUID("9085495d-f273-443d-9e37-e27c9194f63b");
UUID uuid_message = UUID("8085495d-f273-443d-9e37-e27c9194f63b");
UUID uuid_writebyte = UUID("7085495d-f273-443d-9e37-e27c9194f63b");

char data[20];
char numbermessages;

char * message;
char * cpy = (char*) malloc(21);

bool recieving = false;

void onDataWrittenCallback(const GattWriteCallbackParams* params) {
    alivenessLED3 = !alivenessLED3;
    if (!recieving){
        pc.printf("Allocated: %d bytes\r\n", sizeof(char)*20*2*(*params->data));
        message = (char*) malloc(sizeof(char)*20*2*(*params->data));
        recieving = true;
        return;
    }
    
    if (*params->data == 0x00){
        pc.printf("%s\r\n",message);
        free(message);
        recieving = false;
    } else {
        memcpy(cpy, params->data, 20);
        cpy[20] = '\0'; 
        strcat(message,cpy);
    }
}



void connectionCallback(const Gap::ConnectionCallbackParams_t *params){
    alivenessLED2 = !alivenessLED2;
    pc.printf("Connected!\r\n");  
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    BLE::Instance(BLE::DEFAULT_INSTANCE).gap().startAdvertising(); // restart advertising
}

void initService(BLE &ble){
    ReadWriteArrayGattCharacteristic<char, 20> messagecharacter = ReadWriteArrayGattCharacteristic<char, 20>(uuid_message,data);
    ReadWriteArrayGattCharacteristic<char, 1> writebytecharacter = ReadWriteArrayGattCharacteristic<char, 1>(uuid_writebyte,&numbermessages);
    
    GattCharacteristic * chars[] = {&messagecharacter,&writebytecharacter};
    GattService service = GattService(uuid,chars,2);
    ble.gattServer().addService(service);
}

void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE &ble          = params->ble;
    ble_error_t error = params->error;
 
    if (error != BLE_ERROR_NONE) {
        return;
    }
 
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().onConnection(connectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);
    
    initService(ble);
    
    /* Setup advertising. */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(1000); /* 1000ms */
    ble.gap().startAdvertising();
}

int main(void)
{   
    BLE& ble = BLE::Instance(BLE::DEFAULT_INSTANCE);
    ble.init(bleInitComplete);
    
    while (ble.hasInitialized()  == false) { /* spin loop */ }
    
    ticker.attach(periodicCallback, 0.5); /* Blink LED every second */
    
        pc.printf("init\r\n");
    
    while (true) {
        ble.waitForEvent();
    }
}