#include "mbed.h"
#include "HIDScope.h"

PwmOut pwmpin1(D6);
PwmOut pwmpin2(D5);
AnalogIn potmeter1(A5);
AnalogIn potmeter2(A4);
DigitalOut directionpin1(D4);
DigitalOut directionpin2(D7);
DigitalIn button1(SW3);
DigitalIn button2(SW2);

HIDScope scope(2);

int main()
{
    pwmpin1.period_us(60);
    pwmpin2.period_us(60);
    directionpin1 = true;
    directionpin2 = true; 
    
    while (true) {
        if(!button1){
            directionpin1 = !directionpin1;
            wait(0.7f);
            } 
        if(!button2){
            directionpin2 = !directionpin2;
            wait(0.7f);
            }
            
        pwmpin1 = potmeter1;
        pwmpin2 = potmeter2; 
        
        scope.set(0, pwmpin1);
        scope.set(1, pwmpin2);
        scope.send();
        wait(0.2f);
    }
}

