#include "mbed.h"
#include "MODSERIAL.h"
#include "HIDScope.h"

//create objects from K64f board
PwmOut pwmpin(D6);
PwmOut led(D10);
AnalogIn potmeter(A5);
DigitalIn button(D2);
DigitalOut directionpin(D7);
MODSERIAL pc(USBTX, USBRX);

//create other objects
HIDScope scope(2); //set two lines to be send to HIDScope
Ticker ticker;
enum states{forward, stop, backwards}; //create possible different states
states CurrentState;

//create variables
volatile float x;
volatile float y;
volatile float scaled_potmeter;
volatile float c;

void sendData() {
    scope.set(0,potmeter); //set the potmeter data to the first scope
    scope.set(1,x); //placeholder for second potmeter/motor
    scope.send(); //send the datapoints of the 2 motors
}

void Proces_states(void){ //execute the behaviour belonging to the different states
    switch (CurrentState){       
        case forward:
            directionpin = 1;
            pwmpin.write(scaled_potmeter); //pwm of motor is scaled potmeter value
            led.write(scaled_potmeter); //led is scaled potmeter value  
            break;
        case stop:
            // do nothing
            break;
        case backwards:
            directionpin = 0;
            c = scaled_potmeter*-1;
            pwmpin.write(c); //pwm of motor is negative of scaled potmeter value
            led.write(c); //led is negative of scaled potmeter value 
            break; 
    }            
}

int main() {
    x = 1; //placeholder value for potmeter of second motor
    
    pwmpin.period_us(60); //60 microseconds PWM period, 16.7 kHz
    led.period_us(60); //60 microseconds
    ticker.attach(&sendData, 0.005f); //send data to hidscope at 200Hz

    while (true) {  
        scaled_potmeter = (potmeter*2)-1; //scale potmeter from 0-1 to (-1 to 1)

        if (scaled_potmeter > 0) { //if the potmeter is past the half-way point
            CurrentState = forward; //set the state
            pc.printf("state = forward\r\n");
            Proces_states(); //execute the state
        }
        if (scaled_potmeter == 0) { //if the potmeter is at the half-way point
            CurrentState = stop; //set the state
            pc.printf("state = stop\r\n");
            Proces_states(); //execute the state
        }
        if (scaled_potmeter < 0) { //if the potmeter is before its half-way point
            CurrentState = backwards; //set the state
            pc.printf("state = backwards\r\n");
            Proces_states(); //execute the state
        }   
        wait(0.2f); //wait, so that the loop will repeat every 0.2 seconds (+interrupt times)
    }
}


