#include "mbed.h"
#include "HIDScope.h"

//Define objects
AnalogIn    emg0( A0 );
AnalogIn    emg1( A1 );

Ticker      sample_timer;
HIDScope    scope( 4 );
DigitalOut  led(LED1);

/** Sample function
 * this function samples the emg and sends it to HIDScope
 **/
void sample()
{
    /* Set the sampled emg values in channel 0 (the first channel) and 1 (the second channel) in the 'HIDScope' instance named 'scope' */
    scope.set(0, emg0.read() );
    scope.set(1, emg1.read() );

    scope.send();
    /* To indicate that the function is working, the LED is toggled */
    led = !led;
}

int main()
{   
    /**Attach the 'sample' function to the timer 'sample_timer'.
    * this ensures that 'sample' is executed every... 0.002 seconds = 500 Hz
    */
    sample_timer.attach(&sample, 0.002);

    /*empty loop, sample() is executed periodically*/
    while(1) {}
}