#include "mbed.h"
#include "math.h"
#include "MODSERIAL.h"
#include "HIDScope.h"
#include "QEI.h"
#define PI 3.141592f //65358979323846  // pi 

PwmOut pwmpin1(D6);
PwmOut pwmpin2(D5);
DigitalOut directionpin2(D4);
DigitalOut directionpin1(D7);
QEI motor2(D13,D12,NC, 32);
QEI motor1(D11,D10,NC, 32);
DigitalOut ledred(LED_RED);

DigitalIn KillSwitch(SW2);
DigitalIn button(SW3);
MODSERIAL pc(USBTX, USBRX);
HIDScope scope(6);

//values of inverse kinematics
volatile bool emg0Bool = false;
volatile bool emg1Bool = false;
volatile bool emg2Bool = false;
volatile bool x_direction = true;
volatile bool a;

const float C1 = 3.0; //motor 1 gear ratio
const float C2 = 0.013; //motor 2 gear ratio/radius of the circular gear in m
const float length = 0.300; //length in m (placeholder)
const float Timestep = 0.1;

volatile float x_position = length;
volatile float y_position = 0.0;
volatile float old_y_position;
volatile float old_x_position;
volatile float old_motor1_angle;
volatile float old_motor2_angle;
volatile float motor1_angle = 0.0; //sawtooth gear motor
volatile float motor2_angle = 0.0; //rotational gear motor
volatile float direction;
volatile char c;

//values of PID controller
const float Kp = 1;
const float Ki = 0.0001;
const float Kd = 0;
float Output1 = 0 ;      //Starting value
float Output2 = 0 ;      //Starting value
float P1 = 0;           //encoder value
float P2 = 0;
float e1 = 0 ;          //Starting value 
float e2 = 0 ;          //Starting value
float e3 = 0;  
float f1 = 0 ;          //Starting value 
float f2 = 0 ;          //Starting value
float f3 = 0;     
float Output_Last1 = 0;      // Remember previous position
float Output_Last2 = 0;      // Remember previous position
float Y1;               // Value that is outputted to motor control
float Y2;               // Value that is outputted to motor control
float pwm1;
float pwm2;
float P_Last = 0;       // Starting position

void PIDController1() { 
  
    P1 = motor1.getPulses() / 8400 * 2*PI;    //actual motor angle in rad  
    e1 = e2;
    e2 = e3;
    e3 = motor1_angle - P1;
    float de3 = (e3-e2)/Timestep;
    float ie3 = ie3 + e3*Timestep;
    Output2 = Kp * e3 + Ki * ie3 + Kd * de3;
    
//    Output_Last1 = Output1;
//    Output1 = Kp * (e3 - e2) + Output_Last1 +Ki * e3 + Kd * (e3 - 2*e2 + e1);
    Y1 = 0.5f * Output1;
    
    if (Y1 >= 1){
        Y1 = 1;
    }
    else if (Y1 <= -1){
        Y1 = -1;
    }    
}

void PIDController2() {   
    P2 = motor2.getPulses() / 8400.0f * 2.0f*PI; // actual motor angle in rad
    f2 = f3;
    f3 = motor2_angle - P2;
    float df3 = (f3-f2)/Timestep;
    float if3 = if3 + f3*Timestep;
    Output2 = Kp * f3 + Ki * if3 + Kd * df3;
  //  Output_Last2 = Output2;
  //  Output2 = Kp * (f3 - f2) + Output_Last2 +Ki * f3 + Kd * (f3 - 2*f2 + f1);
    Y2 = 0.5f * Output2;
     
    if (Y2 >= 1){
        Y2 = 1;
    }
    else if (Y2 <= -1){
        Y2 = -1;
    }   
}

void ControlMotor1() {
    if (Y1 > 0) {
        Y1 = 0.6f * Y1 + 0.4f;
        directionpin1 = true;
    } 
    else if(Y1 < 0){
        Y1 = 0.6f - 0.4f * Y1;
        directionpin1 = false;
    }    
    pwmpin2 = abs(Y1);
}

void ControlMotor2() {
    if (Y2 > 0) {
        Y2 = 0.5f * Y2 + 0.5f;
        directionpin2 = true;
    } 
    else if(Y2 < 0){
        Y2 = 0.5f - 0.5f * Y2;
        directionpin2 = false;
    }
    pwmpin1 = abs(Y2);
}

int main() {
    pc.baud(115200);
    pc.printf(" ** program reset **\n\r");
    ledred = true;
    
    while (true) {
        
        //testing the code from keyboard imputs: a-d: left to right, w: forward/backwards
        a = pc.readable();
        if (a) {
            c = pc.getc();
            switch (c){
                case 'a': //move to the left
                    emg0Bool = true; 
                    break;           
            }
        }
        if (emg0Bool == true){
            motor1_angle = 1/6*3.14; //45 graden
            PIDController1();
            PIDController2();
            ControlMotor1();
            ControlMotor2();
            }
        
        if (!KillSwitch) { //even in mekaar gebeund voor het hebben van een stop knop
            ledred = false;
            pwmpin1 = 0;
            pwmpin2 = 0;
            //for fun blink sos maybe???
            wait(2.0f);
            bool u = true;

            while(u) {
                if (!KillSwitch) {
                    u = false;
                    ledred = true;
                    wait(1.0f);
                }
            }
        }
        wait(Timestep); //can also be done with ticker, to be sure that it happens exactly every 0.5 seconds
    }
}