#include "mbed.h"
#include "MODSERIAL.h"
#include "encoder.h" //getPosition(), setPosition(), getSpeed()

PwmOut pwmpin(D6);
PwmOut led(D10);
DigitalIn button(D2);
DigitalOut directionpin(D7);
Encoder motor1(D13,D12);
MODSERIAL pc(USBTX, USBRX);

int main()
{   
    int counts; //number of counts, 
    const int max_counts = 8400; //maximum number of counts from the X4 encoding
    int motor_angle;
    pc.printf("** reset **\r\n");
    directionpin = 1; //turn forward
    led = 1; //turn led on

/* this could be placed in the while loop
    //"lompe" functions to let the counter count from 0-8400 and from -8400 to 0, could possibly be done better
    if (counts > max_counts) {counts = 0;}
    else if (counts < 0) {counts = max_counts;}
    else if (counts < -1*max_counts) {counts = 0;}
    
    //converting the counts to degrees
    degrees_per_count = 360/max_counts;   
    motor_angle = counts*degrees_per_counts;
*/
    
    while (true) {
        //if the button is pressed, turn of the led and turn the motor
        if (button == false){
            pwmpin = 0.6;
            led = 0; 
        }
        //if the button is not pressed, keep the led on and the motor off
        else {
            pwmpin = 0;
            led = 1;
        }
        counts = motor1.getPosition(); //get the number of counts from the encoder. Will keep counting up/down if not reset or stopped
        pc.printf("%i\r\n", counts); 
        wait(0.1f);     
    }
}