/***********************************
name:   date.cpp    Version: 0.5
author: PE HTL BULME
email:  pe@bulme.at
description:
    Real Time Clock (RTC8563) on HIMBED M0 - LPC11U24 
    class Date inherited from class RTC8563
    Example methode GetDay implemented 
ToDo: 
    implement GetYear, GetMonth;
    Constructor to initialize Date on RTC
    Alarm methode
***********************************/

#include "mbed.h"
#include "Date.h"

// https://developer.mbed.org/teams/HIMBED_3AHELI/code/rtc_func/wiki/Klasse-Date-von-RTC8563-ableiten
uint8_t Date::bcdToUint(uint8_t const nybbles)
{
    uint8_t result;
    result = (nybbles>>4)*10 + (nybbles & 0x0F);
    return result;
}

string Date::toString(uint8_t value)
{
    //return std::to_string(value); // ab C++ version 11
    char buffer[2];
    sprintf (buffer, "%d", value);  // ToString()
    return buffer;
}    

uint8_t Date::GetDay()
{
    uint8_t day = rtc_read(DAYS);
    return bcdToUint(day & 0x3F);
}
// ueberladene Methoden von GetDay
uint8_t Date::GetDay(int value)   
{
    return value;
}
string Date::GetDay(string str)
{
    string day = str + " In Date Day: " + toString(GetDay());
    return day;
}