//Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too

//Connect as follows:
//RFID pins        ->  STM32F429
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   SPI_MISO  =PA_6=P42
//RFID MOSI=pin3   ->   SPI_MOSI  =PA_7=P43
//RFID SCK=pin2    ->   SPI_SCK   =PA_5=P41
//RFID SDA=pin1    ->   SPI_SDA  =PA_4=P40
//RFID RST=pin7    ->            =NRST=P25
//3.3V and Gnd to the respective pins                              
                              
#include "mbed.h"
#include "MFRC522.h"
#include "LCD_DISCO_F429ZI.h"

LCD_DISCO_F429ZI lcd;

// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
//#define MF_RESET    p25


DigitalOut led_green(LED1);

//Serial connection to PC for output
//Serial pc(SERIAL_TX, SERIAL_RX);//???

//MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, PA_0);

int main(void) {
      
    lcd.Clear(LCD_COLOR_WHITE);
    lcd.SetTextColor(LCD_COLOR_BLACK);  
    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"starting...", CENTER_MODE);

      
    Init. RC522 Chip
    RfChip.PCD_Init();

    while (true) {
        led_green = 1;//ok
    
        // Look for new cards
        if ( !RfChip.PICC_IsNewCardPresent()){
            wait_ms(500);
            continue;
        }

        // Select one of the cards
        if ( ! RfChip.PICC_ReadCardSerial()){
            wait_ms(500);
            continue;
        }

        led_green = 0;//ok

        // Print Card UID
        pc.printf("Card UID: ");
        for (uint8_t i = 0; i < RfChip.uid.size; i++){
            pc.printf(" %X02", RfChip.uid.uidByte[i]);
        }
        //pc.printf("\n\r");
        //lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"\n\r", CENTER_MODE);

    // Print Card type
    uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
    pc.printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
    wait_ms(1000);
  }
}