/* Copyright (c) 2012 Carlos Gomez, Hector Vargas, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
 * and associated documentation files (the "Software"), to deal in the Software without restriction, 
 * including without limitation the rights to use, copy, modify, merge, publish, distribute, 
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or 
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING 
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND 
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, 
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
//////////////////////////////////////////////////////
/*
Esta libreria fue adaptada por Carlos Gomez y Hector 
Vargas para uso enel proyecto de fin de carrera en 
Ingenieria Electronica
en la Universidad de los Llanos - Villavicencio - Colombia
*/
////////////////////////////////////////////////////// 
///    lcd1100.c 
/// 
///    Badr Ghatasheh (demonspells) 
///    11/3/2011 
////////////////////// 
#ifndef LCD1100_H
#define LCD1100_H
#include "mbed.h" 

#define CMD    0 
#define DATA   1 
class lcd1100 {
public:
    lcd1100(PinName _sclk,PinName _sda,PinName _cs,PinName _rst);                                      
    //Inicializa la LCD
    void Lcd_Init(void);
    //Limpia la LCD
    void Lcd_Clear(void);
    void SetX(char x);
    void SetY(char y);
    //sed the position of cursor X(0 to 96) and Y(0 to 7)each position in "Y" is 8*y pixels
    //pone el cursor en la posicion X,Y*8 
    //los valores aceptables para Y son de 0 a 96 y para Y de 0 a 9
    void Gotoxy(char x,char y); 
    //dibuja una linea vertical
    void VLine(char x,char y,char on);
    //dibuja una linea Horizontal
    void Line(unsigned char x,unsigned char y,unsigned char y2,unsigned char on); 
    //imprime un caracter
    void print_char(char c);
    //imprime un String
    void printf_lcd(char *s);
    //imprime una imagen
    void cargar_imagen(char *dir); 
    char bitaddr;
private:
    DigitalOut  sclk;
    DigitalOut  sda;
    DigitalOut  cs;
    DigitalOut  rst;
    // lookup table, here you can modify the font 
    static const char FontLookup1[48][5];
    static const char FontLookup2[48][5];
    //envia datos los datos a la LCD1100
    void Lcd_Write(bool cd,unsigned char c);
};

#endif