#include "mbed.h" 
#include "LIFTING_WAVELET.h"


const float    sqrt3 = 1.73205; 
const float    sqrt2 = 1.41421; 

void dividir(float *S, int N );
void transformada(float *S, int N);
void niveles(float *S, int N );
float tsigma(float *S, int N );
void nonzero(float *S, float u, int N) ;


void dividir( float *S, int N ){
    int inicio = 1;
    int fin = N - 1;
    while (inicio < fin) {
        for (int i = inicio; i < fin; i = i + 2) {
            float tmp = S[i];
            S[i] = S[i+1];
            S[i+1] = tmp;
        }
        inicio = inicio + 1;
        fin = fin - 1;
    }
}
///////////////////////////// CDF Transforamda ///////////////////  
void transformada( float *S, int N ){
    int mitad = N/2;

    S[N-1] = S[N-1] - floor(0.5*(S[0] + S[mitad-1]) + 0.5);
    for (int n = 0; n < mitad-1; n++)
        S[n+mitad] = S[n+mitad] - floor(0.5*(S[n] + S[n+1]) + 0.5);

    S[0] = S[0] + floor(0.25*(S[mitad] + S[N-1]) + 0.5);
    for (int n = 1; n < mitad; n++)
        S[n] = S[n] + floor(0.25*(S[n+mitad] + S[n+mitad-1]) + 0.5);
}
///////////////////////////// daub Transforamda ///////////////////  
void forwardStepDaub( float *S, int N )
  {
    int half = N/2;

    // update 1
    for (int n = 0; n < half; n++)
      S[n] = S[n] + sqrt3 * S[half+n];

    // predict
    S[half] = S[half] - (sqrt3/4.0)*S[0] - (((sqrt3-2)/4.0)*S[half-1]);
    for (int n = 1; n < half; n++)
      S[half+n] = S[half+n] - (sqrt3/4.0)*S[n] - (((sqrt3-2)/4.0)*S[n-1]);

    // update 2
    for (int n = 0; n < half-1; n++)
      S[n] = S[n] - S[half+n+1];
    S[half-1] = S[half-1] - S[half];

    // normalize
    for (int n = 0; n < half; n++) {
      S[n] = ((sqrt3-1.0)/sqrt2) * S[n];
      S[n+half] = ((sqrt3+1.0)/sqrt2) * S[n+half];
    }

  } // forwardStep
///////////////////////////// Niveles///////////////////  
void niveles( float *S, int N ){
    for (int n = N; n > 1; n = n >> 1) {
        dividir(S, n);
        transformada(S, n);
    }
}

///////////////////////////// UMBRALIZACION ///////////////////
float tsigma(float S[], int N) {
    float sum = 0.0;
    for (int n = 32; n > 32-N; n--) {
        sum = sum + fabs(S[n]);
    } 
    return ((sum/N)*1.4825)*sqrt(2*log((float)N)); 
}
float tsigma2(float S[], int N) {
    float sum = 0.0;
    for (int n = N; n < (N<<1); n++) {
        sum = sum + fabs(S[n]);
    } 
    return ((sum/N)*1.4825)*sqrt(2*log((float)N)); 
}

void nonzero(float *S, float u, int N) {
    for (int n = 32 ;n > 32-N; n--) {           
        if(fabs(S[n])<=u)
            S[n] = 0;
    } 
}
