#include "mbed.h"
#include "rtos.h"

DigitalOut myled(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);

volatile int count_timer = 0;
volatile int state_timer = 0;
volatile int count_button = 0;

RtosTimer * timer;

void increment() {
   count_button ++;
        
    if(state_timer==0)
    {
        myled = 1 - myled;
        timer->start(1000);
    }
    else{
        timer->stop();
        myled = 1 - myled;
    }
    state_timer = 1 - state_timer;
}
 

 
InterruptIn interrupt(PC_9);



void timeout(void const * arg){
    count_timer += 1;
    //myled = 1 - myled;
    }



int main() {

  myled = 1;
  timer = new RtosTimer(timeout, osTimerPeriodic, (void *) 0);
  interrupt.rise(&increment);
  interrupt.mode(PullUp);
  //timer->start(1000);
  
  while(1){
    Thread::wait(2100);
    if (count_button==10) timer->start(1000);
    if (count_button==20) timer->stop();
    //pc.printf("bucle princ %i\r\n", counter.read());
    pc.printf("count_timer: %i count_button %i\r\n", count_timer, count_button);
    //myled = 1 - myled;
  }
}


/* CONSOLE
count_timer: 0 count_button 0                                                   
count_timer: 0 count_button 0                                                   
count_timer: 0 count_button 0                                                   
count_timer: 0 count_button 0                                                   
count_timer: 0 count_button 1                                                   
count_timer: 0 count_button 1                                                   
count_timer: 0 count_button 2                                                   
count_timer: 0 count_button 4                                                   
count_timer: 0 count_button 5                                                   
count_timer: 0 count_button 6                                                   
count_timer: 0 count_button 7                                                   
count_timer: 0 count_button 8                                                   
count_timer: 0 count_button 9                                                   
count_timer: 0 count_button 10                                                  
count_timer: 2 count_button 10                                                  
count_timer: 4 count_button 10                                                  
count_timer: 6 count_button 11                                                  
count_timer: 8 count_button 12                                                  
count_timer: 10 count_button 12                                                 
count_timer: 12 count_button 12                                                 
count_timer: 14 count_button 14                                                 
count_timer: 16 count_button 14                                                 
count_timer: 18 count_button 14                                                 
count_timer: 21 count_button 15                                                 
count_timer: 23 count_button 15                                                 
count_timer: 25 count_button 17                                                 
count_timer: 27 count_button 18                                                 
count_timer: 29 count_button 20                                                 
count_timer: 29 count_button 20                                                 
count_timer: 29 count_button 20                                                 
count_timer: 29 count_button 21                                                 
count_timer: 29 count_button 21                                                 
count_timer: 29 count_button 22                                                 
count_timer: 29 count_button 23                                                 
count_timer: 29 count_button 24     
*/
