
#include "mbed.h"
#include "Picaso_4DGL-32PTU.h"

#define SHORT_WAIT 500
#define LONG_WAIT 1000

// local declarations
void clearBuf(char*, int);

//**************************************************************************
// Demo program that goes through file system based functions
//**************************************************************************
void PICASO_4DGL :: fileSystemDemo() {
    
    short h1;
    int i;
    cls();
    screenMode(landscape); // set orientation to landscape
    puts("\n\rThis is the File system functions demo");
    wait_ms(LONG_WAIT);
    cls();
    
    if (file_Mount()) puts("\rFAT16 Mount: OK");
    else puts("\rFAT16 Mount: FAIL");
    char buf[100];
    sprintf(buf, "\n\rFAT16 Error = %i\n", file_Error());
    puts(buf);
    /*
    sprintf(buf, "\n\rFile count on disc = %i\n\r", file_Count("*.*"));
    puts(buf);
    sprintf(buf, "\n\rFound %i files maching 1*.*", file_Dir("1*.*"));
    puts(buf);
    file_FindFirst("*.TXT");
    char filename[FILENAME_LENGTH];
    for (i = 0; i < FILENAME_LENGTH; i++) 
        filename[i] = 0;
    short len = file_FindFirstRet("*.TXT", filename);
    sprintf(buf, "\n\rFirst filename = %s\n   Length = %i", filename, len);
    puts(buf);
    for (i = 0; i < FILENAME_LENGTH; i++) 
        filename[i] = 0;
    file_FindNext();
    len = file_FindNextRet(filename);
    sprintf(buf, "\n\rNext filename = %s\n   Length = %i", filename, len);
    puts(buf);
    file_FindNext();
    file_FindNext();
    file_FindNext();
    if (file_Exists("3.TXT")) puts("\n\r3.TXT : EXISTS");
    else  puts("\n\r3.TXT : DOES NOT EXIST");
    if (file_Exists("4.TXT")) puts("\n\r4.TXT : EXISTS");
    else  puts("\n\r4.TXT : DOES NOT EXIST");
    wait_ms(LONG_WAIT);
    cls();
    */
    
    h1 = file_Open("file.txt", OPEN_READ);
    short err = file_Error();
    if (err == 0) sprintf(buf, "\r\file.txt handle = %i", h1);
    else sprintf(buf, "\rFile Open error = %i", err);
    puts(buf);
    short count = file_Read(31, h1);
    if (count == 31) sprintf(buf, "\r\nRead %i bytes from %i", count, h1);
    else sprintf(buf, "\r\nError = %i\n\rMax data count = %i", file_Error(), count);
    puts(buf);
    sprintf(buf, "\r\nData: %s", fileReadBuf);
    puts(buf);
    
    clearBuf(fileReadBuf, BUFFER_SIZE);
    short hi = 0, lo = 5;
    sprintf(buf, "\r\nSetting pointer to %i = %s", lo, file_Seek(h1, hi, lo) ? "true" : "false");
    puts(buf);
    file_Read(1, h1);
    sprintf(buf, "\r\nRead char = %c", fileReadBuf[0]);
    puts(buf);
    
    clearBuf(fileReadBuf, BUFFER_SIZE);
    short recNum = 2;
    sprintf(buf, "\r\nIndex pointer to %i = %s", lo, file_Index(h1, hi, lo, recNum) ? "true" : "false");
    puts(buf);
    file_Read(1, h1);
    sprintf(buf, "\r\nRead char = %c", fileReadBuf[0]);
    puts(buf);
    
    int pointer = file_Tell(h1);
    if (pointer >= 0) sprintf(buf, "\r\nPointer = %i", pointer);
    else sprintf(buf, "\r\nError = %i", file_Error());
    puts(buf);
    
    sprintf(buf, "\r\nFile %i Close = %s", h1, file_Close(h1) ? "true" : "false");
    puts(buf);
    
    h1 = file_Open("newfile.txt", OPEN_READ);
    err = file_Error();
    if (err == 0) sprintf(buf, "\r\nnewfile.txt handle = %i", h1);
    else sprintf(buf, "\rFile Open error = %i", err);
    puts(buf);
    
    clearBuf(fileReadBuf, BUFFER_SIZE);
    count = file_Read(18, h1);
    if (count == 18) sprintf(buf, "\r\nRead %i bytes from %i", count, h1);
    else sprintf(buf, "\r\nError = %i\n\rMax data count = %i", file_Error(), count);
    puts(buf);
    sprintf(buf, "\r\nData: %s", fileReadBuf);
    puts(buf);
    
    sprintf(buf, "\r\nFile %i size = %i", h1, file_Size(h1));
    puts(buf);
    
    sprintf(buf, "\r\nFile %i Close = %s", h1, file_Close(h1) ? "true" : "false");
    puts(buf);
    wait_ms(LONG_WAIT);
    cls();
    
    h1 = file_Open("1.txt", OPEN_READ);
    err = file_Error();
    if (err == 0) sprintf(buf, "\r\nnewfile.txt handle = %i", h1);
    else sprintf(buf, "\rFile Open error = %i", err);
    puts(buf);
    
    for (i = 0; i < 3; i++) {
        clearBuf(fileReadBuf, BUFFER_SIZE);
        count = file_GetS(30, h1, fileReadBuf);
        sprintf(buf, "\r\nRead %i bytes", count);
        puts(buf);
        sprintf(buf, "\r\nData: %s", fileReadBuf);
        puts(buf);
    }
    
    
    /*
    short h2 = file_Open("scr.png", OPEN_APPEND);
    file_ScreenCapture(10, 10, 200, 100, h2);
    file_Close(h2);
    
    wait_ms(LONG_WAIT);
    cls();
    
    h2 = file_Open("pic.bmp", OPEN_READ);
    file_Image(5, 5, h2);
    */
    /*
    h1 = file_Open("newfile.txt", OPEN_APPEND); // try appending to file
    err = file_Error();
    if (err == 0) sprintf(buf, "\r\nnewfile.txt handle = %i", h1);
    else sprintf(buf, "\rFile Open error = %i", err);
    puts(buf);
    
    count = file_Write(13, " My Precious!", h1); // add data
    file_Close(h1); // close file
    h1 = file_Open("newfile.txt", OPEN_READ); // open in read mode again
    err = file_Error();
    if (err != 0) {
        sprintf(buf, "\rFile Open error = %i", err);
        puts(buf);
    }
    
    clearBuf(fileReadBuf, BUFFER_SIZE); // clear buffer 
    count = file_Read(18, h1); // read bytes
    if (count != 18) {
        sprintf(buf, "\r\nError = %i\n\rMax data count = %i", file_Error(), count);
        puts(buf);
    }
    sprintf(buf, "\r\nData: %s", fileReadBuf);
    puts(buf);
    */
    
    
}
//**************************************************************************
// Demo program that goes through media based functions
//**************************************************************************
void PICASO_4DGL :: mediaDemo() {
    
    cls();
    screenMode(landscape); // set orientation to landscape
    puts("\n\rThis is the Media functions demo");
    wait_ms(LONG_WAIT);
    cls();
    
    wait_ms(SHORT_WAIT);
    if (media_Init()) puts("\n\r uSD card Initialization: OK");
    else puts("\n\r uSD card Initialization: FAIL");
    if (media_SetAdd(513)) puts("\n\r Byte address set: OK");
    else puts("\n\r Byte address set: FAIL");
    if (media_SetSector(1)) puts("\n\r Sector address set: OK");
    else puts("\n\r Sector address set: FAIL");
/*
    puts("\n\r Now write some data in multiple sectors");
    
    char array[1030];
    for (int i = 0; i < 1030; i++) 
        array[i] = 1;
    
    wait_ms(LONG_WAIT);
    if (media_WrSector(array)) puts("\n\r Write Data: OK");
    else puts("\n\r Write Data: FAIL");
    wait_ms(LONG_WAIT);
    puts("\n\r Now read the same data");
    if (media_SetSector(1)) puts("\n\r Sector address set: OK");
    if (media_RdSector()) puts("\n\r Read Sector 1: OK");
    else puts("\n\r Read Sector 1: FAIL");
    if (media_RdSector()) puts("\n\r Read Sector 2: OK");
    else puts("\n\r Read Sector 2: FAIL");
    if (media_RdSector()) puts("\n\r Read Sector 3: OK");
    else puts("\n\r Read Sector 3: FAIL");
    if (media_RdSector()) puts("\n\r Read Sector 4: OK");
    else puts("\n\r Read Sector 4: FAIL");
    if (media_RdSector()) puts("\n\r Read Sector 5: OK");
    else puts("\n\r Read Sector 5: FAIL");
*/
    media_SetSector(1);
    puts("\n\r Now write some data in one sector");
    wait_ms(LONG_WAIT);
    if (media_WrSector("Such data Much WOW")) puts("\n\r Write Data: OK");
    else puts("\n\r Write Data: FAIL");
    wait_ms(LONG_WAIT);
    puts("\n\r Now read the same data");
    media_SetSector(1);
    if (media_RdSector()) {
        puts("\n\r Read Sector : OK");
        pc.printf("\n\r Data: ");
        for(int i = 0; i < BUFFER_SIZE; i++) pc.printf("%c", buffer[i]);
        pc.printf("\n\r");
    }
    else puts("\n\r Read Sector : FAIL");
    
    puts("\n\r Now read one byte");
    media_SetAdd(510);
    if (media_ReadByte()) puts("\n\r Read Byte : OK");
    else puts("\n\r Read Byte : FAIL");
    
    puts("\n\r Now read one word");
    if (media_ReadByte()) puts("\n\r Read word : OK");
    else puts("\n\r Read word : FAIL");
    
    puts("\n\r Now write one byte");
    media_SetSector(1);
    if (media_WriteByte('a')) puts("\n\r Write Byte : OK");
    else puts("\n\r Write Byte : FAIL");
    if (media_Flush()) puts("\n\r Flush : OK");
    else puts("\n\r Flush : FAIL");
    
    puts("\n\r Now write one word (2 bytes)");
    //media_SetSector(1);
    if (media_WriteWord(19)) puts("\n\r Write Word : OK");
    else puts("\n\r Write Word : FAIL");
    if (media_Flush()) puts("\n\r Flush : OK");
    else puts("\n\r Flush : FAIL");
    wait_ms(LONG_WAIT);
    
}
//**************************************************************************
// Demo program that goes through graphics based functions
//**************************************************************************
void PICASO_4DGL :: graphicsDemo() {


    cls();
    screenMode(landscape); // set orientation to landscape
    puts("This is the Graphics functions demo");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets change background color:");
    bgColor(Purple);
    cls();
    wait_ms(SHORT_WAIT);
    bgColor(White);
    cls();
    wait_ms(SHORT_WAIT);
    bgColor(Blue);
    cls();
    wait_ms(SHORT_WAIT);
    bgColor(Red);
    cls();
    wait_ms(SHORT_WAIT);
    bgColor(Aqua);
    cls();
    wait_ms(SHORT_WAIT);
    bgColor(Black);
    cls();
    wait_ms(LONG_WAIT);
    
    puts("\nLets change contrast");
    wait_ms(LONG_WAIT);
    contrast(DISABLE);
    wait_ms(LONG_WAIT);
    contrast(ENABLE);
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets change outline color ");
    wait_ms(LONG_WAIT);
    drawFilledCircle(50, 50, 20, Red);
    wait_ms(SHORT_WAIT);
    outlineColor(White);
    wait_ms(SHORT_WAIT);
    drawFilledCircle(100, 50, 20, Red);
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets change all the ");
    textFgColor(Purple);
    puts("PURPLE");
    textFgColor(Yellow);
    puts(" bits to yellow");
    textFgColor(Green); // set Color back to green
    wait_ms(LONG_WAIT);
    changeColor(Purple, Yellow);
    wait_ms(LONG_WAIT);
    cls();
    
    puts("Lets draw some shapes:");
    wait_ms(SHORT_WAIT);
    drawCircle(100, 100, 20, Aqua);
    wait_ms(SHORT_WAIT);
    drawFilledCircle(50, 50, 20, Red);
    wait_ms(SHORT_WAIT);
    drawLine(20, 20, 100, 30, Blue);
    wait_ms(SHORT_WAIT);
    drawRectangle(120, 20, 200, 60, Pink);
    wait_ms(SHORT_WAIT);
    drawFilledRectangle(210, 0, 250, 80, Orange);
    wait_ms(SHORT_WAIT);
    short xPolyline[3] = {10, 80, 180};
    short yPolyline[3] = {10, 200, 80};
    drawPolyline(3, xPolyline, yPolyline, Green);
    wait_ms(SHORT_WAIT);
    short xPolygon[5] = {0, 30, 5, 50, 40};
    short yPolygon[5] = {50, 100, 220, 230, 170};
    drawPolygon(5, xPolygon, yPolygon, Grey);
    wait_ms(SHORT_WAIT);
    short xFilledPolygon[5] = {260, 280, 290, 300, 255};
    short yFilledPolygon[5] = {0, 20, 35, 55, 22};
    drawFilledPolygon(5, xFilledPolygon, yFilledPolygon, White);
    wait_ms(SHORT_WAIT);
    drawTriangle(70, 130, 90, 150, 110, 120, Cream);
    wait_ms(SHORT_WAIT);
    drawFilledTriangle(260, 50, 300, 90, 240, 120, Yellow);
    wait_ms(SHORT_WAIT);
    drawElipse(200, 130, 20, 10, Olive);
    wait_ms(SHORT_WAIT);
    drawFilledElipse(200, 100, 30, 20, Navy);
    wait_ms(SHORT_WAIT);
    linePatern(10);
    drawLine(200, 200, 100, 300, White);
    wait_ms(LONG_WAIT);
    cls();
    
/*
    // somehow after this function display stops (but the calculation is right)
    puts("Lets calculate distance from point 0,0 on angle 40, 60 pixels away:");
    wait_ms(LONG_WAIT);
    cls();
    calculateOrbit(40, 60);
    wait_ms(SHORT_WAIT);
    cls();
*/

    puts("Lets draw some pixels:");
    wait_ms(LONG_WAIT);
    cls();
    for (int i = 0; i <= 10; i++) {
        for (int j = 0; j <= 10; j++) {
            putPixel(i, j, Red);
        }
    }
    wait_ms(LONG_WAIT);
    cls();
    
    puts("Lets move origin point:");
    wait_ms(LONG_WAIT);
    moveOrigin(100, 100);
    puts("This is the new origin!");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("Now draw line from here:");
    wait_ms(SHORT_WAIT);
    lineTo(100, 100);
    wait_ms(LONG_WAIT);
    puts("To here!");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("Change clipping window, to test it, we use changeColor function, that works only in clipping area:");
    wait_ms(LONG_WAIT);
    wait_ms(LONG_WAIT);
    setClipWindow(0, 0, 200, 20);
    changeColor(Green, Red);
    puts("\n\n\rDone!!!!");
    wait_ms(LONG_WAIT);
    puts("\n\n\rNow extend to here!");
    wait_ms(LONG_WAIT);
    extendClipRegion();
    changeColor(Green, Red);
    puts("\n\n\rHow does it look?");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets place a button:");
    wait_ms(LONG_WAIT);
    cls();
    drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    puts("\n\n\n\nDid it work?");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nNow lets change bevel width");
    wait_ms(LONG_WAIT);
    if (bevelWidth(0)) {
        puts("\nNo bevel");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(LONG_WAIT);
    cls();
    if (bevelWidth(1)) {
        puts("\nbevel 1");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(LONG_WAIT);
    cls();
    if (bevelWidth(10)) {
        puts("\nbevel 10");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(LONG_WAIT);
    cls();
    if (bevelWidth(16)) {
        puts("\nbevel 16");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(LONG_WAIT);
    cls();
    if (bevelWidth(2)) {
        puts("\nbevel 2");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nNow lets change bevel shadow level");
    wait_ms(LONG_WAIT);
    if (bevelShadow(0)) {
        puts("\nNo shadow");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(SHORT_WAIT);
    if (bevelShadow(1)) {
        puts("\nShadow 1");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(SHORT_WAIT);
    if (bevelShadow(2)) {
        puts("\nShadow 2");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(SHORT_WAIT);
    if (bevelShadow(3)) {
        puts("\nShadow 3");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(SHORT_WAIT);
    if (bevelShadow(4)) {
        puts("\nShadow 4");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(SHORT_WAIT);
    if (bevelShadow(5)) {
        puts("\nShadow 5");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(SHORT_WAIT);
    if (bevelShadow(1)) {
        puts("\nShadow 1");
        drawButton(DEPRESSED, 100, 100, Aqua, Violet, 2, 2, 2, "Press Me");
    }
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets place a panel:");
    wait_ms(LONG_WAIT);
    cls();
    drawPanel(RECESSED, 0, 0, 200, 20, Cream);
    wait_ms(SHORT_WAIT);
    puts("\nDid it work?");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets place a slider:");
    wait_ms(LONG_WAIT);
    cls();
    drawSlider(RAISED, 30, 40, 210, 90, Violet, 100, 0);
    puts("\nDid it work?");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nThis particular function is going to copy a specified portion of the creen and paste it somewhere else!");
    wait_ms(LONG_WAIT);
    wait_ms(LONG_WAIT);
    wait_ms(LONG_WAIT);
    //cls();
    screenCopyPaste(0, 0, 50, 100, 200, 50);
    puts("\nDid it work?");
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nLets get Xmax:");
    wait_ms(LONG_WAIT);
    short Xmax = getGraphics(currentXMax);
    puts("\nLets get Ymax:");
    wait_ms(LONG_WAIT);
    short Ymax = getGraphics(currentYMax);
    wait_ms(LONG_WAIT);
    pc.printf("\nCurrent orientation xMax = %i, yMax = %i\n\r", Xmax, Ymax);
    cls();
    wait_ms(LONG_WAIT);
} 

//**************************************************************************
// Demo program that goes through main functions
//**************************************************************************
void PICASO_4DGL :: mainDemo() {

    cls();
    puts("This is the main functions demo");
    wait_ms(LONG_WAIT);
    cls();
/*
    puts("\nBaudrates:");
    wait_ms(LONG_WAIT);
    cls();
    
    baudrate(4800);
    puts("\n4800");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(9600);
    puts("\n9600");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(14400);
    puts("\n14400");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(19200);
    puts("\n19200");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(38400);
    puts("\n38400");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(56000);
    puts("\n56000");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(57600);
    puts("\n57600");
    wait_ms(SHORT_WAIT);
    cls();
    baudrate(9600);
    puts("\n9600");
    wait_ms(SHORT_WAIT);
    cls();
*/
    puts("\nOrientation:");
    wait_ms(LONG_WAIT);
    cls();
    screenMode(landscape);
    puts("landscape");
    wait_ms(SHORT_WAIT);
    cls();
    screenMode(landscapeRew);
    puts("landscape rewersed");
    wait_ms(SHORT_WAIT);
    cls();
    screenMode(portrait);
    puts("portrait");
    wait_ms(SHORT_WAIT);
    cls();
    screenMode(portraitRew);
    puts("portrait rewersed");
    wait_ms(LONG_WAIT);
    screenMode(landscape); // set back screen to landscape
    cls();
    
}

//**************************************************************************
// Demo program that goes through text based functions
//**************************************************************************
void PICASO_4DGL :: textDemo() {
    
    cls();
    screenMode(landscape); // set screen to landscape
    puts("This is the Text functions demo");
    wait_ms(LONG_WAIT);
    cls();

    puts("\nText attributes:");
    wait_ms(LONG_WAIT);
    //cls();
    puts("\n\n");
    textAttributes(bold);
    puts("\nBOLD");
    wait_ms(SHORT_WAIT);
    textAttributes(bold + italic);
    puts("\nBOLD & ITALIC");
    wait_ms(SHORT_WAIT);
    textAttributes(bold + italic + inverse);
    puts("\nBOLD & ITALIC & INVERSE");
    wait_ms(SHORT_WAIT);
    textAttributes(bold + italic + inverse + underline);
    puts("\nBOLD & ITALIC & INVERSE & UNDERLINE");
    wait_ms(LONG_WAIT);
    textAttributes(DISABLE); // set everything back to normal
    cls();
    
    puts("\nText modes:");
    wait_ms(LONG_WAIT);
    cls();
    textBold(ENABLE);
    puts("\nBOLD:");
    wait_ms(SHORT_WAIT);
    textBold(DISABLE);
    textInverse(ENABLE);
    puts("\nINVERSE:");
    wait_ms(SHORT_WAIT);
    textInverse(DISABLE);
    textItalic(ENABLE);
    puts("\nITALIC:");
    wait_ms(SHORT_WAIT);
    textItalic(DISABLE);
    textUnderline(ENABLE);
    puts("\nUNDERLINE:");
    wait_ms(SHORT_WAIT);
    textUnderline(DISABLE);
    wait_ms(LONG_WAIT);
    cls();
    
    puts("\nText gaps:");
    wait_ms(LONG_WAIT);
    cls();
    if (textXGap(0) == 1) puts("\nX gap: 0");
    wait_ms(SHORT_WAIT);
    if (textXGap(1) == 1) puts("\nX gap: 1");
    wait_ms(SHORT_WAIT);
    if (textXGap(2) == 1) puts("\nX gap: 2");
    wait_ms(SHORT_WAIT);
    if (textXGap(3) == 1) puts("\nX gap: 3");
    wait_ms(SHORT_WAIT);
    if (textXGap(4) == 1) puts("\nX gap: 4");
    wait_ms(SHORT_WAIT);
    if (textXGap(5) == 1) puts("\nX gap: 5");
    wait_ms(SHORT_WAIT);
    if (textXGap(6) == 1) puts("\nX gap: 6");
    wait_ms(SHORT_WAIT);
    puts("\n");
    textXGap(0);
    if (textYGap(0) == 1) puts("\nY gap: 0");
    wait_ms(SHORT_WAIT);
    if (textYGap(1) == 1) puts("\nY gap: 1");
    wait_ms(SHORT_WAIT);
    if (textYGap(2) == 1) puts("\nY gap: 2");
    wait_ms(SHORT_WAIT);
    if (textYGap(3) == 1) puts("\nY gap: 3");
    wait_ms(SHORT_WAIT);
    if (textYGap(4) == 1) puts("\nY gap: 4");
    wait_ms(SHORT_WAIT);
    if (textYGap(5) == 1) puts("\nY gap: 5");
    wait_ms(SHORT_WAIT);
    if (textYGap(6) == 1) puts("\nY gap: 6");
    wait_ms(LONG_WAIT);
    textYGap(0);
    cls();
    
    puts("Text width:");
    wait_ms(LONG_WAIT);
    if (textWidth(1) == 1) puts("\nWidth: 1");
    wait_ms(SHORT_WAIT);
    if (textWidth(2) == 1) puts("\nWidth: 2");
    wait_ms(SHORT_WAIT);
    if (textWidth(3) == 1) puts("\nWidth: 3");
    wait_ms(SHORT_WAIT);
    if (textWidth(4) == 1) puts("\nWidth: 4");
    wait_ms(SHORT_WAIT);
    textWidth(1);
    puts("\nText height:");
    wait_ms(LONG_WAIT);
    //cls();
    if (textHeight(1) == 1) puts("\nHeight: 1");
    wait_ms(SHORT_WAIT);
    if (textHeight(2) == 1) puts("\nHeight: 2");
    wait_ms(SHORT_WAIT);
    if (textHeight(3) == 1) puts("\nHeight: 3");
    wait_ms(SHORT_WAIT);
    if (textHeight(4) == 1) puts("\nHeight: 4");
    wait_ms(LONG_WAIT);
    textHeight(1);
    cls();

    puts("Fonts:");
    wait_ms(LONG_WAIT);
    cls();
    setFont(font1);
    puts("\nThis is Font 1");
    wait_ms(SHORT_WAIT);
    setFont(font2);
    puts("\nThis is Font 2");
    wait_ms(SHORT_WAIT);
    setFont(font3);
    puts("\nThis is Font 3");
    wait_ms(LONG_WAIT);
    cls();


    screenMode(portrait);
    puts("\nText Background colors:");
    wait_ms(LONG_WAIT);
    cls();
    textBgColor(Black);
    puts("\nBG Color = BLACK");
    wait_ms(SHORT_WAIT);
    textBgColor(Navy);
    puts("\nBG Color = NAVY");
    wait_ms(SHORT_WAIT);
    textFgColor(Black);
    textBgColor(DGreen);
    puts("\nBG Color = DARK GREEN");
    wait_ms(SHORT_WAIT);
    textBgColor(DCyan);
    puts("\nBG Color = DARK CYAN");
    wait_ms(SHORT_WAIT);
    textBgColor(Purple);
    puts("\nBG Color = PURPLE");
    wait_ms(SHORT_WAIT);
    textBgColor(Olive);
    puts("\nBG Color = OLIVE");
    wait_ms(SHORT_WAIT);
    textBgColor(Grey);
    puts("\nBG Color = GREY");
    wait_ms(SHORT_WAIT);
    textBgColor(Blue);
    puts("\nBG Color = BLUE");
    wait_ms(SHORT_WAIT);
    textBgColor(Green);
    puts("\nBG Color = GREEN");
    wait_ms(SHORT_WAIT);
    textBgColor(Red);
    puts("\nBG Color = RED");
    wait_ms(SHORT_WAIT);
    textBgColor(Yellow);
    puts("\nBG Color = YELLOW");
    wait_ms(SHORT_WAIT);
    textBgColor(GYellow);
    puts("\nBG Color = GREEN YELLOW");
    wait_ms(SHORT_WAIT);
    textBgColor(White);
    puts("\nBG Color = WHITE");
    wait_ms(SHORT_WAIT);
    textBgColor(Orange);
    puts("\nBG Color = ORANGE");
    wait_ms(SHORT_WAIT);
    textBgColor(Pink);
    puts("\nBG Color = PINK");    
    wait_ms(SHORT_WAIT);
    textBgColor(Violet);
    puts("\nBG Color = VIOLET");
    wait_ms(SHORT_WAIT);
    textBgColor(Aqua);
    puts("\nBG Color = AQUA");
    wait_ms(SHORT_WAIT);
    textBgColor(Cream);
    puts("\nBG Color = CREAM");
    wait_ms(LONG_WAIT);
    textBgColor(Black); // set Color back
    textFgColor(Green); // set Color back
    cls();
    
    screenMode(landscape);
    puts("Lets try moving cursor...");
    wait_ms(LONG_WAIT);
    cls();
    if (moveCursor(5, 5) == 1) puts("+");
    wait_ms(SHORT_WAIT);
    if (moveCursor(10, 10) == 1) puts("+");
    wait_ms(SHORT_WAIT);
    screenMode(portraitRew);
    if (moveCursor(50, 50) == 1) puts("+");
    wait_ms(SHORT_WAIT);
    if (moveCursor(19, 29) == 1) puts("+");
    wait_ms(LONG_WAIT);
    cls();


    screenMode(portrait);
    puts("\nText Foreground Colors:");
    wait_ms(LONG_WAIT);
    cls();
    textBgColor(White);
    textFgColor(Black);
    puts("\nFG Color = BLACK");
    textBgColor(Black);
    wait_ms(SHORT_WAIT);
    textFgColor(Navy);
    puts("\nFG Color = NAVY");
    wait_ms(SHORT_WAIT);
    textFgColor(DGreen);
    puts("\nFG Color = DARK GREEN");
    wait_ms(SHORT_WAIT);
    textFgColor(DCyan);
    puts("\nFG Color = DARK CYAN");
    wait_ms(SHORT_WAIT);
    textFgColor(Purple);
    puts("\nFG Color = PURPLE");
    wait_ms(SHORT_WAIT);
    textFgColor(Olive);
    puts("\nFG Color = OLIVE");
    wait_ms(SHORT_WAIT);
    textFgColor(Grey);
    puts("\nFG Color = GREY");
    wait_ms(SHORT_WAIT);
    textFgColor(Blue);
    puts("\nFG Color = BLUE");
    wait_ms(SHORT_WAIT);
    textFgColor(Green);
    puts("\nFG Color = GREEN");
    wait_ms(SHORT_WAIT);
    textFgColor(Red);
    puts("\nFG Color = RED");
    wait_ms(SHORT_WAIT);
    textFgColor(Yellow);
    puts("\nFG Color = YELLOW");
    wait_ms(SHORT_WAIT);
    textFgColor(GYellow);
    puts("\nFG Color = GREEN YELLOW");
    wait_ms(SHORT_WAIT);
    textFgColor(White);
    puts("\nFG Color = WHITE");
    wait_ms(SHORT_WAIT);
    textFgColor(Orange);
    puts("\nFG Color = ORANGE");
    wait_ms(SHORT_WAIT);
    textFgColor(Pink);
    puts("\nFG Color = PINK");    
    wait_ms(SHORT_WAIT);
    textFgColor(Violet);
    puts("\nFG Color = VIOLET");
    wait_ms(SHORT_WAIT);
    textFgColor(Aqua);
    puts("\nFG Color = AQUA");
    wait_ms(SHORT_WAIT);
    textFgColor(Cream);
    puts("\nFG Color = CREAM");
    wait_ms(LONG_WAIT);
    textFgColor(Green); // set Color back
    wait_ms(LONG_WAIT);
    

}

void clearBuf(char *str, int size) {
    int i;
    for (i = 0; i < size; i++) {
        str[i] = 0;
    }
}