//
//  Picaso_4DGL-32PTU is a class to drive 4D Systems TFT touch screens with PICASO processor
//  Tested with NUCLEO L152RE development board
//  Copyright (C) <2016> Rihards Balass <rihards.balass@gmail.com>
//
// Picaso_4DGL-32PTU is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Picaso_4DGL-32PTU is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You can see GNU General Public License at <http://www.gnu.org/licenses/>.
//

#include "mbed.h"
#include "Picaso_4DGL-32PTU.h"

DigitalOut led1(LED1);

//******************************************************************************************************
PICASO_4DGL :: PICASO_4DGL(PinName tx, PinName rx, PinName rst) : pc(USBTX, USBRX), _cmd(tx, rx), _rst(rst) { // Constructor
    
    index = 0;
    _cmd.attach(this, &PICASO_4DGL::rxCallback, Serial::RxIrq); 
    
    pc.baud(115200);
#if DEBUGMODE
    pc.printf("\n\n\n");
    pc.printf("********************\n\r");
    pc.printf("PICASO_4DGL CONSTRUCTOR\n\r");
    pc.printf("********************\n\r");
#endif
    _rst = 1;    // put RESET pin to high to start TFT screen
    
#if DEBUGMODE
    pc.printf("Wait 3 seconds for startup...\n\r");
#endif
    wait_ms(3000);

#if DEBUGMODE
    pc.printf("set baudrate to 9600...\n\r");
#endif
    baudrate(9600); 
    
#if DEBUGMODE
    pc.printf("clear screen...\n\r");
#endif
    wait_ms(1000);
    screenMode(landscape);
    setFont(font3);
    cls();
    
#if DEMO
    //mainDemo();
    //textDemo();
    //graphicsDemo();
    //mediaDemo();
    fileSystemDemo();
#endif   
}

//******************************************************************************************************
void PICASO_4DGL :: rxCallback() {
    
    if(_cmd.readable()) rxBuf[index++] = _cmd.getc();
}

//******************************************************************************************************
void PICASO_4DGL :: writeBYTE(char c) { // send a BYTE command to screen

    _cmd.putc(c);

#if DEBUGMODE
    pc.printf("   Char sent : 0x%02X  ",c);
    pc.putc(c);
    pc.printf(" \n\r");
#endif

}

//******************************************************************************************************
void PICASO_4DGL :: freeBUFFER(void) {       // Clear serial buffer before writing command

    while (_cmd.readable()) _cmd.getc();  // clear buffer garbage
    index = 0;
}

//******************************************************************************************************
void PICASO_4DGL :: writeCOMMAND(char *command, int number) { // send several BYTES making a command and return an answer

#if DEBUGMODE
    pc.printf("\n\r");
    pc.printf("New COMMAND : 0x%02X%02X\n\r", command[0], command[1]);
#endif
    int i;
    freeBUFFER();
    //index = 0;
    
    for (i = 0; i < number; i++) writeBYTE(command[i]); // send command to serial port
}

//******************************************************************************************************
void PICASO_4DGL :: writeCOMMAND_2(char *command, int number) { // send several BYTES making a command and return an answer

#if DEBUGMODE
    pc.printf("\n\r");
    pc.printf("New COMMAND : 0x%02X%02X\n\r", command[0], command[1]);
#endif
    int i;
    freeBUFFER();
    //index = 0;
    
    for (i = 0; i < number; i++) _cmd.putc(command[i]); // send command to serial port
}

//**************************************************************************
void PICASO_4DGL :: reset() {  // Reset Screen

    _rst = 0;               // put RESET pin to low
    wait_ms(TEMPO);         // wait a few milliseconds for command reception
    _rst = 1;               // put RESET back to high
    wait(3);                // wait 3s for screen to restart

    freeBUFFER();           // clean buffer from possible garbage
}

//**************************************************************************
void PICASO_4DGL :: baudrate(long speed) {  // set screen baud rate
    
    char command[4]= "";
    command[0] = (BAUDRATE >> (8*1)) & 0xff;
    command[1] = (BAUDRATE >> (8*0)) & 0xff;
    switch (speed) {
        case  300 :
            command[2] = (BAUD_300 >> (8*1)) & 0xff;
            command[3] = (BAUD_300 >> (8*0)) & 0xff;
            break;
        case  600 :
            command[2] = (BAUD_600 >> (8*1)) & 0xff;
            command[3] = (BAUD_600 >> (8*0)) & 0xff;
            break;
        case 1200 :
            command[2] = (BAUD_1200 >> (8*1)) & 0xff;
            command[3] = (BAUD_1200 >> (8*0)) & 0xff;
            break;
        case 2400 :
            command[2] = (BAUD_2400 >> (8*1)) & 0xff;
            command[3] = (BAUD_2400 >> (8*0)) & 0xff;
            break;
        case 4800 :
            command[2] = (BAUD_4800 >> (8*1)) & 0xff;
            command[3] = (BAUD_4800 >> (8*0)) & 0xff;
            break;
        case 9600 :
            command[2] = (BAUD_9600 >> (8*1)) & 0xff;
            command[3] = (BAUD_9600 >> (8*0)) & 0xff;
            break;
        case 14400 :
            command[2] = (BAUD_14400 >> (8*1)) & 0xff;
            command[3] = (BAUD_14400 >> (8*0)) & 0xff;
            break;
        case 19200 :
            command[2] = (BAUD_19200 >> (8*1)) & 0xff;
            command[3] = (BAUD_19200 >> (8*0)) & 0xff;
            break;
        case 31250 :
            command[2] = (BAUD_31250 >> (8*1)) & 0xff;
            command[3] = (BAUD_31250 >> (8*0)) & 0xff;
            break;
        case 38400 :
            command[2] = (BAUD_38400 >> (8*1)) & 0xff;
            command[3] = (BAUD_38400 >> (8*0)) & 0xff;
            break;
        case 56000 :
            command[2] = (BAUD_56000 >> (8*1)) & 0xff;
            command[3] = (BAUD_56000 >> (8*0)) & 0xff;
            break;
        case 57600 :
            command[2] = (BAUD_57600 >> (8*1)) & 0xff;
            command[3] = (BAUD_57600 >> (8*0)) & 0xff;
            break;
        case 115200 :
            command[2] = (BAUD_115200 >> (8*1)) & 0xff;
            command[3] = (BAUD_115200 >> (8*0)) & 0xff;
            break;
        case 128000 :
            command[2] = (BAUD_128000 >> (8*1)) & 0xff;
            command[3] = (BAUD_128000 >> (8*0)) & 0xff;
            break;
        case 256000 :
            command[2] = (BAUD_256000 >> (8*1)) & 0xff;
            command[3] = (BAUD_256000 >> (8*0)) & 0xff;
            break;
        case 300000 :
            command[2] = (BAUD_300000 >> (8*1)) & 0xff;
            command[3] = (BAUD_300000 >> (8*0)) & 0xff;
            break;
        case 375000 :
            command[2] = (BAUD_375000 >> (8*1)) & 0xff;
            command[3] = (BAUD_375000 >> (8*0)) & 0xff;
            break;
        case 500000 :
            command[2] = (BAUD_500000 >> (8*1)) & 0xff;
            command[3] = (BAUD_500000 >> (8*0)) & 0xff;
            break;
        case 600000 :
            command[2] = (BAUD_600000 >> (8*1)) & 0xff;
            command[3] = (BAUD_600000 >> (8*0)) & 0xff;
            break;
        default :
            command[2] = (BAUD_9600 >> (8*1)) & 0xff;
            command[3] = (BAUD_9600 >> (8*0)) & 0xff;
            speed = 9600;
            break;
    }
    
#if DEBUGMODE
    pc.printf("\n\r");
    pc.printf("New BAUDRATE : 0x%02X%02X\n\r", command[0], command[1]);
#endif

    int i;
    freeBUFFER();
    
    //Change baudrates - as instructed by 4DGL
    if (speed == 128000) speed = 133929; 
    if (speed == 256000) speed = 281250; 
    if (speed == 300000) speed = 312500; 
    if (speed == 375000) speed = 401786; 
    if (speed == 500000) speed = 562500; 
    if (speed == 600000) speed = 703125; 
    
    for (i = 0; i <4; i++) writeBYTE(command[i]);      // send command to serial port
    _cmd.baud(speed);                 
    getResponse(1);
}
