//
//  Picaso_4DGL-32PTU is a class to drive 4D Systems TFT touch screens with PICASO processor
//  Tested with NUCLEO L152RE development board
//  Copyright (C) <2016> Rihards Balass <rihards.balass@gmail.com>
//
// Picaso_4DGL-32PTU is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Picaso_4DGL-32PTU is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You can see GNU General Public License at <http://www.gnu.org/licenses/>.
//

#include "mbed.h"
#include "Picaso_4DGL-32PTU.h"

//****************************************************************************************************
void PICASO_4DGL :: setFont(char mode) {   // set font size

    char command[4]= "";
    
    command[0] = (SET_FONT >> (8*1)) & 0xff;
    command[1] = (SET_FONT >> (8*0)) & 0xff;
    
    switch (mode) {
        case 1 :
            command[2] = (FONT1 >> (8*1)) & 0xff;
            command[3] = (FONT1 >> (8*0)) & 0xff;
            currentFont = 0;
            break;
        case 2 :
            command[2] = (FONT2 >> (8*1)) & 0xff;
            command[3] = (FONT2 >> (8*0)) & 0xff;
            currentFont = 1;
            break;
        case 3 :
            command[2] = (FONT3 >> (8*1)) & 0xff;
            command[3] = (FONT3 >> (8*0)) & 0xff;
            currentFont = 2;
            break;
        default :
            command[2] = (FONT3 >> (8*1)) & 0xff;
            command[3] = (FONT3 >> (8*0)) & 0xff;
            currentFont = 2;
            break;
    }

    writeCOMMAND(command, 4);
    getResponse(3);
}

//****************************************************************************************************
void PICASO_4DGL :: textBgColor(short color) {   // set text color
    
    char command[4]= "";
    
    command[0] = (TEXT_BG_COLOR >> (8*1)) & 0xff;
    command[1] = (TEXT_BG_COLOR >> (8*0)) & 0xff;
    
    command[2] = (color >> (8*1)) & 0xff;
    command[3] = (color >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
}

//****************************************************************************************************
void PICASO_4DGL :: putc(char c) {   // place char at current cursor position

    char command[3]= "";

    command[0] = (PUT_CHAR >> (8*1)) & 0xff;
    command[1] = (PUT_CHAR >> (8*0)) & 0xff;

    command[2] = c;

    writeCOMMAND(command, 3);
    getResponse(1);
}

//****************************************************************************************************
void PICASO_4DGL :: puts(char *s) {   // place string at current cursor position

    char command[1000]= "";
    
    int size = strlen(s);
    int i = 0;

    command[0] = (PUT_STRING >> (8*1)) & 0xff;
    command[1] = (PUT_STRING >> (8*0)) & 0xff;

    for (i=0; i<size; i++) command[2+i] = s[i]; 

    command[2+size] = 0;

    writeCOMMAND(command, 3 + size);
    getResponse(3);
}

char PICASO_4DGL :: validateMoveCursor(short line, short col) {
    
    switch (currentFont) {
        case 1 :
            if (currentMode == 1 || currentMode == 2) { // landscape or rewersed landscape
                if (line > F1LL) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Line must be less than %i...\n\r", F1LL);
                    return 0;
                }
                else if (col > F1LC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F1LC);
                    return 0;
                }
                else return 1; // everything is ok move the cursor
            }
            else { // portrait or rewersed portrait
                if (line > F1PL) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F1PL);
                    return 0;
                }
                else if (col > F1PC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F1PC);
                    return 0;
                }
                else return 1;
            }
        case 2 :
            if (currentMode == 1 || currentMode == 2) { // landscape or rewersed landscape
                if (line > F2LL) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Line must be less than %i...\n\r", F2LL);
                    return 0;
                }
                else if (col > F2LC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F2LC);
                    return 0;
                }
                else return 1; // everything is ok move the cursor
            }
            else { // portrait or rewersed portrait
                if (line > F2PL) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F2PL);
                    return 0;
                }
                else if (col > F2PC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F2PC);
                    return 0;
                }
                else return 1;
            }
        case 3 :
            if (currentMode == 1 || currentMode == 2) { // landscape or rewersed landscape
                if (line > F3LL) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Line must be less than %i...\n\r", F3LL);
                    return 0;
                }
                else if (col > F3LC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F3LC);
                    return 0;
                }
                else return 1; // everything is ok move the cursor
            }
            else { // portrait or rewersed portrait
                if (line > F3PL) {
                        pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F3PL);
                    return 0;
                }
                else if (col > F3PC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F3PC);
                    return 0;
                }
                else return 1;
            }
        default :
            if (currentMode == 1 || currentMode == 2) { // landscape or rewersed landscape
                if (line > F3LL) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Line must be less than %i...\n\r", F3LL);
                    return 0;
                }
                else if (col > F3LC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F3LC);
                    return 0;
                }
                else return 1; // everything is ok move the cursor
            }
            else { // portrait or rewersed portrait
                if (line > F3PL) {
                        pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F3PL);
                    return 0;
                }
                else if (col > F3PC) {
                    pc.printf("\n\r    ERROR_MOVE_CURSOR: Column must be less than %i...\n\r", F3PC);
                    return 0;
                }
                else return 1;
            }
    }
}

//****************************************************************************************************
char PICASO_4DGL :: moveCursor(short line, short col) {
    
    char command[6]= "";
    
    command[0] = (MOVE_CURSOR >> (8*1)) & 0xff;
    command[1] = (MOVE_CURSOR >> (8*0)) & 0xff;
    
    if (validateMoveCursor(line, col) == 1) {
        
        command[3] = line;
        command[5] = col;
        writeCOMMAND(command, 6);
        getResponse(1);
        return 1;
    }
    else return 0;
}

//****************************************************************************************************
void PICASO_4DGL :: textFgColor(short color) {
    
    char command[4]= "";
    
    command[0] = (TEXT_FG_COLOR >> (8*1)) & 0xff;
    command[1] = (TEXT_FG_COLOR >> (8*0)) & 0xff;
    
    command[2] = (color >> (8*1)) & 0xff;
    command[3] = (color >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
}

//****************************************************************************************************
int PICASO_4DGL :: textWidth(short multiplier) {
    
    if (multiplier > 0 && multiplier <= 16) {
        char command[4]= "";
        
        command[0] = (TEXT_WIDTH >> (8*1)) & 0xff;
        command[1] = (TEXT_WIDTH >> (8*0)) & 0xff;
        
        command[2] = (multiplier >> (8*1)) & 0xff;
        command[3] = (multiplier >> (8*0)) & 0xff;
        
        writeCOMMAND(command, 4);
        getResponse(3);
        return 1;
    } 
    else return 0;
}

//****************************************************************************************************
int PICASO_4DGL :: textHeight(short multiplier) {
    
    if (multiplier > 0 && multiplier <= 16) {
        char command[4]= "";
        
        command[0] = (TEXT_HEIGHT >> (8*1)) & 0xff;
        command[1] = (TEXT_HEIGHT >> (8*0)) & 0xff;
        
        command[2] = (multiplier >> (8*1)) & 0xff;
        command[3] = (multiplier >> (8*0)) & 0xff;
        
        writeCOMMAND(command, 4);
        getResponse(3);
        return 1;
    } 
    else return 0;
}

//****************************************************************************************************
int PICASO_4DGL :: textXGap(short pCount) {
    
    if (pCount <= 32) {
        char command[4]= "";
        
        command[0] = (TEXT_X_GAP >> (8*1)) & 0xff;
        command[1] = (TEXT_X_GAP >> (8*0)) & 0xff;
        
        command[2] = (pCount >> (8*1)) & 0xff;
        command[3] = (pCount >> (8*0)) & 0xff;
        
        writeCOMMAND(command, 4);
        getResponse(3);
        return 1;
    } 
    else return 0;
}

//****************************************************************************************************
int PICASO_4DGL :: textYGap(short pCount) {
    
    if (pCount <= 32) {
        char command[4]= "";
        
        command[0] = (TEXT_Y_GAP >> (8*1)) & 0xff;
        command[1] = (TEXT_Y_GAP >> (8*0)) & 0xff;
        
        command[2] = (pCount >> (8*1)) & 0xff;
        command[3] = (pCount >> (8*0)) & 0xff;
        
        writeCOMMAND(command, 4);
        getResponse(3);
        return 1;
    } 
    else return 0;
}
   
//****************************************************************************************************
void PICASO_4DGL :: textBold(short mode) {
    
    char command[4]= "";
    command[0] = (TEXT_BOLD >> (8*1)) & 0xff;
    command[1] = (TEXT_BOLD >> (8*0)) & 0xff;
    command[2] = (mode >> (8*1)) & 0xff;
    command[3] = (mode >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
} 
       
//****************************************************************************************************
void PICASO_4DGL :: textInverse(short mode) {
    
    char command[4]= "";
    command[0] = (TEXT_INVERSE >> (8*1)) & 0xff;
    command[1] = (TEXT_INVERSE >> (8*0)) & 0xff;
    command[2] = (mode >> (8*1)) & 0xff;
    command[3] = (mode >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
} 
       
//****************************************************************************************************
void PICASO_4DGL :: textItalic(short mode) {
    
    char command[4]= "";
    command[0] = (TEXT_ITALIC >> (8*1)) & 0xff;
    command[1] = (TEXT_ITALIC >> (8*0)) & 0xff;
    command[2] = (mode >> (8*1)) & 0xff;
    command[3] = (mode >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
} 
       
//****************************************************************************************************
void PICASO_4DGL :: textOpacity(short mode) {
    
    char command[4]= "";
    command[0] = (TEXT_OPACITY >> (8*1)) & 0xff;
    command[1] = (TEXT_OPACITY >> (8*0)) & 0xff;
    command[2] = (mode >> (8*1)) & 0xff;
    command[3] = (mode >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
} 
       
//****************************************************************************************************
// The “Text Y-gap” command is required to be at least 2 for the underline to be visible,
//****************************************************************************************************
void PICASO_4DGL :: textUnderline(short mode) {
    
    char command[4]= "";
    if (mode == 1) textYGap(2); 
    command[0] = (TEXT_UNDERLINE >> (8*1)) & 0xff;
    command[1] = (TEXT_UNDERLINE >> (8*0)) & 0xff;
    command[2] = (mode >> (8*1)) & 0xff;
    command[3] = (mode >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
} 
    
//****************************************************************************************************
// (bit 5 or) DEC 16 for BOLD
// (bit 6 or) DEC 32 for ITALIC
// (bit 7 or) DEC 64 for INVERSE
// (bit 8 or) DEC 128 for UNDERLINED
//****************************************************************************************************
void PICASO_4DGL :: textAttributes(short value) {
    
    char command[4]= "";
    if (CHECK_BIT(value, 7)) textYGap(2); 
    command[0] = (TEXT_ATTRIBUTES >> (8*1)) & 0xff;
    command[1] = (TEXT_ATTRIBUTES >> (8*0)) & 0xff;
    command[2] = (value >> (8*1)) & 0xff;
    command[3] = (value >> (8*0)) & 0xff;
    
    writeCOMMAND(command, 4);
    getResponse(3);
} 
