//
//  Picaso_4DGL-32PTU is a class to drive 4D Systems TFT touch screens with PICASO processor
//  Tested with NUCLEO L152RE development board
//  Copyright (C) <2016> Rihards Balass <rihards.balass@gmail.com>
//
// Picaso_4DGL-32PTU is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Picaso_4DGL-32PTU is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You can see GNU General Public License at <http://www.gnu.org/licenses/>.
//

#include "mbed.h"
#include "Picaso_4DGL-32PTU.h"


//**************************************************************************
bool PICASO_4DGL :: getResponse(int count) {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer...");
#endif
    //pc.printf("\n\r count = %i, index = %i", count, index);
    while (index < count) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    for (int i = 0; i < index; i++) {
        pc.printf("%02X ", rxBuf[i]);
    }
    pc.printf("\n\r");
#endif
    if (rxBuf[0] == 0x06) {
        index = 0; // set buffer index to 0
        return true;
    }
    else {
        index = 0;
        return false;
    }
}

//**************************************************************************
bool PICASO_4DGL :: calculateOrbitResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer...");
#endif
    while (index < 5) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    for (int i = 0; i < index; i++) {
        pc.printf("%02X ", rxBuf[i]);
    }
    pc.printf("\n\r");
#endif
    Xdest = rxBuf[1] << 8 | rxBuf[2];
    Ydest = rxBuf[3] << 8 | rxBuf[4];
#if DEBUGMODE
    pc.printf("\n\r DEBUG: New coordiantes = %i x %i\n\r", Xdest, Ydest);
#endif
    index = 0; // set buffer index to 0
    return true;
}


//**************************************************************************
short PICASO_4DGL :: getGraphicsResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer...");
#endif
    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    for (int i = 0; i < index; i++) {
        pc.printf("%02X ", rxBuf[i]);
    }
    pc.printf("\n\r");
#endif
    short answer = rxBuf[1] << 8 | rxBuf[2]; // set response variable
    index = 0; // set buffer index to 0
    return answer;
}

//**************************************************************************
short PICASO_4DGL :: mediaInitResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer...");
#endif
    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    for (int i = 0; i < index; i++) {
        pc.printf("%02X ", rxBuf[i]);
    }
    pc.printf("\n\r");
#endif
    short answer = rxBuf[1] << 8 | rxBuf[2];
    index = 0;
    return answer;
}

//**************************************************************************
bool PICASO_4DGL :: readSectorResponse(int count) {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif

    while (index < count) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    
    int j = 3;
    for (int i = 0; i < BUFFER_SIZE; i++) {
        buffer[i] = rxBuf[j];
        j++;
    }
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Buffer = ");
    for (int i = 0; i < BUFFER_SIZE; i++) {
        pc.printf("%02X ", buffer[i]);
    }
    pc.printf("\n\r");
#endif
    if (rxBuf[2] == 1) {
        index = 0; // set buffer index to 0
        return true;
    }
    else {
        index = 0;
        return false;
    }
}

//**************************************************************************
bool PICASO_4DGL :: writeSectorResponse(int count) {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif
    while (index < count) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    
    if (rxBuf[2] == 1) {
        index = 0; // set buffer index to 0
        return true;
    }
    else {
        index = 0;
        return false;
    }
}

//**************************************************************************
bool PICASO_4DGL :: readResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif

    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    
    if (rxBuf[0] == ACK) {
        index = 0; // set buffer index to 0
        return true;
    }
    else {
        index = 0;
        return false;
    }
}

//**************************************************************************
bool PICASO_4DGL :: writeByteResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif

    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    
    if (rxBuf[2] > 0) {
        index = 0; // set buffer index to 0
        return true;
    }
    else {
        index = 0;
        return false;
    }
}

//**************************************************************************
bool PICASO_4DGL :: fileMountResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif

    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    
    if (rxBuf[2] > 0) {
        index = 0; // set buffer index to 0
        return true;
    }
    else {
        index = 0;
        return false;
    }
}

//**************************************************************************
short PICASO_4DGL :: fileErrorResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif

    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    short error = rxBuf[1] << 8 | rxBuf[2];
    return error;
}

//**************************************************************************
short PICASO_4DGL :: fileCountResponse() {
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for answer");
#endif

    while (index < 3) wait_ms(100); // wait for screen answer
    
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Answer = ");
    pc.printf("%02X %02X %02X\n\r", rxBuf[0], rxBuf[1], rxBuf[2]);
#endif
    short error = rxBuf[1] << 8 | rxBuf[2];
    return error;
}

//**************************************************************************
short PICASO_4DGL :: getFilenameResponse(char *out) {
    
    int i, j = 3;
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for filename answer");
#endif
    while (index < 3) wait_ms(100); // wait for screen answer
    short len = rxBuf[1] << 8 | rxBuf[2];
    while (index < 3 + len) wait_ms(100); // wait for whole answer
    
    for (i = 0; i < len; i++)
        out[i] = rxBuf[j++]; // build filename string
    
    return len;
}

//**************************************************************************
short PICASO_4DGL :: readFileResponse(short size) {
    
    int i, j = 3;
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for read response");
#endif
    while (index < 3) wait_ms(100); // wait for screen answer
    short count = rxBuf[1] << 8 | rxBuf[2]; // store cont of bytes read
    while (index < count+3) wait_ms(100); // wait for screen answer
    if(count == size)
        for (i = 0; i < count; i++)
            fileReadBuf[i] = rxBuf[j++]; // store read data
    
    return count;
}


//**************************************************************************
int PICASO_4DGL :: fileTellResponse() {
    
    int p;
#if DEBUGMODE
    pc.printf("\n\r DEBUG: Wait for read response");
#endif
    while (index < 7) wait_ms(100); // wait for screen answer
    
    if (rxBuf[2] == 1) 
        p = rxBuf[3] << 24 | rxBuf[4] << 16 | rxBuf[5] << 8 | rxBuf[6];
    else p = -1;
    return p;
}







