
#ifndef PICASO_CONST_H
#define PICASO_CONST_H

#ifndef DEBUGMODE
#define DEBUGMODE 0
#endif

#ifndef DEMO
#define DEMO 0
#endif

// Common WAIT value in millisecond
#define TEMPO       1
#define MAX_WAIT    10

// Screen answers
#define ACK     0x06
#define NACK    0x15

// Predefined Fonts
#define FONT1   0x0000
#define FONT2   0x0001
#define FONT3   0x0002

// Line and column values depending on orientation and font F1LL = font1 landscape line
#define F1LL    29
#define F1LC    44
#define F1PL    39
#define F1PC    33

#define F2LL    29
#define F2LC    39
#define F2PL    39
#define F2PC    29

#define F3LL    19
#define F3LC    39
#define F3PL    26
#define F3PC    29

// Data speed
#define BAUD_300     0x0001
#define BAUD_600     0x0002
#define BAUD_1200    0x0003
#define BAUD_2400    0x0004
#define BAUD_4800    0x0005
#define BAUD_9600    0x0006
#define BAUD_14400   0x0007
#define BAUD_19200   0x0008
#define BAUD_31250   0x0009
#define BAUD_38400   0x000A
#define BAUD_56000   0x000B
#define BAUD_57600   0x000C
#define BAUD_115200  0x000D
#define BAUD_128000  0x000E
#define BAUD_256000  0x000F
#define BAUD_300000  0x0010
#define BAUD_375000  0x0011
#define BAUD_500000  0x0012
#define BAUD_600000  0x0013

// Defined colors
#define Black       0x0000
#define Navy        0x000F
#define DGreen      0x03E0
#define DCyan       0x03EF
#define Purple      0x780F
#define Olive       0x7BE0
#define Grey        0x8410
#define Blue        0x001F
#define Green       0x07E0
#define Red         0xF800
#define Yellow      0xFFE0
#define White       0xFFFF
#define Orange      0xFD20
#define GYellow     0xAFE5
#define Pink        0xF81F
#define Violet      0x901A
#define Aqua        0x07FF
#define Cream       0xFFDE

// Screen orientation
#define LANDSCAPE   0x0000
#define LANDSCAPE_R 0x0001
#define PORTRAIT    0x0002
#define PORTRAIT_R  0x0003

// Parameters
#define ENABLE          1
#define DISABLE         0
// orientation
#define landscape       1
#define landscapeRew    2
#define portrait        3
#define portraitRew     4
// text attributes
#define bold            16
#define italic          32
#define inverse         64
#define underline       128
// Fonts
#define font1           1
#define font2           2
#define font3           3
// Receive buffer length
#define RXBUFLEN        1024
#define BUFFER_SIZE     1024
// 3D states
#define DEPRESSED   0
#define RECESSED    0
#define INDENTED    0
#define RAISED      1
#define HIDDEN      2
// set graphic parameters
#define objColor        18
#define scrResolution   32
#define pageDisplay     33
#define pageRead        34
#define pageWrite       35
// get graphic parameters
#define currentXMax     0
#define currentYMax     1
#define lastObjLeft     2
#define lastObjTop      3
#define lastObjRight    4
#define lastObjBot      5
// Screen resolution
#define res320x240      0
#define res640x480      1
#define res800x480      2
// File system constants
#define FILENAME_LENGTH 125
#define OPEN_READ       0x72
#define OPEN_WRITE      0x77
#define OPEN_APPEND     0x61



#endif
