#include "mbed.h"
#include "NokiaLCD.h"

DigitalOut led(LED_RED);
AnalogIn ain0(A0);
AnalogIn ain1(A1);
AnalogIn ain2(A2);
AnalogIn ain3(A3);
AnalogIn ain4(A4);
AnalogIn ain5(A5);
NokiaLCD lcd(PTD6, PTD5, PTD4, PTC12, NokiaLCD::PCF8833); // mosi, sclk, cs, rst, type
int main()
{
    lcd.background(0xffffff);
    lcd.foreground(0x4b0082);
    lcd.cls();
    lcd.locate(0,1);
    lcd.printf("  FRDM-K64F     ");
    while (true) {
        led = 0; 
        wait(0.2f);
        lcd.printf("                ");
        wait(0.2f);
        lcd.locate(0,4);
        lcd.printf("AOVDC: %4.1f V ",(ain0.read()*3.3));
        wait(0.2f);
        lcd.locate(0,5);
        lcd.printf("A1VDC: %4.1f V ",(ain1.read()*3.3));
        wait(0.2f);
        lcd.locate(0,6);
        lcd.printf("A2VDC: %4.1f V ",(ain2.read()*3.3));
        wait(0.2f);
        lcd.locate(0,7); 
        lcd.printf("A3VDC: %4.1f V ",(ain3.read()*3.3));
        wait(0.2f);
        lcd.locate(0,8); 
        lcd.printf("A4VDC: %4.1f V ",(ain4.read()*3.3));
        wait(0.2f);
        lcd.locate(0,9); 
        lcd.printf("A5VDC: %4.1f V ",(ain5.read()*3.3));
        wait(0.2f);
        led = 1;
        wait(0.2f);
    }
}