#include "mbed.h"
#include "wire.h"
 
#define SCL         7  
#define SDA         30
 
TwoWire Wire = TwoWire(NRF_TWI1);

int main(void)
{
    Wire.begin(SCL, SDA, TWI_FREQUENCY_100K);
    printf("IIC Demo Start \r\n");

    while(1)
    {
        int nDevices = 0;
        for(int address = 1; address < 127; address++ ) 
        {
            int error = -1;
            Wire.beginTransmission(address << 1);
            Wire.write(0x00);
            error = Wire.endTransmission();
                       
            if (error == 0)
            {
              printf("I2C device found at address %d 0x%X %d \n\r",address, address, error); //Returns 7-bit address
              nDevices++;
            }
        }
        if (nDevices == 0)
        {
            printf("No I2C devices found\n\r");
        }
        else{}
        printf("\ndone\n\r");
        
        wait(2);           // wait 2 seconds for next scan
          
    }
}
 