#include "mbed.h"
#include "DHT.h"


//  STM32L476VGT DISCOVERY BOARD
//  DHT11 SENSOR RUNNING FROM 3V3 SUPPLY
//  PULL DOWN WITH 10K RESISTOR
//  DATA VIA THE PIN PA_0 
//  COM PORT 4 AT 9600 BAUD


#define   DHT_DATA_PIN  PA_0                        // sets pin PA_0 as data input
 
DHT sensor(DHT_DATA_PIN, DHT11);              
      //DHT(PinName pin, eType DHTtype)
 
int main()
{
    int error = 0;
   float h = 0.0f, c = 0.0f, f = 0.0f, k = 0.0f, dp = 0.0f, dpf = 0.0f;
   
    while(1) 
    {
        wait(2.0f);                                 //wait 2 second
        error = sensor.readData();                  //read error value
        if (error == 0)                             //case: no error 
        {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            k   = sensor.ReadTemperature(KELVIN);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            dpf = sensor.CalcdewPointFast(c, h);
            printf("F: %4.2f, \r\n", f);            //prints temp in farenheit to Real Term
 //           printf("H: %4.2f, \r\n", h);          //prints humidity to Real Term
            printf(" \r\n ");                       //acts as empty line to space readings in Real Term
            printf(" \r\n ");                       //acts as empty line to space readings in Real Term
        } 
        else                                        //case: error
        {
            printf("Error: %d\r\n", error);         //prints error to Real Term when "if" criteria isn't satisfied
        }
    }
}