#include "mbed.h"
#include "def.h"
#include "Step_Motor.h"
DigitalOut output1(LED1); // digital output 




    stepmotor motorST(D6,D7,D8,D9,D10,D11,D12,D13);


DigitalOut myled(LED1); //Led

Serial pc(USBTX,USBRX); //Comunicacion Serial

PwmOut mypwmX(PB_3); //Servo eje x
PwmOut mypwmY(PB_5); //Servo eje y
PwmOut mypwmZ(PB_4); //Servo eje z

uint32_t mem_head = 0;  // SI SUBE LA CABEZA ES PORQUE ESTA GUADANDO
uint32_t mem_tail = 0;  // SI SUBE LA COLA ES PORQUE SE EMPIEZAN A LEER LAS MEMORIAS
uint32_t full=0;

MEM_TYPE buffer[MEM_SIZE]; // EL ARREGLO VA A TENER EL TAMAÑO DE MEMSIZE ----> BUFFER ES L ARREGLO

void mem_free() // LIBRERIA MEMORIA
{
    mem_head=0;
    full=0;
    mem_tail=0;
}

uint32_t mem_put(MEM_TYPE data) // 
{
    if(full)  // SI LA MEMORIA ESTA LLENA
    {
        return 1; // 
    }
    buffer [mem_head]=data;  // GUARDAR EL DATO EN LA POSICION MEM_HEAD DEL ARREGLO BUFFER
    mem_head+=1; // SE SUMA UNA POSICION A LA CABEZERA
    if(mem_head==MEM_SIZE)
    {
        full=1; 
    }
    return 0; // TODO EN ORDEN
}

uint32_t mem_get(MEM_TYPE* data) // EL * LE INDICA QUE ES UN APUNTADOR
{
    if(mem_head == 0) // NO HAY DATOS
        return 1;
    if (mem_head == mem_tail) // YA SE TERMINO LA LECTURA DE DATOS
        return 1;
        
    *data=buffer[mem_tail];  // SE LE CARGA A DATA LO QUE ESTA EN BUFFER EN LA POSICION MEM_TAIL
    mem_tail +=1; // SE INCREMENTA EL APUNTADOR MEM_TAIL
    
    return 0;
}

void Vertex2D(uint8_t,uint8_t);
void SetZ(uint8_t);
uint8_t x,y,z;
int xant=0,yant=0,xnew=0,ynew=0,xmov=0,ymov=0; // POSICIONES DEL PICOLO EN LA MATRIZ
int mm2pulse(float vmm); //FUNCION MILIMETROS A PULSOS
void ejecutar();
int guardar();
void P_Pause();

int main()
{
    mypwmX.period_ms(20);
    mypwmY.period_ms(20);
    mypwmZ.period_ms(20);
    uint8_t letra,subletra;
    
    Vertex2D(0,0);        
    SetZ(NODRAW);
    myled = 1;
    wait(2);
    pc.baud(9600);              
    pc.format(8,SerialBase::None,1); 
    while(1) 
    {
        pc.printf("ingrese comando \n");
        letra=pc.getc(); //PRIMER COMANDO FF O FE    
            if(letra==CM_EJECUTAR)
            {
                if(mem_head!=mem_tail) // SI ES DIFERENTE ES PORQUE HAY DATOS EN LA MEMORIA
                { 
                    pc.attach(&P_Pause,Serial::RxIrq);
                    ejecutar();
                    pc.attach(0,Serial::RxIrq);
                }
                else{
                    pc.printf("La memoria se encuentra vacia \n");
                } 
                }
            else if(letra==CM_GUARDAR){
                if(guardar()==0) // LA FUNCION GUARDAR RETORNO UN 0, TODO SE ESTA GUARDANDO CORRECTAMENTE
                {
                    pc.printf("el programa se guardo correctamente \n");
                }
                else
                {
                    pc.printf("el programa no se pudo guardar... vuelva a intentar \n");
                }
                }
            else{ pc.printf("error de comando \n");}
            
        }
        
}
int mm2pulse(float vmm)
{
  if (vmm < MAXPOS) // SI NO SOBREPASA LOS 50 mm
    return int (vmm*(MAXPULSE-MINPULSE)/(MAXPOS)) +MINPULSE; // SE REALIZA ESTA OPERACION DE CONVVERCION
  return MAXPULSE; // SINO, RETORNA MAXPULSE
}
void SetZ(uint8_t _z)
{
    z=_z;
    int PULSEZ=mm2pulse(z); // SE HACE PASO DE MILIMETROS A PULSO Y SE GUARDA EN Z
    mypwmZ.pulsewidth_us(PULSEZ); 
}
void Vertex2D(uint8_t _x,uint8_t _y)
{
    x=_x;
    y=_y;
    int PULSEX=mm2pulse(x);
    int PULSEY=mm2pulse(50-y);
    mypwmX.pulsewidth_us(PULSEX);
    mypwmY.pulsewidth_us(PULSEY);   
}
void ejecutar()
{                                  
    pc.printf("el programa se esta ejecutando \n");
    uint8_t a=0,b=0,c=0,d=0; // SE CREAN 4 VARIABLES DE 8 BITS
    uint32_t l,l1,l2,l3; // SE CREAN 4 VARIABLES DE 32 BITS
    MEM_TYPE val; //
    mem_get(&val); // LLAMA A LA MEMORIA Y LO CARGA A VAL
    l1=(val&0xff00)>>8; // OBTIENE EL TERCER DATO
    l2=(val&0xff0000)>>16; // OBTIENE EL SEGUNDO VALOR QUE INGRESAMOS
    l3=(val&0xff000000)>>24; // OBTIENE EL PRIMER DATO QUE INGRESAMOS
    l=val&0xff; // OBTIENE EL ULTIMO DATO QUE INGRESAMOS
    int noy;
    while(c!=CM_END) // SI EL TERCER VALOR ES FA
    {
        a=l3;
        pc.putc(a);
        b=l2;
        pc.putc(b);
        c=l1;
        pc.putc(c);
        d=l;
        pc.putc(d);
        if(a==CM_SERVO)
        {
            Vertex2D(b,c);           
        }
        else if(a==CM_MOTORSTEP)
        {
            xnew=b;
            ynew=c;
            xmov=xnew-xant;
            ymov=ynew-yant;
            xant=xnew;
            yant=ynew;
            if(xmov==0)
            {
                if(ymov>0)                                       //los valores de 1024 es estandar .step(#pasos,sentido) donde el sentido 0 es girar izquierda, 1 s girar derecha, 2 es avanzar y 3 es retroceder 
                {
                    noy=STAN*abs(ymov);
                    motorST.step(noy,FORWARD);                        //se mueve para adelante
                }
                else if(ymov<0)
                {
                    noy=STAN*abs(ymov);
                    motorST.step(noy,BEHIND);                        //se mueve para atras
                }
            }
            else if(xmov>0)
            {
                 motorST.step(STAN,RIGHT);
                 noy=STAN*abs(xmov);
                 motorST.step(noy,FORWARD);
                 motorST.step(STAN,LEFT);                           //gira a la derecha y se mueve los cuadrantes y vuelve a girar a la misma posicion
            }  
            else if(xmov<0)
            {
                 motorST.step(STAN,LEFT);
                 noy=STAN*abs(xmov);
                 motorST.step(noy,FORWARD);
                 motorST.step(STAN,RIGHT);                            //gira a la izquierda y se mueve los cuadrantes y vuelve a girar a la misma posicion
            }
            if(ymov==0){}                               //ya esta en esa posicion
            else if(xmov>0)
            {
                noy=STAN*abs(ymov);
                motorST.step(noy,FORWARD);                            //se mueve a esa posicion avanzando
            }
            else if(xmov<0)
            {
                noy=STAN*abs(ymov);
                motorST.step(noy,BEHIND);                             //se mueve a esa posicion retrocediendo
            }
        }
        else if(c==CM_SDRAW)
        {
            SetZ(DRAW);              
        }
        else if(c==CM_SN0DRAW)
        {
            SetZ(NODRAW);            
        }
        mem_get(&val); // LO QUE HAY EN LA MEMORIA SE GUERDE EN VAL
        l1=(val&0xff00)>>8; // LLAMA A LA MEMORIA Y SE VUELVE A HACER LA SEPARACION
        l2=(val&0xff0000)>>16;
        l3=(val&0xff000000)>>24;
        l=val&0xff;
        wait(1);
    }
    pc.printf("el programa se termino de ejecutar \n");
    mem_tail=0; // DEVUELVE LA COLA POR SI SE QUIERE VOLVER A REPRODUCIR 
}
int guardar()
{
    mem_free();// LIBERA MEMORIA
    uint32_t l=0;// LIBERA MEMORIA
    uint8_t sl; // LA QUE VA SER RECIBIDA POR LA COMUNICACION SERIAL
    pc.printf("ingrese sus comandos y coordenadas \n");
    sl=pc.getc(); // VA A COGER LO DEL PUERTO SERIAL Y 
    pc.putc(sl);
    while(sl!=CM_END) // SI ES DIFERENTE A FA
    {
        switch(sl)
        {
            case CM_SERVO:
                l=l+sl<<8; // SE LE ASIGNA LA VARIABLE DE 8 BITS Y SE CORRE LA POSICION 8 BITS
                sl=pc.getc(); // SE GUARDA EN SL EL NUEVO COMANDO
                l=l+sl;
                pc.putc(l);
                l=l<<8;
                sl=pc.getc();
                l=l+sl;
                pc.putc(l);
                l=l<<8;
                sl=pc.getc();
                if(sl!=CM_STOP) // SI A LO QUE LLEO FUE A F0
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                l=l+sl;
                pc.putc(l);
                mem_put(l); // SE GUARDA L , QUE YA ES UN VALOR DE 32 BITS
            break;
            case CM_SDRAW:
                l=l+sl<<8;
                sl=pc.getc();
                if(sl!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                l=l+sl;
                mem_put(l);
            break;
            case CM_SN0DRAW:
                l=l+sl<<8;
                sl=pc.getc();
                if(sl!=CM_STOP)
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                l=l+sl;
                mem_put(l);
            break; 
            case CM_MOTORSTEP:
                l=l+sl<<8; // SE LE ASIGNA LA VARIABLE DE 8 BITS Y SE CORRE LA POSICION 8 BITS
                sl=pc.getc(); // SE GUARDA EN SL EL NUEVO COMANDO
                l=l+sl;
                pc.putc(l);
                l=l<<8;
                sl=pc.getc();
                l=l+sl;
                pc.putc(l);
                l=l<<8;
                sl=pc.getc();
                if(sl!=CM_STOP) // SI A LO QUE LLEO FUE A F0
                {
                    pc.printf("comando End no definido \n");
                    return 1;
                }
                l=l+sl;
                pc.putc(l);
                mem_put(l);
            break;
        }
        l=0;
        sl=pc.getc();   
    }
    sl=pc.getc();
    pc.printf("el programa termino de guardar \n");
    mem_put(0xfaf0);
    return 0;
}

void P_Pause()
{
    int g=pc.getc();
    if(g==PAUSE)
    {
        pc.attach(0,Serial::RxIrq);
        pc.printf("interrupcion \n");
        while(pc.getc()!=PLAY){}
        pc.attach(&P_Pause,Serial::RxIrq);
    }
    return;
}





